/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.Activation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.PassiveActivation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.activation.trigger.ActivationTrigger;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.targeting.AbilityTargeting;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public record SelfTarget(Either<AbilityTargeting.BlockTargeting, AbilityTargeting.EntityTargeting> target) implements AbilityTargeting
{
    @Translation(comments={"Targets self"})
    private static final String SELF_TARGET = Translation.Type.GUI.wrap("ability_target.self_target");
    public static final MapCodec<SelfTarget> CODEC = RecordCodecBuilder.mapCodec(instance -> AbilityTargeting.codecStart(instance).apply((Applicative)instance, SelfTarget::new));

    @Override
    public void apply(ServerPlayer dragon, DragonAbilityInstance ability) {
        this.target().ifLeft(blockTarget -> {
            if (blockTarget.matches(dragon, dragon.blockPosition())) {
                blockTarget.effects().forEach(target -> target.apply(dragon, ability, dragon.blockPosition(), null));
            }
        }).ifRight(entityTarget -> {
            if (entityTarget.matches(dragon, (Entity)dragon, dragon.position())) {
                entityTarget.effects().forEach(target -> target.apply(dragon, ability, (Entity)dragon));
            } else {
                PassiveActivation passive;
                Activation patt0$temp = ability.value().activation();
                if (patt0$temp instanceof PassiveActivation && (passive = (PassiveActivation)patt0$temp).trigger().type() == ActivationTrigger.TriggerType.CONSTANT) {
                    entityTarget.effects().forEach(target -> target.remove(dragon, ability, (Entity)dragon, true));
                }
            }
        });
    }

    @Override
    public void remove(ServerPlayer dragon, DragonAbilityInstance ability) {
        this.target().ifRight(entityTarget -> entityTarget.effects().forEach(target -> target.remove(dragon, ability, (Entity)dragon, false)));
    }

    @Override
    public MutableComponent getDescription(Player dragon, DragonAbilityInstance ability) {
        return Component.translatable((String)SELF_TARGET);
    }

    @Override
    public MapCodec<? extends AbilityTargeting> codec() {
        return CODEC;
    }
}

