/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade;

import by.dragonsurvivalteam.dragonsurvival.registry.datagen.Translation;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.DragonAbilityInstance;
import by.dragonsurvivalteam.dragonsurvival.registry.dragon.ability.upgrade.UpgradeType;
import by.dragonsurvivalteam.dragonsurvival.util.ExperienceUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.NumberFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public record ExperiencePointsUpgrade(int maxLevel, LevelBasedValue experienceCost) implements UpgradeType<Type>
{
    @Translation(comments={"\u00a76\u25a0 Skill upgrade costs: %s\u00a76 experience points (level %s\u00a76)."})
    private static final String EXPERIENCE_POINTS_UPGRADE = Translation.Type.GUI.wrap("ability_upgrade.experience_points_upgrade");
    public static final MapCodec<ExperiencePointsUpgrade> CODEC = RecordCodecBuilder.mapCodec(instance -> UpgradeType.codecStart(instance).and((App)LevelBasedValue.CODEC.fieldOf("experience_cost").forGetter(ExperiencePointsUpgrade::experienceCost)).apply((Applicative)instance, ExperiencePointsUpgrade::new));
    private static final NumberFormat FORMAT = Functions.getFormat(2);

    @Override
    public boolean apply(ServerPlayer dragon, DragonAbilityInstance ability, Type type) {
        int experiencePoints;
        if (type == Type.UPGRADE && !this.canUpgrade(dragon, ability)) {
            return false;
        }
        if (type == Type.DOWNGRADE && !this.canDowngrade(dragon, ability)) {
            return false;
        }
        if (!dragon.hasInfiniteMaterials() && (experiencePoints = this.getExperience(ability, type)) != 0) {
            dragon.giveExperiencePoints(experiencePoints);
        }
        ability.setLevel(ability.level() + type.step());
        return true;
    }

    @Override
    public MutableComponent getDescription(int abilityLevel) {
        int experiencePoints = (int)this.experienceCost.calculate(abilityLevel);
        return Component.translatable((String)EXPERIENCE_POINTS_UPGRADE, (Object[])new Object[]{experiencePoints, FORMAT.format(ExperienceUtils.getLevelAndProgress(experiencePoints))});
    }

    @Override
    public boolean canUpgrade(ServerPlayer dragon, DragonAbilityInstance ability) {
        return this.canModifyLevel((Player)dragon, ability, Type.UPGRADE);
    }

    @Override
    public boolean canDowngrade(ServerPlayer dragon, DragonAbilityInstance ability) {
        return this.canModifyLevel((Player)dragon, ability, Type.DOWNGRADE);
    }

    public boolean canModifyLevel(Player player, DragonAbilityInstance ability, Type type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (ability.level() < this.maxLevel() && (player.hasInfiniteMaterials() || ExperienceUtils.getTotalExperience(player) >= Math.abs(this.getExperience(ability, type)))) {
                    yield true;
                }
                yield false;
            }
            case 1 -> ability.level() > this.minLevel() && this.getExperience(ability, type) != 0;
        };
    }

    public int getExperience(DragonAbilityInstance ability, Type type) {
        int newLevel = ability.level() + type.step();
        int experience = (int)this.experienceCost.calculate(type == Type.UPGRADE ? newLevel : ability.level());
        return type == Type.UPGRADE ? -experience : experience;
    }

    @Override
    public MapCodec<? extends UpgradeType<?>> codec() {
        return CODEC;
    }

    public static enum Type {
        UPGRADE(1),
        DOWNGRADE(-1);

        private final int step;

        private Type(int step) {
            this.step = step;
        }

        public int step() {
            return this.step;
        }
    }
}

