/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.plantsvszombies.block;

import net.mcreator.plantsvszombies.procedures.ThistleMobplayerCollidesWithPlantProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;

public class ThistleBlock
extends DoublePlantBlock {
    public ThistleBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.GRASS).instabreak().noCollission().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.DAMAGE_CAUTIOUS;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    private boolean canPlantTypeSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return state.is(BlockTags.DIRT) || state.getBlock() == Blocks.FARMLAND;
    }

    public boolean canSurvive(BlockState blockstate, LevelReader world, BlockPos pos) {
        BlockPos posbelow = pos.below();
        BlockState statebelow = world.getBlockState(posbelow);
        if (blockstate.getValue((Property)HALF) != DoubleBlockHalf.UPPER) {
            if (blockstate.getBlock() == this) {
                return this.canPlantTypeSurvive(statebelow, world, posbelow);
            }
            return this.mayPlaceOn(statebelow, (BlockGetter)world, posbelow);
        }
        return statebelow.is((Block)this) && statebelow.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    public void entityInside(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.entityInside(blockstate, world, pos, entity);
        ThistleMobplayerCollidesWithPlantProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), entity);
    }
}

