/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.plantsvszombies.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.mcreator.plantsvszombies.client.model.Modeltumbleweed;
import net.mcreator.plantsvszombies.client.model.animations.tumbleweedAnimation;
import net.mcreator.plantsvszombies.entity.TumbleweedEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class TumbleweedRenderer
extends MobRenderer<TumbleweedEntity, Modeltumbleweed<TumbleweedEntity>> {
    public TumbleweedRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modeltumbleweed.LAYER_LOCATION)), 0.4f);
    }

    protected void scale(TumbleweedEntity entity, PoseStack poseStack, float f) {
        poseStack.scale(entity.getAgeScale(), entity.getAgeScale(), entity.getAgeScale());
    }

    public ResourceLocation getTextureLocation(TumbleweedEntity entity) {
        return ResourceLocation.parse((String)"plantsvszombies:textures/entities/tumbleweed.png");
    }

    private static final class AnimatedModel
    extends Modeltumbleweed<TumbleweedEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<TumbleweedEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(TumbleweedEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(tumbleweedAnimation.spin, limbSwing, limbSwingAmount, 1.0f, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(TumbleweedEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

