/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.plantsvszombies.item;

import java.util.List;
import java.util.stream.Stream;
import net.mcreator.plantsvszombies.init.PlantsvszombiesModBlocks;
import net.mcreator.plantsvszombies.procedures.GrasspickerRightclickedOnBlockProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GrasspickerItem
extends Item {
    public GrasspickerItem() {
        super(new Item.Properties().durability(300).attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getDestroySpeed(ItemStack itemstack, BlockState blockstate) {
        if (List.of(Blocks.GRASS_BLOCK, Blocks.MYCELIUM, (Block)PlantsvszombiesModBlocks.FERTILEGRASS.get(), Blocks.DIRT_PATH, Blocks.PODZOL, Blocks.ROOTED_DIRT).contains(blockstate.getBlock())) return 6.0f;
        if (!Stream.of(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:dirt"))).anyMatch(arg_0 -> ((BlockState)blockstate).is(arg_0))) return 1.0f;
        return 6.0f;
    }

    public boolean mineBlock(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        itemstack.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
        return true;
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        itemstack.hurtAndBreak(2, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
        return true;
    }

    public int getEnchantmentValue() {
        return 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"item.plantsvszombies.grasspicker.description_0"));
    }

    public InteractionResult useOn(UseOnContext context) {
        super.useOn(context);
        GrasspickerRightclickedOnBlockProcedure.execute((LevelAccessor)context.getLevel(), context.getClickedPos().getX(), context.getClickedPos().getY(), context.getClickedPos().getZ(), (Entity)context.getPlayer(), context.getItemInHand());
        return InteractionResult.SUCCESS;
    }
}

