/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.plantsvszombies.procedures;

import java.util.Comparator;
import net.mcreator.plantsvszombies.entity.CactusprojectileEntity;
import net.mcreator.plantsvszombies.init.PlantsvszombiesModEntities;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CactusOnEntityTickUpdateProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (!world.getEntitiesOfClass(Monster.class, new AABB(Vec3.ZERO, Vec3.ZERO).move(new Vec3(x, y, z)).inflate(15.0), e -> true).isEmpty() && CactusOnEntityTickUpdateProcedure.findEntityInWorldRange(world, Monster.class, x, y, z, 30.0).getType().is(EntityTypeTags.UNDEAD)) {
            entity.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3(CactusOnEntityTickUpdateProcedure.findEntityInWorldRange(world, Monster.class, x, y, z, 30.0).getX(), CactusOnEntityTickUpdateProcedure.findEntityInWorldRange(world, Monster.class, x, y, z, 30.0).getY(), CactusOnEntityTickUpdateProcedure.findEntityInWorldRange(world, Monster.class, x, y, z, 30.0).getZ()));
            entity.getPersistentData().putDouble("attackcool", entity.getPersistentData().getDouble("attackcool") - 1.0);
            if (entity.getPersistentData().getDouble("attackcool") < 1.0) {
                entity.getPersistentData().putDouble("attackcool", 30.0);
                Entity _shootFrom = entity;
                Level projectileLevel = _shootFrom.level();
                if (!projectileLevel.isClientSide()) {
                    AbstractArrow _entityToSpawn = CactusOnEntityTickUpdateProcedure.initArrowProjectile(new CactusprojectileEntity((EntityType<? extends CactusprojectileEntity>)((EntityType)PlantsvszombiesModEntities.CACTUSPROJECTILE.get()), 0.0, 0.0, 0.0, projectileLevel, CactusOnEntityTickUpdateProcedure.createArrowWeaponItemStack(projectileLevel, 0, (byte)3)), entity, 5.0f, true, false, false, AbstractArrow.Pickup.DISALLOWED);
                    _entityToSpawn.setPos(_shootFrom.getX(), _shootFrom.getEyeY() - 0.1, _shootFrom.getZ());
                    _entityToSpawn.shoot(_shootFrom.getLookAngle().x, _shootFrom.getLookAngle().y, _shootFrom.getLookAngle().z, 1.5f, 0.0f);
                    projectileLevel.addFreshEntity((Entity)_entityToSpawn);
                }
            }
        }
    }

    private static Entity findEntityInWorldRange(LevelAccessor world, Class<? extends Entity> clazz, double x, double y, double z, double range) {
        return world.getEntitiesOfClass(clazz, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)range, (double)range, (double)range), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(x, y, z))).findFirst().orElse(null);
    }

    private static AbstractArrow initArrowProjectile(AbstractArrow entityToSpawn, Entity shooter, float damage, boolean silent, boolean fire, boolean particles, AbstractArrow.Pickup pickup) {
        entityToSpawn.setOwner(shooter);
        entityToSpawn.setBaseDamage((double)damage);
        if (silent) {
            entityToSpawn.setSilent(true);
        }
        if (fire) {
            entityToSpawn.igniteForSeconds(100.0f);
        }
        if (particles) {
            entityToSpawn.setCritArrow(true);
        }
        entityToSpawn.pickup = pickup;
        return entityToSpawn;
    }

    private static ItemStack createArrowWeaponItemStack(Level level, int knockback, byte piercing) {
        ItemStack weapon = new ItemStack((ItemLike)Items.ARROW);
        if (knockback > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), knockback);
        }
        if (piercing > 0) {
            weapon.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.PIERCING), (int)piercing);
        }
        return weapon;
    }
}

