/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidType;
import net.povstalec.sgjourney.client.Layers;
import net.povstalec.sgjourney.client.models.block.CableModelLoader;
import net.povstalec.sgjourney.client.render.FalconArmorRenderProperties;
import net.povstalec.sgjourney.client.render.JackalArmorRenderProperties;
import net.povstalec.sgjourney.client.render.block_entity.CartoucheRenderer;
import net.povstalec.sgjourney.client.render.block_entity.ClassicStargateRenderer;
import net.povstalec.sgjourney.client.render.block_entity.MilkyWayStargateRenderer;
import net.povstalec.sgjourney.client.render.block_entity.PegasusStargateRenderer;
import net.povstalec.sgjourney.client.render.block_entity.SymbolBlockRenderer;
import net.povstalec.sgjourney.client.render.block_entity.TollanStargateRenderer;
import net.povstalec.sgjourney.client.render.block_entity.TransportRingsRenderer;
import net.povstalec.sgjourney.client.render.block_entity.UniverseStargateRenderer;
import net.povstalec.sgjourney.client.render.entity.AnthropoidRenderer;
import net.povstalec.sgjourney.client.render.entity.GoauldRenderer;
import net.povstalec.sgjourney.client.render.entity.PlasmaProjectileRenderer;
import net.povstalec.sgjourney.client.render.level.SGJourneyDimensionSpecialEffects;
import net.povstalec.sgjourney.client.resourcepack.ResourcepackReloadListener;
import net.povstalec.sgjourney.client.screens.BatteryScreen;
import net.povstalec.sgjourney.client.screens.ClassicDHDScreen;
import net.povstalec.sgjourney.client.screens.CrystallizerScreen;
import net.povstalec.sgjourney.client.screens.DHDCrystalScreen;
import net.povstalec.sgjourney.client.screens.InterfaceScreen;
import net.povstalec.sgjourney.client.screens.LiquidizerScreen;
import net.povstalec.sgjourney.client.screens.MilkyWayDHDScreen;
import net.povstalec.sgjourney.client.screens.NaquadahGeneratorScreen;
import net.povstalec.sgjourney.client.screens.PegasusDHDScreen;
import net.povstalec.sgjourney.client.screens.RingPanelScreen;
import net.povstalec.sgjourney.client.screens.TransceiverScreen;
import net.povstalec.sgjourney.client.screens.ZPMHubScreen;
import net.povstalec.sgjourney.client.screens.config.ConfigScreen;
import net.povstalec.sgjourney.common.capabilities.AncientGene;
import net.povstalec.sgjourney.common.capabilities.BloodstreamNaquadah;
import net.povstalec.sgjourney.common.capabilities.GoauldHost;
import net.povstalec.sgjourney.common.compatibility.cctweaked.CCTweakedCompatibility;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.fluids.HeavyNaquadahFluidType;
import net.povstalec.sgjourney.common.fluids.NaquadahFluidType;
import net.povstalec.sgjourney.common.init.AdvancementInit;
import net.povstalec.sgjourney.common.init.AttachmentTypeInit;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.CommandInit;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.init.EntityInit;
import net.povstalec.sgjourney.common.init.FeatureInit;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.init.FluidTypeInit;
import net.povstalec.sgjourney.common.init.GalaxyInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.MenuInit;
import net.povstalec.sgjourney.common.init.MiscInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.init.RecipeTypeInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.init.StargateInit;
import net.povstalec.sgjourney.common.init.StatisticsInit;
import net.povstalec.sgjourney.common.init.StructureInit;
import net.povstalec.sgjourney.common.init.StructurePlacementInit;
import net.povstalec.sgjourney.common.init.TabInit;
import net.povstalec.sgjourney.common.init.TransporterInit;
import net.povstalec.sgjourney.common.init.VillagerInit;
import net.povstalec.sgjourney.common.items.PowerCellItem;
import net.povstalec.sgjourney.common.items.RingRemoteItem;
import net.povstalec.sgjourney.common.items.StaffWeaponItem;
import net.povstalec.sgjourney.common.items.VialItem;
import net.povstalec.sgjourney.common.items.ZeroPointModule;
import net.povstalec.sgjourney.common.items.armor.PersonalShieldItem;
import net.povstalec.sgjourney.common.items.crystals.EnergyCrystalItem;
import net.povstalec.sgjourney.common.items.properties.FluidPropertyFunction;
import net.povstalec.sgjourney.common.items.properties.WeaponStatePropertyFunction;
import net.povstalec.sgjourney.common.misc.RenderAMD;
import net.povstalec.sgjourney.common.sgjourney.AddressTable;
import net.povstalec.sgjourney.common.sgjourney.Galaxy;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.SolarSystem;
import net.povstalec.sgjourney.common.sgjourney.StargateVariant;
import net.povstalec.sgjourney.common.sgjourney.SymbolSet;
import net.povstalec.sgjourney.common.sgjourney.Symbols;
import net.povstalec.sgjourney.common.world.biomemod.BiomeModifiers;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.slf4j.Logger;

@Mod(value="sgjourney")
public class StargateJourney {
    public static final String MODID = "sgjourney";
    public static final ResourceLocation EMPTY_LOCATION = StargateJourney.sgjourneyLocation("empty");
    public static final String EMPTY = EMPTY_LOCATION.toString();
    public static final String STELLAR_VIEW_MODID = "stellarview";
    public static final String IRIS_MODID = "iris";
    public static final String COMPUTERCRAFT_MODID = "computercraft";
    @Nullable
    private static Boolean isStellarViewLoaded = null;
    @Nullable
    private static Boolean isIrisLoaded = null;
    public static final Logger LOGGER = LogUtils.getLogger();

    public StargateJourney(IEventBus eventBus, ModContainer modContainer, Dist dist) {
        DataComponentInit.register(eventBus);
        ItemInit.register(eventBus);
        BlockInit.register(eventBus);
        FluidInit.register(eventBus);
        FluidTypeInit.register(eventBus);
        BlockEntityInit.register(eventBus);
        MenuInit.register(eventBus);
        VillagerInit.register(eventBus);
        FeatureInit.register(eventBus);
        StructureInit.register(eventBus);
        BiomeModifiers.register(eventBus);
        EntityInit.register(eventBus);
        SoundInit.register(eventBus);
        TabInit.register(eventBus);
        RecipeTypeInit.register(eventBus);
        StatisticsInit.register(eventBus);
        CommandInit.register(eventBus);
        StructurePlacementInit.register(eventBus);
        GalaxyInit.register(eventBus);
        AdvancementInit.register(eventBus);
        AttachmentTypeInit.register(eventBus);
        eventBus.addListener(event -> {
            event.dataPackRegistry(SymbolSet.REGISTRY_KEY, SymbolSet.CODEC, SymbolSet.CODEC);
            event.dataPackRegistry(Symbols.REGISTRY_KEY, Symbols.CODEC, Symbols.CODEC);
            event.dataPackRegistry(Galaxy.REGISTRY_KEY, Galaxy.CODEC, Galaxy.CODEC);
            event.dataPackRegistry(PointOfOrigin.REGISTRY_KEY, PointOfOrigin.CODEC, PointOfOrigin.CODEC);
            event.dataPackRegistry(SolarSystem.REGISTRY_KEY, SolarSystem.CODEC, SolarSystem.CODEC);
            event.dataPackRegistry(AddressTable.REGISTRY_KEY, AddressTable.CODEC, AddressTable.CODEC);
            event.dataPackRegistry(StargateVariant.REGISTRY_KEY, StargateVariant.CODEC, StargateVariant.CODEC);
        });
        eventBus.addListener(StargateJourney::onRegisterCapabilities);
        eventBus.addListener(GalaxyInit::registerRegistries);
        eventBus.addListener(this::commonSetup);
        eventBus.addListener(PacketHandlerInit::registerPackets);
        eventBus.addListener(Layers::registerLayers);
        eventBus.addListener(TabInit::addCreative);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)StargateJourneyConfig.CLIENT_CONFIG, "sgjourney-client.toml");
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)StargateJourneyConfig.COMMON_CONFIG, "sgjourney-common.toml");
        if (dist.isClient()) {
            ConfigScreen.registerConfigScreen(modContainer);
        }
        NeoForge.EVENT_BUS.addListener(MiscInit::registerCommands);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            StatisticsInit.register();
            StargateInit.register();
            TransporterInit.register();
        });
    }

    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> new EnergyCrystalItem.Energy((ItemStack)stack), new ItemLike[]{ItemInit.ENERGY_CRYSTAL, ItemInit.ENERGY_CRYSTAL});
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> new EnergyCrystalItem.Energy((ItemStack)stack), new ItemLike[]{ItemInit.ENERGY_CRYSTAL, ItemInit.ADVANCED_ENERGY_CRYSTAL});
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> new PowerCellItem.Energy((ItemStack)stack), new ItemLike[]{ItemInit.NAQUADAH_POWER_CELL});
        event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, context) -> new ZeroPointModule.Energy((ItemStack)stack), new ItemLike[]{ItemInit.ZPM});
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, context) -> new RingRemoteItem.ItemHandler((MutableDataComponentHolder)stack, (DataComponentType<ItemContainerContents>)DataComponents.CONTAINER), new ItemLike[]{ItemInit.RING_REMOTE});
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, context) -> new StaffWeaponItem.FluidItemHandler((ItemStack)stack, (DataComponentType<ItemContainerContents>)DataComponents.CONTAINER), new ItemLike[]{ItemInit.MATOK});
        event.registerItem(Capabilities.ItemHandler.ITEM, (stack, context) -> new PowerCellItem.FluidItemHandler((ItemStack)stack, (DataComponentType<ItemContainerContents>)DataComponents.CONTAINER), new ItemLike[]{ItemInit.NAQUADAH_POWER_CELL});
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, context) -> new StaffWeaponItem.FluidItemHandler((ItemStack)stack, (DataComponentType<ItemContainerContents>)DataComponents.CONTAINER), new ItemLike[]{ItemInit.MATOK});
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, context) -> new VialItem.FluidHandler(() -> (DataComponentType)DataComponentInit.FLUID.get(), (ItemStack)stack), new ItemLike[]{ItemInit.VIAL});
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, context) -> new PowerCellItem.FluidItemHandler((ItemStack)stack, (DataComponentType<ItemContainerContents>)DataComponents.CONTAINER), new ItemLike[]{ItemInit.NAQUADAH_POWER_CELL});
        event.registerItem(Capabilities.FluidHandler.ITEM, (stack, context) -> new PersonalShieldItem.FluidHandler(() -> (DataComponentType)DataComponentInit.FLUID.get(), (ItemStack)stack), new ItemLike[]{ItemInit.PERSONAL_SHIELD_EMITTER});
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.UNIVERSE_STARGATE.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.MILKY_WAY_STARGATE.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.PEGASUS_STARGATE.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.TOLLAN_STARGATE.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.CLASSIC_STARGATE.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.MILKY_WAY_DHD.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.PEGASUS_DHD.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.CLASSIC_DHD.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.TRANSPORT_RINGS.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.NAQUADAH_GENERATOR_MARK_I.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.NAQUADAH_GENERATOR_MARK_II.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.BASIC_INTERFACE.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.CRYSTAL_INTERFACE.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.ADVANCED_CRYSTAL_INTERFACE.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.ZPM_HUB.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.NAQUADAH_WIRE.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.SMALL_NAQUADAH_CABLE.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.MEDIUM_NAQUADAH_CABLE.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.LARGE_NAQUADAH_CABLE.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, (BlockEntityType)BlockEntityInit.LARGE_NAQUADAH_BATTERY.get(), (blockEntity, direction) -> blockEntity.getEnergyHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityInit.CLASSIC_DHD.get(), (blockEntity, direction) -> blockEntity.getItemHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityInit.MILKY_WAY_DHD.get(), (blockEntity, direction) -> blockEntity.getItemHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityInit.PEGASUS_DHD.get(), (blockEntity, direction) -> blockEntity.getItemHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityInit.CRYSTALLIZER.get(), (blockEntity, direction) -> blockEntity.getItemHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityInit.ADVANCED_CRYSTALLIZER.get(), (blockEntity, direction) -> blockEntity.getItemHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityInit.NAQUADAH_LIQUIDIZER.get(), (blockEntity, direction) -> blockEntity.getItemHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityInit.HEAVY_NAQUADAH_LIQUIDIZER.get(), (blockEntity, direction) -> blockEntity.getItemHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityInit.RING_PANEL.get(), (blockEntity, direction) -> blockEntity.getItemHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityInit.ZPM_HUB.get(), (blockEntity, direction) -> blockEntity.getItemHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityInit.NAQUADAH_GENERATOR_MARK_I.get(), (blockEntity, direction) -> blockEntity.getItemHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)BlockEntityInit.NAQUADAH_GENERATOR_MARK_II.get(), (blockEntity, direction) -> blockEntity.getItemHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)BlockEntityInit.CRYSTALLIZER.get(), (blockEntity, direction) -> blockEntity.getFluidHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)BlockEntityInit.ADVANCED_CRYSTALLIZER.get(), (blockEntity, direction) -> blockEntity.getFluidHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)BlockEntityInit.NAQUADAH_LIQUIDIZER.get(), (blockEntity, direction) -> blockEntity.getFluidHandler((Direction)direction));
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)BlockEntityInit.HEAVY_NAQUADAH_LIQUIDIZER.get(), (blockEntity, direction) -> blockEntity.getFluidHandler((Direction)direction));
        if (ModList.get().isLoaded(COMPUTERCRAFT_MODID)) {
            CCTweakedCompatibility.registerPeripherals(event);
        }
        event.registerEntity(BloodstreamNaquadah.BLOODSTREAM_NAQUADAH_CAPABILITY, EntityType.VILLAGER, (entity, context) -> new BloodstreamNaquadah((LivingEntity)entity));
        event.registerEntity(BloodstreamNaquadah.BLOODSTREAM_NAQUADAH_CAPABILITY, EntityType.PLAYER, (entity, context) -> new BloodstreamNaquadah((LivingEntity)entity));
        event.registerEntity(AncientGene.ANCIENT_GENE_CAPABILITY, EntityType.VILLAGER, (entity, context) -> new AncientGene((LivingEntity)entity));
        event.registerEntity(AncientGene.ANCIENT_GENE_CAPABILITY, EntityType.PLAYER, (entity, context) -> new AncientGene((LivingEntity)entity));
        event.registerEntity(GoauldHost.GOAULD_HOST_CAPABILITY, EntityType.VILLAGER, (entity, context) -> new GoauldHost((LivingEntity)entity));
        event.registerEntity(GoauldHost.GOAULD_HOST_CAPABILITY, EntityType.PLAYER, (entity, context) -> new GoauldHost((LivingEntity)entity));
    }

    public static boolean isStellarViewLoaded() {
        if (isStellarViewLoaded == null) {
            isStellarViewLoaded = ModList.get().isLoaded(STELLAR_VIEW_MODID);
        }
        return isStellarViewLoaded;
    }

    public static boolean isIrisLoaded() {
        if (isIrisLoaded == null) {
            isIrisLoaded = ModList.get().isLoaded(IRIS_MODID);
        }
        return isIrisLoaded;
    }

    public static boolean shouldRenderAMD() {
        if (StargateJourney.isIrisLoaded()) {
            return false;
        }
        if (ClientStargateConfig.render_amd.get() == RenderAMD.AUTO) {
            return SystemUtils.IS_OS_LINUX;
        }
        return ClientStargateConfig.render_amd.get() == RenderAMD.ENABLED;
    }

    public static ResourceLocation location(String path) {
        return ResourceLocation.withDefaultNamespace((String)path);
    }

    public static ResourceLocation location(String namespace, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static ResourceLocation sgjourneyLocation(String path) {
        return StargateJourney.location(MODID, path);
    }

    @EventBusSubscriber(modid="sgjourney", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ItemProperties.register((Item)((Item)ItemInit.VIAL.get()), (ResourceLocation)StargateJourney.sgjourneyLocation("liquid_naquadah"), (ItemPropertyFunction)new FluidPropertyFunction());
            ItemProperties.register((Item)((Item)ItemInit.NAQUADAH_POWER_CELL.get()), (ResourceLocation)StargateJourney.sgjourneyLocation("liquid_naquadah"), (ItemPropertyFunction)new FluidPropertyFunction());
            ItemProperties.register((Item)((Item)ItemInit.MATOK.get()), (ResourceLocation)StargateJourney.sgjourneyLocation("open"), (ItemPropertyFunction)new WeaponStatePropertyFunction());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidInit.LIQUID_NAQUADAH_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidInit.LIQUID_NAQUADAH_FLOWING.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)FluidInit.HEAVY_LIQUID_NAQUADAH_FLOWING.get()), (RenderType)RenderType.translucent());
            EntityRenderers.register((EntityType)((EntityType)EntityInit.JAFFA_PLASMA.get()), PlasmaProjectileRenderer::new);
            EntityRenderers.register(EntityInit.GOAULD.get(), GoauldRenderer::new);
            EntityRenderers.register(EntityInit.HUMAN.get(), AnthropoidRenderer::new);
            EntityRenderers.register(EntityInit.JAFFA.get(), AnthropoidRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BlockEntityInit.SANDSTONE_CARTOUCHE.get()), CartoucheRenderer.Sandstone::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BlockEntityInit.RED_SANDSTONE_CARTOUCHE.get()), CartoucheRenderer.RedSandstone::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BlockEntityInit.STONE_CARTOUCHE.get()), CartoucheRenderer.Stone::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BlockEntityInit.SANDSTONE_SYMBOL.get()), SymbolBlockRenderer.Sandstone::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BlockEntityInit.RED_SANDSTONE_SYMBOL.get()), SymbolBlockRenderer.RedSandstone::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BlockEntityInit.STONE_SYMBOL.get()), SymbolBlockRenderer.Stone::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BlockEntityInit.TRANSPORT_RINGS.get()), TransportRingsRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BlockEntityInit.UNIVERSE_STARGATE.get()), UniverseStargateRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BlockEntityInit.MILKY_WAY_STARGATE.get()), MilkyWayStargateRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BlockEntityInit.PEGASUS_STARGATE.get()), PegasusStargateRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BlockEntityInit.CLASSIC_STARGATE.get()), ClassicStargateRenderer::new);
            BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)BlockEntityInit.TOLLAN_STARGATE.get()), TollanStargateRenderer::new);
        }

        @SubscribeEvent
        public static void registerMenuScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)MenuInit.INTERFACE.get(), InterfaceScreen::new);
            event.register((MenuType)MenuInit.RING_PANEL.get(), RingPanelScreen::new);
            event.register((MenuType)MenuInit.DHD_CRYSTAL.get(), DHDCrystalScreen::new);
            event.register((MenuType)MenuInit.MILKY_WAY_DHD.get(), MilkyWayDHDScreen::new);
            event.register((MenuType)MenuInit.PEGASUS_DHD.get(), PegasusDHDScreen::new);
            event.register((MenuType)MenuInit.CLASSIC_DHD.get(), ClassicDHDScreen::new);
            event.register((MenuType)MenuInit.NAQUADAH_GENERATOR.get(), NaquadahGeneratorScreen::new);
            event.register((MenuType)MenuInit.ZPM_HUB.get(), ZPMHubScreen::new);
            event.register((MenuType)MenuInit.NAQUADAH_LIQUIDIZER.get(), LiquidizerScreen.LiquidNaquadah::new);
            event.register((MenuType)MenuInit.HEAVY_NAQUADAH_LIQUIDIZER.get(), LiquidizerScreen.HeavyLiquidNaquadah::new);
            event.register((MenuType)MenuInit.CRYSTALLIZER.get(), CrystallizerScreen::new);
            event.register((MenuType)MenuInit.TRANSCEIVER.get(), TransceiverScreen::new);
            event.register((MenuType)MenuInit.NAQUADAH_BATTERY.get(), BatteryScreen::new);
        }

        @SubscribeEvent
        public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
            event.registerItem(new IClientItemExtensions(){

                public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    return JackalArmorRenderProperties.INSTANCE.getHumanoidArmorModel(livingEntity, itemStack, equipmentSlot, original);
                }
            }, new Holder[]{ItemInit.JACKAL_HELMET});
            event.registerItem(new IClientItemExtensions(){

                public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    return FalconArmorRenderProperties.INSTANCE.getHumanoidArmorModel(livingEntity, itemStack, equipmentSlot, original);
                }
            }, new Holder[]{ItemInit.FALCON_HELMET});
            event.registerFluidType(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return NaquadahFluidType.STILL_TEXTURE;
                }

                public ResourceLocation getFlowingTexture() {
                    return NaquadahFluidType.FLOWING_TEXTURE;
                }

                @Nullable
                public ResourceLocation getOverlayTexture() {
                    return NaquadahFluidType.OVERLAY_TEXTURE;
                }

                public int getTintColor() {
                    return -5180631;
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    return new Vector3f(0.4509804f, 0.77254903f, 0.13333334f);
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    RenderSystem.setShaderFogStart((float)1.0f);
                    RenderSystem.setShaderFogEnd((float)6.0f);
                }
            }, new FluidType[]{(FluidType)FluidTypeInit.LIQUID_NAQUADAH_FLUID_TYPE.get()});
            event.registerFluidType(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return HeavyNaquadahFluidType.STILL_TEXTURE;
                }

                public ResourceLocation getFlowingTexture() {
                    return HeavyNaquadahFluidType.FLOWING_TEXTURE;
                }

                @Nullable
                public ResourceLocation getOverlayTexture() {
                    return HeavyNaquadahFluidType.OVERLAY_TEXTURE;
                }

                public int getTintColor() {
                    return -16159744;
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    return new Vector3f(0.4509804f, 0.77254903f, 0.13333334f);
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    RenderSystem.setShaderFogStart((float)1.0f);
                    RenderSystem.setShaderFogEnd((float)6.0f);
                }
            }, new FluidType[]{(FluidType)FluidTypeInit.HEAVY_LIQUID_NAQUADAH_FLUID_TYPE.get()});
        }

        @SubscribeEvent
        public static void registerDimensionEffects(RegisterDimensionSpecialEffectsEvent event) {
            SGJourneyDimensionSpecialEffects.registerStargateJourneyEffects(event);
        }

        @SubscribeEvent
        public static void registerClientReloadListener(RegisterClientReloadListenersEvent event) {
            ResourcepackReloadListener.ReloadListener.registerReloadListener(event);
        }

        @SubscribeEvent
        public static void modelLoaderInit(ModelEvent.RegisterGeometryLoaders event) {
            CableModelLoader.register(event);
        }
    }
}

