/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.povstalec.sgjourney.client.screens.ArcheologistNotebookScreen;
import net.povstalec.sgjourney.client.screens.DialerScreen;
import net.povstalec.sgjourney.client.screens.GDOScreen;
import net.povstalec.sgjourney.common.block_entities.CartoucheEntity;
import net.povstalec.sgjourney.common.block_entities.SymbolBlockEntity;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.MilkyWayStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.PegasusStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.RotatingStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.UniverseStargateEntity;
import net.povstalec.sgjourney.common.block_entities.tech.AbstractCrystallizerEntity;
import net.povstalec.sgjourney.common.block_entities.tech.AbstractNaquadahLiquidizerEntity;
import net.povstalec.sgjourney.common.block_entities.tech.BatteryBlockEntity;
import net.povstalec.sgjourney.common.block_entities.tech.NaquadahGeneratorEntity;
import net.povstalec.sgjourney.common.block_entities.tech.TransceiverEntity;
import net.povstalec.sgjourney.common.block_entities.tech_interface.AbstractInterfaceEntity;
import net.povstalec.sgjourney.common.block_entities.transporter.RingPanelEntity;
import net.povstalec.sgjourney.common.block_entities.transporter.TransportRingsEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.StargateConnection;
import net.povstalec.sgjourney.common.sgjourney.info.IrisInfo;

public class ClientAccess {
    protected static Minecraft minecraft = Minecraft.getInstance();

    public static void openArcheologistNotebookScreen(UUID playerId, boolean mainHand, CompoundTag tag) {
        minecraft.setScreen((Screen)new ArcheologistNotebookScreen(playerId, mainHand, tag));
    }

    public static void updateDialer(BlockPos pos) {
        minecraft.setScreen((Screen)new DialerScreen());
    }

    public static void openGDOScreen(UUID playerId, boolean mainHand, String idc, int frequency) {
        minecraft.setScreen((Screen)new GDOScreen(playerId, mainHand, idc, frequency));
    }

    public static void updateSymbol(BlockPos pos, int symbolNumber, ResourceLocation pointOfOrigin, ResourceLocation symbols) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof SymbolBlockEntity) {
            SymbolBlockEntity symbolEntity = (SymbolBlockEntity)blockEntity;
            symbolEntity.symbolNumber = symbolNumber;
            symbolEntity.pointOfOrigin = pointOfOrigin;
            symbolEntity.symbols = symbols;
        }
    }

    public static void updateCartouche(BlockPos pos, ResourceLocation symbols, int[] address) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof CartoucheEntity) {
            CartoucheEntity cartouche = (CartoucheEntity)blockEntity;
            cartouche.setSymbols(symbols);
            cartouche.setAddress(new Address.Mutable(address));
        }
    }

    public static void updateInterface(BlockPos pos, long energy, long energyTarget) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractInterfaceEntity) {
            AbstractInterfaceEntity interfaceEntity = (AbstractInterfaceEntity)blockEntity;
            interfaceEntity.setEnergy(energy);
            interfaceEntity.setEnergyTarget(energyTarget);
        }
    }

    public static void updateTransceiver(BlockPos pos, boolean editingFrequency, int frequency, String idc) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof TransceiverEntity) {
            TransceiverEntity transceiver = (TransceiverEntity)blockEntity;
            transceiver.setEditingFrequency(editingFrequency);
            transceiver.setFrequency(frequency);
            transceiver.setCurrentCode(idc);
        }
    }

    public static void updateRings(BlockPos pos, int emptySpace, int transportHeight, int progress) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof TransportRingsEntity) {
            TransportRingsEntity rings = (TransportRingsEntity)blockEntity;
            rings.emptySpace = emptySpace;
            rings.transportHeight = transportHeight;
            rings.updateProgress(progress);
        }
    }

    public static void updateRingPanel(BlockPos pos, List<BlockPos> ringsPos, List<Component> ringsName) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof RingPanelEntity) {
            RingPanelEntity panel = (RingPanelEntity)blockEntity;
            panel.ringsPos = new ArrayList<BlockPos>(ringsPos);
            panel.ringsName = new ArrayList<Component>(ringsName);
        }
    }

    public static void updateDHD(BlockPos pos, long energy, ResourceLocation pointOfOrigin, ResourceLocation symbols, int[] address, boolean isCenterButtonEngaged) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractDHDEntity) {
            AbstractDHDEntity dhd = (AbstractDHDEntity)blockEntity;
            dhd.setEnergy(energy);
            dhd.symbolInfo().setPointOfOrigin(pointOfOrigin);
            dhd.symbolInfo().setSymbols(symbols);
            dhd.setAddress(new Address.Mutable(address));
            dhd.setCenterButtonEngaged(isCenterButtonEngaged);
        }
    }

    public static void updateStargate(BlockPos pos, long energy, int openTime, int timeSinceLastTraveler, int[] address, int[] engagedChevrons, int kawooshTick, int tick, short irisProgress, ResourceLocation pointOfOrigin, ResourceLocation symbols, ResourceLocation variant, ItemStack iris) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            stargate.setEnergy(energy);
            stargate.setOpenTime(openTime);
            stargate.setTimeSinceLastTraveler(timeSinceLastTraveler);
            stargate.setAddress(new Address.Mutable(address));
            stargate.setEngagedChevrons(engagedChevrons);
            stargate.setKawooshTickCount(kawooshTick);
            stargate.setTickCount(tick);
            stargate.symbolInfo().setPointOfOrigin(pointOfOrigin);
            stargate.symbolInfo().setSymbols(symbols);
            stargate.setVariant(variant);
            if (blockEntity instanceof IrisInfo.Interface) {
                IrisInfo.Interface irisStargate = (IrisInfo.Interface)blockEntity;
                irisStargate.irisInfo().setIrisProgress(irisProgress);
                if (!iris.isEmpty()) {
                    irisStargate.irisInfo().setIris(iris);
                } else {
                    irisStargate.irisInfo().unsetIris();
                }
            }
        }
    }

    public static void spawnStargateParticles(BlockPos pos, Map<StargatePart, BlockState> blockStates) {
        BlockState state = ClientAccess.minecraft.level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof AbstractStargateBlock) {
            AbstractStargateBlock stargateBlock = (AbstractStargateBlock)block;
            StargatePart part = (StargatePart)((Object)state.getValue(AbstractStargateBlock.PART));
            Direction direction = (Direction)state.getValue((Property)AbstractStargateBlock.FACING);
            Orientation orientation = (Orientation)((Object)state.getValue(AbstractStargateBlock.ORIENTATION));
            if (part == null || direction == null || orientation == null) {
                return;
            }
            BlockPos basePos = part.getBaseBlockPos(pos, direction, orientation);
            for (Map.Entry<StargatePart, BlockState> entry : blockStates.entrySet()) {
                BlockPos coverPos = entry.getKey().getRingPos(basePos, direction, orientation);
                ClientAccess.minecraft.particleEngine.destroy(coverPos, stargateBlock.defaultBlockState());
            }
        }
    }

    public static void updateStargateState(BlockPos pos, StargateConnection.State connectionState, boolean canSinkGate, Map<StargatePart, BlockState> blockStates) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            stargate.setConnectionState(connectionState);
            stargate.blockCover.blockStates = new HashMap<StargatePart, BlockState>(blockStates);
            stargate.blockCover.canSinkGate = canSinkGate;
        }
    }

    public static void updateRotatingStargate(BlockPos pos, int rotation, int oldRotation, int signalStrength, boolean computerRotation, boolean rotateClockwise, int desiredRotation) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof RotatingStargateEntity) {
            RotatingStargateEntity stargate = (RotatingStargateEntity)blockEntity;
            stargate.setRotation(oldRotation, rotation);
            stargate.signalStrength = signalStrength;
            stargate.rotating = computerRotation;
            stargate.rotateClockwise = rotateClockwise;
            stargate.desiredRotation = desiredRotation;
        }
    }

    public static void updateUniverseStargate(BlockPos pos, int symbolBuffer, int[] addressBuffer) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof UniverseStargateEntity) {
            UniverseStargateEntity stargate = (UniverseStargateEntity)blockEntity;
            stargate.symbolBuffer = symbolBuffer;
            stargate.addressBuffer.fromArray(addressBuffer);
        }
    }

    public static void updateMilkyWayStargate(BlockPos pos, boolean isChevronOpen) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof MilkyWayStargateEntity) {
            MilkyWayStargateEntity stargate = (MilkyWayStargateEntity)blockEntity;
            stargate.isChevronOpen = isChevronOpen;
        }
    }

    public static void updatePegasusStargate(BlockPos pos, int symbolBuffer, int[] addressBuffer, int currentSymbol) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof PegasusStargateEntity) {
            PegasusStargateEntity stargate = (PegasusStargateEntity)blockEntity;
            stargate.symbolBuffer = symbolBuffer;
            stargate.addressBuffer.fromArray(addressBuffer);
            stargate.currentSymbol = currentSymbol;
        }
    }

    public static void updateNaquadahGenerator(BlockPos pos, int reactionProgress, long energy) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof NaquadahGeneratorEntity) {
            NaquadahGeneratorEntity generator = (NaquadahGeneratorEntity)blockEntity;
            generator.setReactionProgress(reactionProgress);
            generator.setEnergy(energy);
        }
    }

    public static void updateCrystallizer(BlockPos pos, FluidStack fluidStack, int progress) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractCrystallizerEntity) {
            AbstractCrystallizerEntity crystallizer = (AbstractCrystallizerEntity)blockEntity;
            crystallizer.setFluid(fluidStack);
            crystallizer.progress = progress;
        }
    }

    public static void updateNaquadahLiquidizer(BlockPos pos, FluidStack fluidStack1, FluidStack fluidStack2, int progress) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractNaquadahLiquidizerEntity) {
            AbstractNaquadahLiquidizerEntity naquadahLiquidizer = (AbstractNaquadahLiquidizerEntity)blockEntity;
            naquadahLiquidizer.setFluid1(fluidStack1);
            naquadahLiquidizer.setFluid2(fluidStack2);
            naquadahLiquidizer.progress = progress;
        }
    }

    public static void updateBatteryBlock(BlockPos pos, long energy) {
        BlockEntity blockEntity = ClientAccess.minecraft.level.getBlockEntity(pos);
        if (blockEntity instanceof BatteryBlockEntity) {
            BatteryBlockEntity battery = (BatteryBlockEntity)blockEntity;
            battery.setEnergy(energy);
        }
    }
}

