/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public class ClientUtil {
    private static final ResourceLocation UNIVERSAL = StargateJourney.sgjourneyLocation("universal");

    public static PointOfOrigin getPointOfOrigin(ResourceLocation pointOfOrigin) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientPacketListener clientPacketListener = minecraft.getConnection();
        RegistryAccess.Frozen registries = clientPacketListener.registryAccess();
        Registry registry = registries.registryOrThrow(PointOfOrigin.REGISTRY_KEY);
        if (pointOfOrigin != null) {
            return (PointOfOrigin)registry.get(pointOfOrigin);
        }
        return (PointOfOrigin)registry.get(UNIVERSAL);
    }

    public static Symbols getSymbols(ResourceLocation symbols) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientPacketListener clientPacketListener = minecraft.getConnection();
        RegistryAccess.Frozen registries = clientPacketListener.registryAccess();
        Registry registry = registries.registryOrThrow(Symbols.REGISTRY_KEY);
        if (symbols != null) {
            return (Symbols)registry.get(symbols);
        }
        return (Symbols)registry.get(UNIVERSAL);
    }

    public static void addVertex(VertexConsumer consumer, TextureAtlasSprite sprite, Vec3 pos, Vec3 normal, float u, float v) {
        consumer.addVertex((float)pos.x(), (float)pos.y(), (float)pos.z());
        consumer.setUv(sprite.getU(u / 16.0f), sprite.getV(v / 16.0f));
        consumer.setUv2(0, 0);
        consumer.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        consumer.setNormal((float)normal.x(), (float)normal.y(), (float)normal.z());
    }

    public static BakedQuad bakeQuad(TextureAtlasSprite sprite, Vec3 vec1, Vec3 vec2, Vec3 vec3, Vec3 vec4) {
        return ClientUtil.bakeQuad(sprite, vec1, vec2, vec3, vec4, 0.0f, 0.0f, 16.0f, 16.0f);
    }

    public static BakedQuad bakeQuad(TextureAtlasSprite sprite, Vec3 vec1, Vec3 vec2, Vec3 vec3, Vec3 vec4, float uStart, float vStart, float uEnd, float vEnd) {
        Vec3 normal = vec3.subtract(vec2).cross(vec1.subtract(vec2)).normalize();
        QuadBakingVertexConsumer consumer = new QuadBakingVertexConsumer();
        consumer.setSprite(sprite);
        consumer.setDirection(Direction.getNearest((double)normal.x, (double)normal.y, (double)normal.z));
        ClientUtil.addVertex((VertexConsumer)consumer, sprite, vec1, normal, uStart, vEnd);
        ClientUtil.addVertex((VertexConsumer)consumer, sprite, vec2, normal, uEnd, vEnd);
        ClientUtil.addVertex((VertexConsumer)consumer, sprite, vec3, normal, uEnd, vStart);
        ClientUtil.addVertex((VertexConsumer)consumer, sprite, vec4, normal, uStart, vStart);
        return consumer.bakeQuad();
    }
}

