/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.povstalec.sgjourney.client.ClientUtil;
import net.povstalec.sgjourney.common.blocks.tech.CableBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CableBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation MISSING = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"missingno");
    private static final byte DEFAULT_OFFSET = 15;
    private static final byte CONNECTED_OFFSET = 16;
    private static Minecraft minecraft = Minecraft.getInstance();
    private final IGeometryBakingContext context;
    private final double thickness;
    private final double sideSpace;
    private final ResourceLocation texture;
    private TextureAtlasSprite sprite;
    private final ResourceLocation particleTexture;
    private TextureAtlasSprite particleSprite;
    private final Vec3 x0y0z0;
    private final Vec3 x1y0z0;
    private final Vec3 x1y0z1;
    private final Vec3 x0y0z1;
    private final Vec3 x0y1z0;
    private final Vec3 x1y1z0;
    private final Vec3 x1y1z1;
    private final Vec3 x0y1z1;
    private final Vec3 xSpace;
    private final Vec3 ySpace;
    private final Vec3 zSpace;

    public CableBakedModel(IGeometryBakingContext context, ResourceLocation texture, ResourceLocation particleTexture, double thickness) {
        this.context = context;
        this.texture = texture;
        this.particleTexture = particleTexture;
        this.thickness = thickness;
        this.sideSpace = (1.0 - thickness) / 2.0;
        this.x0y0z0 = new Vec3(this.sideSpace, this.sideSpace, this.sideSpace);
        this.x1y0z0 = new Vec3(this.sideSpace + thickness, this.sideSpace, this.sideSpace);
        this.x1y0z1 = new Vec3(this.sideSpace + thickness, this.sideSpace, this.sideSpace + thickness);
        this.x0y0z1 = new Vec3(this.sideSpace, this.sideSpace, this.sideSpace + thickness);
        this.x0y1z0 = new Vec3(this.sideSpace, this.sideSpace + thickness, this.sideSpace);
        this.x1y1z0 = new Vec3(this.sideSpace + thickness, this.sideSpace + thickness, this.sideSpace);
        this.x1y1z1 = new Vec3(this.sideSpace + thickness, this.sideSpace + thickness, this.sideSpace + thickness);
        this.x0y1z1 = new Vec3(this.sideSpace, this.sideSpace + thickness, this.sideSpace + thickness);
        this.xSpace = new Vec3(this.sideSpace, 0.0, 0.0);
        this.ySpace = new Vec3(0.0, this.sideSpace, 0.0);
        this.zSpace = new Vec3(0.0, 0.0, this.sideSpace);
    }

    private static TextureAtlasSprite getTexture(ResourceLocation texture) {
        return (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(texture);
    }

    private void initTexture() {
        if (this.sprite == null) {
            this.sprite = CableBakedModel.getTexture(this.texture);
        }
        if (this.particleSprite == null) {
            this.particleSprite = CableBakedModel.getTexture(this.particleTexture);
        }
    }

    private static byte getOffset(CableBlock.ConnectorType top, CableBlock.ConnectorType left, CableBlock.ConnectorType bottom, CableBlock.ConnectorType right) {
        byte mask = 0;
        if (top != CableBlock.ConnectorType.NONE) {
            mask = (byte)(mask | 1);
        }
        if (left != CableBlock.ConnectorType.NONE) {
            mask = (byte)(mask | 2);
        }
        if (bottom != CableBlock.ConnectorType.NONE) {
            mask = (byte)(mask | 4);
        }
        if (right != CableBlock.ConnectorType.NONE) {
            mask = (byte)(mask | 8);
        }
        return mask;
    }

    private static BakedQuad bakeQuad(TextureAtlasSprite sprite, Vec3 vec1, Vec3 vec2, Vec3 vec3, Vec3 vec4, double uStart, double vStart, double uEnd, double vEnd, byte offset) {
        return ClientUtil.bakeQuad(sprite, vec1, vec2, vec3, vec4, (float)(16.0 * uStart), (float)(0.9411764740943909 * (vStart + (double)offset)), (float)(16.0 * uEnd), (float)(0.9411764740943909 * (vEnd + (double)offset)));
    }

    @NotNull
    public List<BakedQuad> getQuads(BlockState state, Direction side, @NotNull RandomSource randomSource, @NotNull ModelData extraData, @Nullable RenderType layer) {
        this.initTexture();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (side == null && (layer == null || layer.equals(RenderType.solid()))) {
            byte offset;
            CableBlock.ConnectorType down;
            CableBlock.ConnectorType up;
            CableBlock.ConnectorType east;
            CableBlock.ConnectorType west;
            CableBlock.ConnectorType south;
            CableBlock.ConnectorType north;
            if (state != null) {
                north = (CableBlock.ConnectorType)((Object)state.getValue(CableBlock.NORTH));
                south = (CableBlock.ConnectorType)((Object)state.getValue(CableBlock.SOUTH));
                west = (CableBlock.ConnectorType)((Object)state.getValue(CableBlock.WEST));
                east = (CableBlock.ConnectorType)((Object)state.getValue(CableBlock.EAST));
                up = (CableBlock.ConnectorType)((Object)state.getValue(CableBlock.UP));
                down = (CableBlock.ConnectorType)((Object)state.getValue(CableBlock.DOWN));
            } else {
                north = CableBlock.ConnectorType.NONE;
                east = CableBlock.ConnectorType.NONE;
                south = CableBlock.ConnectorType.NONE;
                west = CableBlock.ConnectorType.NONE;
                up = CableBlock.ConnectorType.NONE;
                down = CableBlock.ConnectorType.NONE;
            }
            if (north != CableBlock.ConnectorType.NONE) {
                offset = north == CableBlock.ConnectorType.BLOCK ? (byte)16 : 15;
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y1z0.subtract(this.zSpace), this.x0y1z0, this.x1y1z0, this.x1y1z0.subtract(this.zSpace), 0.0, this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y0z0, this.x1y0z0.subtract(this.zSpace), this.x1y1z0.subtract(this.zSpace), this.x1y1z0, this.sideSpace + this.thickness, this.sideSpace, 1.0, this.sideSpace + this.thickness, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y0z0.subtract(this.zSpace), this.x1y0z0, this.x0y0z0, this.x0y0z0.subtract(this.zSpace), 0.0, this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y0z0.subtract(this.zSpace), this.x0y0z0, this.x0y1z0, this.x0y1z0.subtract(this.zSpace), 0.0, this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, offset));
                if (north == CableBlock.ConnectorType.BLOCK) {
                    quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y0z0.subtract(this.zSpace), this.x0y0z0.subtract(this.zSpace), this.x0y1z0.subtract(this.zSpace), this.x1y1z0.subtract(this.zSpace), this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, (byte)0));
                }
            } else {
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y0z0, this.x0y0z0, this.x0y1z0, this.x1y1z0, this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, CableBakedModel.getOffset(up, east, down, west)));
            }
            if (east != CableBlock.ConnectorType.NONE) {
                offset = east == CableBlock.ConnectorType.BLOCK ? (byte)16 : 15;
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y1z0, this.x1y1z1, this.x1y1z1.add(this.xSpace), this.x1y1z0.add(this.xSpace), this.sideSpace, 0.0, this.sideSpace + this.thickness, this.sideSpace, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y0z0.add(this.xSpace), this.x1y0z0, this.x1y1z0, this.x1y1z0.add(this.xSpace), 0.0, this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y0z0.add(this.xSpace), this.x1y0z1.add(this.xSpace), this.x1y0z1, this.x1y0z0, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, 1.0, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y0z1, this.x1y0z1.add(this.xSpace), this.x1y1z1.add(this.xSpace), this.x1y1z1, this.sideSpace + this.thickness, this.sideSpace, 1.0, this.sideSpace + this.thickness, offset));
                if (east == CableBlock.ConnectorType.BLOCK) {
                    quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y0z1.add(this.xSpace), this.x1y0z0.add(this.xSpace), this.x1y1z0.add(this.xSpace), this.x1y1z1.add(this.xSpace), this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, (byte)0));
                }
            } else {
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y0z1, this.x1y0z0, this.x1y1z0, this.x1y1z1, this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, CableBakedModel.getOffset(up, south, down, north)));
            }
            if (south != CableBlock.ConnectorType.NONE) {
                offset = south == CableBlock.ConnectorType.BLOCK ? (byte)16 : 15;
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y1z1, this.x0y1z1.add(this.zSpace), this.x1y1z1.add(this.zSpace), this.x1y1z1, this.sideSpace + this.thickness, this.sideSpace, 1.0, this.sideSpace + this.thickness, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y0z1.add(this.zSpace), this.x1y0z1, this.x1y1z1, this.x1y1z1.add(this.zSpace), 0.0, this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y0z1, this.x1y0z1.add(this.zSpace), this.x0y0z1.add(this.zSpace), this.x0y0z1, this.sideSpace + this.thickness, this.sideSpace, 1.0, this.sideSpace + this.thickness, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y0z1, this.x0y0z1.add(this.zSpace), this.x0y1z1.add(this.zSpace), this.x0y1z1, this.sideSpace + this.thickness, this.sideSpace, 1.0, this.sideSpace + this.thickness, offset));
                if (south == CableBlock.ConnectorType.BLOCK) {
                    quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y0z1.add(this.zSpace), this.x1y0z1.add(this.zSpace), this.x1y1z1.add(this.zSpace), this.x0y1z1.add(this.zSpace), this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, (byte)0));
                }
            } else {
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y0z1, this.x1y0z1, this.x1y1z1, this.x0y1z1, this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, CableBakedModel.getOffset(up, west, down, east)));
            }
            if (west != CableBlock.ConnectorType.NONE) {
                offset = west == CableBlock.ConnectorType.BLOCK ? (byte)16 : 15;
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y1z0.subtract(this.xSpace), this.x0y1z1.subtract(this.xSpace), this.x0y1z1, this.x0y1z0, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, 1.0, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y0z0, this.x0y0z0.subtract(this.xSpace), this.x0y1z0.subtract(this.xSpace), this.x0y1z0, this.sideSpace + this.thickness, this.sideSpace, 1.0, this.sideSpace + this.thickness, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y0z0, this.x0y0z1, this.x0y0z1.subtract(this.xSpace), this.x0y0z0.subtract(this.xSpace), this.sideSpace, 0.0, this.sideSpace + this.thickness, this.sideSpace, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y0z1.subtract(this.xSpace), this.x0y0z1, this.x0y1z1, this.x0y1z1.subtract(this.xSpace), 0.0, this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, offset));
                if (west == CableBlock.ConnectorType.BLOCK) {
                    quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y0z0.subtract(this.xSpace), this.x0y0z1.subtract(this.xSpace), this.x0y1z1.subtract(this.xSpace), this.x0y1z0.subtract(this.xSpace), this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, (byte)0));
                }
            } else {
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y0z0, this.x0y0z1, this.x0y1z1, this.x0y1z0, this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, CableBakedModel.getOffset(up, north, down, south)));
            }
            if (up != CableBlock.ConnectorType.NONE) {
                offset = up == CableBlock.ConnectorType.BLOCK ? (byte)16 : 15;
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y1z0, this.x0y1z0, this.x0y1z0.add(this.ySpace), this.x1y1z0.add(this.ySpace), this.sideSpace, 0.0, this.sideSpace + this.thickness, this.sideSpace, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y1z1, this.x1y1z0, this.x1y1z0.add(this.ySpace), this.x1y1z1.add(this.ySpace), this.sideSpace, 0.0, this.sideSpace + this.thickness, this.sideSpace, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y1z1, this.x1y1z1, this.x1y1z1.add(this.ySpace), this.x0y1z1.add(this.ySpace), this.sideSpace, 0.0, this.sideSpace + this.thickness, this.sideSpace, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y1z0, this.x0y1z1, this.x0y1z1.add(this.ySpace), this.x0y1z0.add(this.ySpace), this.sideSpace, 0.0, this.sideSpace + this.thickness, this.sideSpace, offset));
                if (up == CableBlock.ConnectorType.BLOCK) {
                    quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y1z0.add(this.ySpace), this.x0y1z1.add(this.ySpace), this.x1y1z1.add(this.ySpace), this.x1y1z0.add(this.ySpace), this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, (byte)0));
                }
            } else {
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y1z0, this.x0y1z1, this.x1y1z1, this.x1y1z0, this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, CableBakedModel.getOffset(east, north, west, south)));
            }
            if (down != CableBlock.ConnectorType.NONE) {
                offset = down == CableBlock.ConnectorType.BLOCK ? (byte)16 : 15;
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y0z0.subtract(this.ySpace), this.x0y0z0.subtract(this.ySpace), this.x0y0z0, this.x1y0z0, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, 1.0, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y0z1.subtract(this.ySpace), this.x1y0z0.subtract(this.ySpace), this.x1y0z0, this.x1y0z1, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, 1.0, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y0z1.subtract(this.ySpace), this.x1y0z1.subtract(this.ySpace), this.x1y0z1, this.x0y0z1, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, 1.0, offset));
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x0y0z0.subtract(this.ySpace), this.x0y0z1.subtract(this.ySpace), this.x0y0z1, this.x0y0z0, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, 1.0, offset));
                if (down == CableBlock.ConnectorType.BLOCK) {
                    quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y0z0.subtract(this.ySpace), this.x1y0z1.subtract(this.ySpace), this.x0y0z1.subtract(this.ySpace), this.x0y0z0.subtract(this.ySpace), this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, (byte)0));
                }
            } else {
                quads.add(CableBakedModel.bakeQuad(this.sprite, this.x1y0z0, this.x1y0z1, this.x0y0z1, this.x0y0z0, this.sideSpace, this.sideSpace, this.sideSpace + this.thickness, this.sideSpace + this.thickness, CableBakedModel.getOffset(west, north, east, south)));
            }
        }
        return quads;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.all();
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.particleSprite == null ? (TextureAtlasSprite)minecraft.getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(MISSING) : this.particleSprite;
    }

    public ItemTransforms getTransforms() {
        return this.context.getTransforms();
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }
}

