/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.client.models.block_entity.SGJourneyModel;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.common.sgjourney.info.IrisInfo;
import org.joml.Matrix4f;

public class IrisModel {
    private static final float OFFSET = 0.03125f;
    private static final int TOTAL_SIDES = 20;
    private static final float DEGREES = 18.0f;
    public static final float IRIS_TEXTURE_WIDTH = 256.0f;
    public static final float IRIS_TEXTURE_HEIGHT = 256.0f;
    public static final float IRIS_BLADE_WIDTH = 0.792f;
    public static final float IRIS_BLADE_WIDTH_HALF = 0.396f;
    public static final float IRIS_BLADE_LENGTH = 2.5f;
    public static final float IRIS_BLADE_HEIGHT = 40.0f;
    public static final float IRIS_OPEN_DEGREES = 84.0f;
    public static final float IRIS_ROTATE_DEGREES = 1.0f;
    public static final float TEXTURE_CENTER_U = 0.025390625f;
    public static final float TEXTURE_TOP_V = 0.0f;
    public static final float TEXTURE_LEFT_U = 6.4062513E-4f;
    public static final float TEXTURE_LEFT_V = 0.15625f;
    public static final float TEXTURE_RIGHT_U = 0.050140627f;
    public static final float TEXTURE_RIGHT_V = 0.15625f;
    private boolean renderWhenOpen;
    private float maxOpenDegrees;

    public IrisModel(boolean renderWhenOpen, float maxOpenDegrees) {
        this.renderWhenOpen = renderWhenOpen;
        this.maxOpenDegrees = maxOpenDegrees;
    }

    public void renderIris(IrisInfo.Interface irisStargate, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay, float progress) {
        float closingProgress = (58.0f - progress) / 58.0f;
        Optional<ResourceLocation> irisTexture = irisStargate.irisInfo().getIrisTexture();
        if (!this.renderWhenOpen && progress == 0.0f || irisTexture.isEmpty()) {
            return;
        }
        VertexConsumer consumer = source.getBuffer(SGJourneyRenderTypes.iris(irisTexture.get()));
        stack.pushPose();
        for (int j = 0; j < 20; ++j) {
            stack.pushPose();
            stack.translate(0.396f, 2.5f, 0.0f);
            stack.mulPose(Axis.YP.rotationDegrees(-1.0f * closingProgress));
            stack.mulPose(Axis.ZP.rotationDegrees(-this.maxOpenDegrees * closingProgress));
            Matrix4f matrix4 = stack.last().pose();
            PoseStack.Pose pose = stack.last();
            float uAddition = (float)(13 * (j % 10)) / 256.0f;
            float vAddition = (float)(40 * (j / 10)) / 256.0f;
            SGJourneyModel.createTriangle(consumer, matrix4, pose, combinedLight, 0.0f, 0.0f, 1.0f, -0.792f, 0.0f, 0.03125f, 0.050140627f + uAddition, 0.15625f + vAddition, -0.396f, -2.5f, 0.03125f, 0.025390625f + uAddition, 0.0f + vAddition, 0.0f, 0.0f, 0.03125f, 6.4062513E-4f + uAddition, 0.15625f + vAddition);
            SGJourneyModel.createTriangle(consumer, matrix4, pose, combinedLight, 0.0f, 0.0f, -1.0f, -0.396f, -2.5f, 0.03125f, 0.025390625f + uAddition, 0.0f + vAddition, -0.792f, 0.0f, 0.03125f, 0.050140627f + uAddition, 0.15625f + vAddition, 0.0f, 0.0f, 0.03125f, 6.4062513E-4f + uAddition, 0.15625f + vAddition);
            stack.popPose();
            stack.mulPose(Axis.ZP.rotationDegrees(18.0f));
        }
        stack.popPose();
    }
}

