/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.transporter.TransportRingsEntity;

public class TransportRingsModel {
    private static final ResourceLocation TRANSPORT_RINGS_TEXTURE = StargateJourney.sgjourneyLocation("textures/block/transport_rings.png");
    private final ModelPart transportRings;

    public TransportRingsModel(ModelPart transportRings) {
        this.transportRings = transportRings;
    }

    public void setRingHeight(int ring, float height) {
        if (ring < 1 || ring > 5) {
            return;
        }
        this.getRing(ring).setPos(0.0f, height, 0.0f);
    }

    public ModelPart getRing(int ring) {
        return this.transportRings.getChild("transport_ring_" + ring);
    }

    public void renderTransportRings(TransportRingsEntity transportRings, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        VertexConsumer ringTexture = source.getBuffer(RenderType.entitySolid((ResourceLocation)TRANSPORT_RINGS_TEXTURE));
        this.transportRings.render(stack, ringTexture, combinedLight, combinedOverlay);
    }

    public static LayerDefinition createRingLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition first_ring = partdefinition.addOrReplaceChild("transport_ring_1", CubeListBuilder.create(), PartPose.offset((float)8.0f, (float)0.0f, (float)8.0f));
        PartDefinition second_ring = partdefinition.addOrReplaceChild("transport_ring_2", CubeListBuilder.create(), PartPose.offset((float)8.0f, (float)0.0f, (float)8.0f));
        PartDefinition third_ring = partdefinition.addOrReplaceChild("transport_ring_3", CubeListBuilder.create(), PartPose.offset((float)8.0f, (float)0.0f, (float)8.0f));
        PartDefinition fourth_ring = partdefinition.addOrReplaceChild("transport_ring_4", CubeListBuilder.create(), PartPose.offset((float)8.0f, (float)0.0f, (float)8.0f));
        PartDefinition fifth_ring = partdefinition.addOrReplaceChild("transport_ring_5", CubeListBuilder.create(), PartPose.offset((float)8.0f, (float)0.0f, (float)8.0f));
        TransportRingsModel.createRing(first_ring);
        TransportRingsModel.createRing(second_ring);
        TransportRingsModel.createRing(third_ring);
        TransportRingsModel.createRing(fourth_ring);
        TransportRingsModel.createRing(fifth_ring);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public static void createRing(PartDefinition ring) {
        for (int i = 0; i < 16; ++i) {
            ring.addOrReplaceChild("ring_" + i, CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -2.0f, 32.219f, 16.0f, 4.0f, 8.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(22.5 * (double)i)), (float)0.0f));
        }
    }
}

