/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.client.models.block_entity.TollanStargateModel;
import net.povstalec.sgjourney.client.render.block_entity.AbstractStargateRenderer;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClientStargateVariants;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.TollanStargateVariant;
import net.povstalec.sgjourney.common.block_entities.stargate.TollanStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.TollanStargateBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.sgjourney.StargateVariant;

public class TollanStargateRenderer
extends AbstractStargateRenderer<TollanStargateEntity, TollanStargateVariant> {
    protected final TollanStargateModel stargateModel = new TollanStargateModel();

    public TollanStargateRenderer(BlockEntityRendererProvider.Context context) {
        super(context, 0.125f, true, 38.0f);
    }

    @Override
    protected TollanStargateVariant getClientVariant(TollanStargateEntity stargate) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            if (stargateVariant.get().isFound()) {
                return ClientStargateVariants.getTollanStargateVariant(stargateVariant.get().clientVariant());
            }
            if (!stargateVariant.get().isMissing()) {
                stargateVariant.get().handleLocation(ClientStargateVariants.hasTollanStargateVariant(stargateVariant.get().clientVariant()));
            }
        }
        return ClientStargateVariants.getTollanStargateVariant(stargate.defaultVariant());
    }

    public void render(TollanStargateEntity stargate, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        TollanStargateVariant stargateVariant = this.getClientVariant(stargate);
        BlockState blockstate = stargate.getBlockState();
        Direction facing = (Direction)blockstate.getValue((Property)TollanStargateBlock.FACING);
        Vec3 center = stargate.getRelativeCenter();
        Orientation orientation = (Orientation)((Object)blockstate.getValue((Property)AbstractStargateBaseBlock.ORIENTATION));
        this.renderCover(stargate, stack, source, combinedLight, combinedOverlay);
        stack.pushPose();
        double shiftBase = (double)orientation.getIndex() * 0.5;
        double shiftX = center.x();
        double shiftY = center.y();
        double shiftZ = center.z();
        if (orientation != Orientation.REGULAR) {
            if (facing.getAxis() == Direction.Axis.X) {
                shiftX += (double)facing.getAxisDirection().getStep() * shiftBase;
            } else {
                shiftZ += (double)facing.getAxisDirection().getStep() * shiftBase;
            }
        }
        stack.translate(shiftX, shiftY, shiftZ);
        stack.mulPose(Axis.YP.rotationDegrees(-facing.toYRot()));
        if (orientation == Orientation.UPWARD) {
            stack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        } else if (orientation == Orientation.DOWNWARD) {
            stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        }
        this.stargateModel.renderStargate(stargate, stargateVariant, partialTick, stack, source, combinedLight, combinedOverlay);
        this.renderWormhole(stargate, stargateVariant, stack, source, combinedLight, combinedOverlay);
        stack.popPose();
    }
}

