/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.client.models.block_entity.UniverseStargateModel;
import net.povstalec.sgjourney.client.render.block_entity.AbstractStargateRenderer;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.ClientStargateVariants;
import net.povstalec.sgjourney.client.resourcepack.stargate_variant.UniverseStargateVariant;
import net.povstalec.sgjourney.common.block_entities.stargate.UniverseStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.UniverseStargateBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.sgjourney.StargateVariant;

public class UniverseStargateRenderer
extends AbstractStargateRenderer<UniverseStargateEntity, UniverseStargateVariant> {
    protected final UniverseStargateModel stargateModel = new UniverseStargateModel();

    public UniverseStargateRenderer(BlockEntityRendererProvider.Context context) {
        super(context, 0.25f, false, 84.0f);
    }

    @Override
    protected UniverseStargateVariant getClientVariant(UniverseStargateEntity stargate) {
        Optional<StargateVariant> stargateVariant = ClientStargateVariants.getVariant(stargate);
        if (stargateVariant.isPresent()) {
            if (stargateVariant.get().isFound()) {
                return ClientStargateVariants.getUniverseStargateVariant(stargateVariant.get().clientVariant());
            }
            if (!stargateVariant.get().isMissing()) {
                stargateVariant.get().handleLocation(ClientStargateVariants.hasUniverseStargateVariant(stargateVariant.get().clientVariant()));
            }
        }
        return ClientStargateVariants.getUniverseStargateVariant(stargate.defaultVariant());
    }

    public void render(UniverseStargateEntity stargate, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        UniverseStargateVariant stargateVariant = this.getClientVariant(stargate);
        BlockState blockstate = stargate.getBlockState();
        float facing = ((Direction)blockstate.getValue((Property)UniverseStargateBlock.FACING)).toYRot();
        Vec3 center = stargate.getRelativeCenter();
        Orientation orientation = (Orientation)((Object)blockstate.getValue((Property)AbstractStargateBaseBlock.ORIENTATION));
        this.renderCover(stargate, stack, source, combinedLight, combinedOverlay);
        stack.pushPose();
        stack.translate(center.x(), center.y(), center.z());
        stack.mulPose(Axis.YP.rotationDegrees(-facing));
        if (orientation == Orientation.UPWARD) {
            stack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        } else if (orientation == Orientation.DOWNWARD) {
            stack.mulPose(Axis.XP.rotationDegrees(90.0f));
        }
        this.stargateModel.setRotation(stargate.getRotationDegrees(partialTick));
        this.stargateModel.renderStargate(stargate, stargateVariant, partialTick, stack, source, combinedLight, combinedOverlay);
        stack.pushPose();
        stack.mulPose(Axis.ZP.rotationDegrees(stargate.getRotationDegrees(partialTick)));
        this.irisModel.renderIris(stargate, stack, source, combinedLight, combinedOverlay, stargate.irisInfo().getIrisProgress(partialTick));
        stack.popPose();
        this.renderWormhole(stargate, stargateVariant, stack, source, combinedLight, combinedOverlay);
        stack.popPose();
    }
}

