/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.level;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.render.level.PlanetSkyRenderers;
import net.povstalec.sgjourney.client.render.level.SGJourneySkyRenderer;
import net.povstalec.sgjourney.client.render.level.StellarViewCompatibility;
import net.povstalec.sgjourney.common.config.ClientSkyConfig;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class SGJourneyDimensionSpecialEffects
extends DimensionSpecialEffects {
    public static final ResourceLocation ABYDOS_EFFECTS = StargateJourney.sgjourneyLocation("abydos");
    public static final ResourceLocation CHULAK_EFFECTS = StargateJourney.sgjourneyLocation("chulak");
    public static final ResourceLocation UNITAS_EFFECTS = StargateJourney.sgjourneyLocation("unitas");
    public static final ResourceLocation RIMA_EFFECTS = StargateJourney.sgjourneyLocation("rima");
    public static final ResourceLocation CAVUM_TENEBRAE_EFFECTS = StargateJourney.sgjourneyLocation("cavum_tenebrae");
    public static final ResourceLocation LANTEA_EFFECTS = StargateJourney.sgjourneyLocation("lantea");
    public static final ResourceLocation ATHOS_EFFECTS = StargateJourney.sgjourneyLocation("athos");
    @Nullable
    protected SGJourneySkyRenderer skyRenderer;

    public SGJourneyDimensionSpecialEffects(float cloudLevel, boolean hasGround, DimensionSpecialEffects.SkyType skyType, boolean forceBrightLightmap, boolean constantAmbientLight) {
        super(cloudLevel, hasGround, skyType, forceBrightLightmap, constantAmbientLight);
    }

    public Vec3 getBrightnessDependentFogColor(Vec3 biomeFogColor, float daylight) {
        return biomeFogColor.multiply((double)(daylight * 0.94f + 0.06f), (double)(daylight * 0.94f + 0.06f), (double)(daylight * 0.91f + 0.09f));
    }

    public boolean isFoggyAt(int x, int y) {
        return false;
    }

    public boolean renderClouds(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, double camX, double camY, double camZ, Matrix4f modelViewMatrix, Matrix4f projectionMatrix) {
        return false;
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, Matrix4f modelViewMatrix, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        if (this.customSky()) {
            if (this.stellarViewSky()) {
                return StellarViewCompatibility.renderSky(level, ticks, partialTick, modelViewMatrix, camera, projectionMatrix, isFoggy, setupFog);
            }
            if (this.skyRenderer != null) {
                this.skyRenderer.renderSky(level, partialTick, modelViewMatrix, camera, projectionMatrix, setupFog);
            }
            return true;
        }
        return false;
    }

    public boolean renderSnowAndRain(ClientLevel level, int ticks, float partialTick, LightTexture lightTexture, double camX, double camY, double camZ) {
        return false;
    }

    public void adjustLightmapColors(ClientLevel level, float partialTicks, float skyDarken, float skyLight, float blockLight, int pixelX, int pixelY, Vector3f colors) {
        if (this.stellarViewSky()) {
            StellarViewCompatibility.adjustLightmapColors(level, partialTicks, skyDarken, skyLight, blockLight, pixelX, pixelY, colors);
        }
    }

    public boolean stellarViewSky() {
        return StargateJourney.isStellarViewLoaded();
    }

    public boolean customSky() {
        return true;
    }

    public static void registerStargateJourneyEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(ABYDOS_EFFECTS, (DimensionSpecialEffects)new Abydos());
        event.register(CHULAK_EFFECTS, (DimensionSpecialEffects)new Chulak());
        event.register(UNITAS_EFFECTS, (DimensionSpecialEffects)new Unitas());
        event.register(RIMA_EFFECTS, (DimensionSpecialEffects)new Rima());
        event.register(CAVUM_TENEBRAE_EFFECTS, (DimensionSpecialEffects)new CavumTenebrae());
        event.register(LANTEA_EFFECTS, (DimensionSpecialEffects)new Lantea());
        event.register(ATHOS_EFFECTS, (DimensionSpecialEffects)new Athos());
    }

    public static class Abydos
    extends SGJourneyDimensionSpecialEffects {
        public Abydos() {
            super(192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
            this.skyRenderer = new PlanetSkyRenderers.AbydosSkyRenderer();
        }

        @Override
        public boolean customSky() {
            return ClientSkyConfig.custom_abydos_sky.get();
        }
    }

    public static class Chulak
    extends SGJourneyDimensionSpecialEffects {
        public Chulak() {
            super(192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
            this.skyRenderer = new PlanetSkyRenderers.ChulakSkyRenderer();
        }

        @Override
        public boolean customSky() {
            return ClientSkyConfig.custom_chulak_sky.get();
        }
    }

    public static class Unitas
    extends SGJourneyDimensionSpecialEffects {
        public Unitas() {
            super(Float.NaN, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
            this.skyRenderer = new PlanetSkyRenderers.UnitasSkyRenderer();
        }

        @Override
        public boolean customSky() {
            return ClientSkyConfig.custom_unitas_sky.get();
        }
    }

    public static class Rima
    extends SGJourneyDimensionSpecialEffects {
        public Rima() {
            super(Float.NaN, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
            this.skyRenderer = new PlanetSkyRenderers.RimaSkyRenderer();
        }

        @Override
        public boolean customSky() {
            return ClientSkyConfig.custom_rima_sky.get();
        }
    }

    public static class CavumTenebrae
    extends SGJourneyDimensionSpecialEffects {
        public CavumTenebrae() {
            super(Float.NaN, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
            this.skyRenderer = new PlanetSkyRenderers.CavumTenebraeSkyRenderer();
        }

        @Override
        public boolean customSky() {
            return ClientSkyConfig.custom_cavum_tenebrae_sky.get();
        }
    }

    public static class Lantea
    extends SGJourneyDimensionSpecialEffects {
        public Lantea() {
            super(386.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
            this.skyRenderer = new PlanetSkyRenderers.LanteaSkyRenderer();
        }

        @Override
        public boolean customSky() {
            return ClientSkyConfig.custom_lantea_sky.get();
        }
    }

    public static class Athos
    extends SGJourneyDimensionSpecialEffects {
        public Athos() {
            super(192.0f, true, DimensionSpecialEffects.SkyType.NORMAL, false, false);
            this.skyRenderer = new PlanetSkyRenderers.AthosSkyRenderer();
        }

        @Override
        public boolean customSky() {
            return ClientSkyConfig.custom_athos_sky.get();
        }
    }
}

