/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.render.level;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.StargateJourney;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public abstract class SGJourneySkyRenderer {
    protected static final ResourceLocation MOON_HALO_LOCATION = StargateJourney.sgjourneyLocation("textures/environment/blue_halo.png");
    protected static final ResourceLocation MOON_LOCATION = StargateJourney.sgjourneyLocation("textures/environment/moon_phases.png");
    protected static final ResourceLocation SUN_LOCATION = StargateJourney.location("textures/environment/sun.png");
    protected static final ResourceLocation BLACK_HOLE_HALO_LOCATION = StargateJourney.sgjourneyLocation("textures/environment/black_hole_halo.png");
    protected static final ResourceLocation BLACK_HOLE_LOCATION = StargateJourney.sgjourneyLocation("textures/environment/black_hole.png");
    protected Minecraft minecraft = Minecraft.getInstance();
    @Nullable
    protected VertexBuffer starBuffer;
    @Nullable
    protected VertexBuffer skyBuffer;
    @Nullable
    protected VertexBuffer darkBuffer;

    public SGJourneySkyRenderer(long seed, int numberOfStars) {
        this.createStars(seed, numberOfStars);
        this.createLightSky();
        this.createDarkSky();
    }

    protected boolean doesMobEffectBlockSky(Camera camera) {
        Entity entity = camera.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingentity = (LivingEntity)entity;
        return livingentity.hasEffect(MobEffects.BLINDNESS) || livingentity.hasEffect(MobEffects.DARKNESS);
    }

    protected boolean isFoggy(Camera camera) {
        boolean isFoggy;
        Vec3 cameraPos = camera.getPosition();
        boolean bl = isFoggy = this.minecraft.level.effects().isFoggyAt(Mth.floor((double)cameraPos.x()), Mth.floor((double)cameraPos.y())) || this.minecraft.gui.getBossOverlay().shouldCreateWorldFog();
        if (isFoggy) {
            return true;
        }
        FogType fogtype = camera.getFluidInCamera();
        return fogtype == FogType.POWDER_SNOW || fogtype == FogType.LAVA || this.doesMobEffectBlockSky(camera);
    }

    protected void createDarkSky() {
        if (this.darkBuffer != null) {
            this.darkBuffer.close();
        }
        this.darkBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
        MeshData mesh = SGJourneySkyRenderer.buildSkyDisc(bufferbuilder, -16.0f);
        this.darkBuffer.bind();
        this.darkBuffer.upload(mesh);
        VertexBuffer.unbind();
    }

    protected void createLightSky() {
        if (this.skyBuffer != null) {
            this.skyBuffer.close();
        }
        this.skyBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
        MeshData mesh = SGJourneySkyRenderer.buildSkyDisc(bufferbuilder, 16.0f);
        this.skyBuffer.bind();
        this.skyBuffer.upload(mesh);
        VertexBuffer.unbind();
    }

    public static MeshData buildSkyDisc(BufferBuilder builder, float scale) {
        float baseRadius = 512.0f;
        float invertibleBaseRadius = Math.signum(scale) * baseRadius;
        RenderSystem.setShader(GameRenderer::getPositionShader);
        builder.addVertex(0.0f, scale, 0.0f);
        for (int i = -180; i <= 180; i += 45) {
            float radians = (float)Math.toRadians(i);
            builder.addVertex(invertibleBaseRadius * Mth.cos((float)radians), scale, baseRadius * Mth.sin((float)radians));
        }
        return builder.build();
    }

    protected void createStars(long seed, int numberOfStars) {
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.setShader(GameRenderer::getPositionShader);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        MeshData mesh = this.drawStars(tesselator, seed, numberOfStars);
        this.starBuffer.bind();
        this.starBuffer.upload(mesh);
        VertexBuffer.unbind();
    }

    protected MeshData drawStars(Tesselator tesselator, long seed, int numberOfStars) {
        RandomSource randomsource = RandomSource.create((long)seed);
        BufferBuilder builder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (int i = 0; i < numberOfStars; ++i) {
            double x = randomsource.nextFloat() * 2.0f - 1.0f;
            double y = randomsource.nextFloat() * 2.0f - 1.0f;
            double z = randomsource.nextFloat() * 2.0f - 1.0f;
            double starSize = 0.15f + randomsource.nextFloat() * 0.1f;
            double distance = x * x + y * y + z * z;
            if (!(distance < 1.0) || !(distance > 0.01)) continue;
            distance = 1.0 / Math.sqrt(distance);
            double starX = (x *= distance) * 100.0;
            double starY = (y *= distance) * 100.0;
            double starZ = (z *= distance) * 100.0;
            double sphericalTheta = Math.atan2(x, z);
            double sinTheta = Math.sin(sphericalTheta);
            double cosTheta = Math.cos(sphericalTheta);
            double xzLength = Math.sqrt(x * x + z * z);
            double sphericalPhi = Math.atan2(xzLength, y);
            double sinPhi = Math.sin(sphericalPhi);
            double cosPhi = Math.cos(sphericalPhi);
            double random = randomsource.nextDouble() * Math.PI * 2.0;
            double sinRandom = Math.sin(random);
            double cosRandom = Math.cos(random);
            for (int j = 0; j < 4; ++j) {
                double aLocation = (double)((j & 2) - 1) * starSize;
                double bLocation = (double)((j + 1 & 2) - 1) * starSize;
                double height = aLocation * cosRandom - bLocation * sinRandom;
                double width = bLocation * cosRandom + aLocation * sinRandom;
                double heightProjectionY = height * sinPhi;
                double heightProjectionXZ = -height * cosPhi;
                double projectedX = heightProjectionXZ * sinTheta - width * cosTheta;
                double projectedZ = width * sinTheta + heightProjectionXZ * cosTheta;
                builder.addVertex((float)(starX + projectedX), (float)(starY + heightProjectionY), (float)(starZ + projectedZ)).setColor(190, 160, 0, 170);
            }
        }
        return builder.build();
    }

    protected void renderStars(ClientLevel level, float partialTicks, float rain, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, Runnable setupFog) {
        float realBrightness = level.getStarBrightness(partialTicks) * rain;
        if (realBrightness > 0.0f) {
            RenderSystem.setShaderColor((float)realBrightness, (float)realBrightness, (float)realBrightness, (float)realBrightness);
            FogRenderer.setupNoFog();
            this.starBuffer.bind();
            this.starBuffer.drawWithShader(modelViewMatrix, projectionMatrix, GameRenderer.getPositionShader());
            VertexBuffer.unbind();
            setupFog.run();
        }
    }

    public static float[] moveSpherical(float offsetX, float offsetY, float r, double theta, double phi) {
        double x = (double)r * Math.sin(phi) * Math.sin(theta);
        double y = (double)r * Math.cos(phi);
        double z = (double)r * Math.sin(phi) * Math.cos(theta);
        return new float[]{(float)(x += (double)(-offsetY) * Math.cos(phi) * Math.sin(theta) - (double)offsetX * Math.cos(theta)), (float)(y += (double)offsetY * Math.sin(phi)), (float)(z += (double)(-offsetY) * Math.cos(phi) * Math.cos(theta) + (double)offsetX * Math.sin(theta))};
    }

    public void createCelestialObject(Tesselator tesselator, Matrix4f lastMatrix, ResourceLocation location, float size, float distance, float[] uv) {
        this.createCelestialObject(tesselator, lastMatrix, location, size, distance, 0.0f, 0.0f, uv);
    }

    public void createCelestialObject(Tesselator tesselator, Matrix4f lastMatrix, ResourceLocation location, float size, float distance, float theta, float phi, float[] uv) {
        float[] u0v0 = SGJourneySkyRenderer.moveSpherical(-size, -size, distance, theta, phi);
        float[] u1v0 = SGJourneySkyRenderer.moveSpherical(size, -size, distance, theta, phi);
        float[] u1v1 = SGJourneySkyRenderer.moveSpherical(size, size, distance, theta, phi);
        float[] u0v1 = SGJourneySkyRenderer.moveSpherical(-size, size, distance, theta, phi);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)location);
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(lastMatrix, u0v0[0], u0v0[1], u0v0[2]).setUv(uv[0], uv[1]);
        bufferbuilder.addVertex(lastMatrix, u1v0[0], u1v0[1], u1v0[2]).setUv(uv[2], uv[1]);
        bufferbuilder.addVertex(lastMatrix, u1v1[0], u1v1[1], u1v1[2]).setUv(uv[2], uv[3]);
        bufferbuilder.addVertex(lastMatrix, u0v1[0], u0v1[1], u0v1[2]).setUv(uv[0], uv[3]);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
    }

    protected void renderSun(Tesselator tesselator, Matrix4f lastMatrix, ResourceLocation texture, float size) {
        this.createCelestialObject(tesselator, lastMatrix, texture, size, 100.0f, new float[]{0.0f, 0.0f, 1.0f, 1.0f});
        RenderSystem.enableBlend();
    }

    protected void renderSun(Tesselator tesselator, Matrix4f lastMatrix, ResourceLocation texture, float size, float theta, float phi) {
        this.createCelestialObject(tesselator, lastMatrix, texture, size, 100.0f, theta, phi, new float[]{0.0f, 0.0f, 1.0f, 1.0f});
        RenderSystem.enableBlend();
    }

    protected void renderBlackHole(Tesselator tesselator, Matrix4f lastMatrix, float size, float theta, float phi) {
        this.createCelestialObject(tesselator, lastMatrix, BLACK_HOLE_HALO_LOCATION, size, 100.0f, theta, phi, new float[]{0.0f, 0.0f, 1.0f, 1.0f});
        RenderSystem.disableBlend();
        this.createCelestialObject(tesselator, lastMatrix, BLACK_HOLE_LOCATION, size, 100.0f, theta, phi, new float[]{0.0f, 0.0f, 1.0f, 1.0f});
        RenderSystem.enableBlend();
    }

    protected void renderMoon(Tesselator tesselator, Matrix4f lastMatrix, float size, int phase, float theta, float phi) {
        int x = phase % 4;
        int y = phase / 4 % 2;
        float xStart = (float)(x + 0) / 4.0f;
        float yStart = (float)(y + 0) / 2.0f;
        float xEnd = (float)(x + 1) / 4.0f;
        float yEnd = (float)(y + 1) / 2.0f;
        this.createCelestialObject(tesselator, lastMatrix, MOON_HALO_LOCATION, size, 100.0f, theta, phi, new float[]{0.0f, 0.0f, 1.0f, 1.0f});
        RenderSystem.disableBlend();
        this.createCelestialObject(tesselator, lastMatrix, MOON_LOCATION, size / 4.0f, 100.0f, theta, phi, new float[]{xStart, yStart, xEnd, yEnd});
        RenderSystem.enableBlend();
    }

    protected void renderSunrise(ClientLevel level, float partialTicks, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, Runnable setupFog, Tesselator tesselator) {
        float[] sunriseColor = level.effects().getSunriseColor(level.getTimeOfDay(partialTicks), partialTicks);
        if (sunriseColor != null) {
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Matrix4f transformedModelView = new Matrix4f((Matrix4fc)modelViewMatrix);
            transformedModelView.rotate((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            float sunAngle = Mth.sin((float)level.getSunAngle(partialTicks)) < 0.0f ? 180.0f : 0.0f;
            transformedModelView.rotate((Quaternionfc)Axis.ZP.rotationDegrees(sunAngle));
            transformedModelView.rotate((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
            float sunriseR = sunriseColor[0];
            float sunriseG = sunriseColor[1];
            float sunriseB = sunriseColor[2];
            float sunriseA = sunriseColor[2];
            Matrix4f sunriseMatrix = transformedModelView;
            BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            bufferbuilder.addVertex(sunriseMatrix, 0.0f, 100.0f, 0.0f).setColor(sunriseR, sunriseG, sunriseB, sunriseA);
            for (int i = 0; i <= 16; ++i) {
                float rotation = (float)i * ((float)Math.PI * 2) / 16.0f;
                float x = Mth.sin((float)rotation);
                float y = Mth.cos((float)rotation);
                bufferbuilder.addVertex(sunriseMatrix, x * 120.0f, y * 120.0f, -y * 40.0f * sunriseA).setColor(sunriseR, sunriseG, sunriseB, 0.0f);
            }
            BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
        }
    }

    protected abstract void renderCelestials(ClientLevel var1, float var2, Matrix4f var3, Matrix4f var4, Runnable var5, Tesselator var6, float var7);

    protected void renderEcliptic(ClientLevel level, float partialTicks, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, Runnable setupFog, Tesselator tesselator, float rain) {
        Matrix4f transformedModelView = new Matrix4f((Matrix4fc)modelViewMatrix);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)rain);
        transformedModelView.rotate((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        transformedModelView.rotate((Quaternionfc)Axis.XP.rotationDegrees(level.getTimeOfDay(partialTicks) * 360.0f));
        this.renderStars(level, partialTicks, rain, transformedModelView, projectionMatrix, setupFog);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        this.renderCelestials(level, partialTicks, transformedModelView, projectionMatrix, setupFog, tesselator, rain);
    }

    public void renderSky(ClientLevel level, float partialTicks, Matrix4f modelViewMatrix, Camera camera, Matrix4f projectionMatrix, Runnable setupFog) {
        setupFog.run();
        if (this.isFoggy(camera)) {
            return;
        }
        Vec3 skyColor = level.getSkyColor(this.minecraft.gameRenderer.getMainCamera().getPosition(), partialTicks);
        float skyX = (float)skyColor.x;
        float skyY = (float)skyColor.y;
        float skyZ = (float)skyColor.z;
        FogRenderer.levelFogColor();
        Tesselator tesselator = Tesselator.getInstance();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)skyX, (float)skyY, (float)skyZ, (float)1.0f);
        ShaderInstance shaderinstance = RenderSystem.getShader();
        this.skyBuffer.bind();
        this.skyBuffer.drawWithShader(modelViewMatrix, projectionMatrix, shaderinstance);
        VertexBuffer.unbind();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.renderSunrise(level, partialTicks, modelViewMatrix, projectionMatrix, setupFog, tesselator);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        float rain = 1.0f - level.getRainLevel(partialTicks);
        this.renderEcliptic(level, partialTicks, modelViewMatrix, projectionMatrix, setupFog, tesselator, rain);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        double height = this.minecraft.player.getEyePosition((float)partialTicks).y - level.getLevelData().getHorizonHeight((LevelHeightAccessor)level);
        if (height < 0.0) {
            Matrix4f transformedModelView = new Matrix4f((Matrix4fc)modelViewMatrix);
            transformedModelView.translate(0.0f, 12.0f, 0.0f);
            this.darkBuffer.bind();
            this.darkBuffer.drawWithShader(transformedModelView, projectionMatrix, shaderinstance);
            VertexBuffer.unbind();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }
}

