/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.resourcepack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.misc.ColorUtil;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public class ResourcepackModel {

    public static class SymbolsModel {
        public static final String SYMBOL_COLOR = "symbol_color";
        public static final String ENCODED_SYMBOL_COLOR = "encoded_symbol_color";
        public static final String ENGAGED_SYMBOL_COLOR = "engaged_symbol_color";
        public static final String SYMBOLS_GLOW = "symbols_glow";
        public static final String ENCODED_SYMBOLS_GLOW = "encoded_symbols_glow";
        public static final String ENGAGED_SYMBOLS_GLOW = "engaged_symbols_glow";
        public static final String ENGAGE_ENCODED_SYMBOLS = "engage_encoded_symbols";
        public static final String ENGAGE_SYMBOLS_ON_INCOMING = "engage_symbols_on_incoming";
        public static final String PERMANENT_POINT_OF_ORIGIN = "permanent_point_of_origin";
        public static final String PERMANENT_SYMBOLS = "permanent_symbols";
        private final ColorUtil.RGBA symbolColor;
        private final ColorUtil.RGBA encodedSymbolColor;
        private final ColorUtil.RGBA engagedSymbolColor;
        private final boolean symbolsGlow;
        private final boolean encodedSymbolsGlow;
        private final boolean engagedSymbolsGlow;
        private final boolean engageEncodedSymbols;
        private final boolean engageSymbolsOnIncoming;
        @Nullable
        private ResourceKey<PointOfOrigin> permanentPointOfOrigin;
        @Nullable
        private ResourceKey<Symbols> permanentSymbols;
        public static final Codec<SymbolsModel> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ColorUtil.RGBA.CODEC.fieldOf(SYMBOL_COLOR).forGetter(SymbolsModel::symbolColor), (App)ColorUtil.RGBA.CODEC.optionalFieldOf(ENCODED_SYMBOL_COLOR).forGetter(symbols -> Optional.ofNullable(symbols.encodedSymbolColor)), (App)ColorUtil.RGBA.CODEC.optionalFieldOf(ENGAGED_SYMBOL_COLOR).forGetter(symbols -> Optional.ofNullable(symbols.engagedSymbolColor)), (App)Codec.BOOL.optionalFieldOf(SYMBOLS_GLOW, (Object)false).forGetter(symbols -> symbols.symbolsGlow), (App)Codec.BOOL.optionalFieldOf(ENCODED_SYMBOLS_GLOW, (Object)false).forGetter(symbols -> symbols.encodedSymbolsGlow), (App)Codec.BOOL.optionalFieldOf(ENGAGED_SYMBOLS_GLOW, (Object)false).forGetter(symbols -> symbols.engagedSymbolsGlow), (App)Codec.BOOL.optionalFieldOf(ENGAGE_ENCODED_SYMBOLS, (Object)false).forGetter(symbols -> symbols.engageEncodedSymbols), (App)Codec.BOOL.optionalFieldOf(ENGAGE_SYMBOLS_ON_INCOMING, (Object)false).forGetter(symbols -> symbols.engageSymbolsOnIncoming), (App)ResourceKey.codec(PointOfOrigin.REGISTRY_KEY).optionalFieldOf(PERMANENT_POINT_OF_ORIGIN).forGetter(SymbolsModel::permanentPointOfOrigin), (App)ResourceKey.codec(Symbols.REGISTRY_KEY).optionalFieldOf(PERMANENT_SYMBOLS).forGetter(SymbolsModel::permanentSymbols)).apply((Applicative)instance, SymbolsModel::new));

        public SymbolsModel(ColorUtil.RGBA symbolColor, Optional<ColorUtil.RGBA> encodedSymbolColor, Optional<ColorUtil.RGBA> engagedSymbolColor, boolean symbolsGlow, boolean encodedSymbolsGlow, boolean engagedSymbolsGlow, boolean engageEncodedSymbols, boolean engageSymbolsOnIncoming, Optional<ResourceKey<PointOfOrigin>> permanentPointOfOrigin, Optional<ResourceKey<Symbols>> permanentSymbols) {
            this.symbolColor = symbolColor;
            this.engagedSymbolColor = engagedSymbolColor.isPresent() ? engagedSymbolColor.get() : symbolColor;
            this.encodedSymbolColor = encodedSymbolColor.isPresent() ? encodedSymbolColor.get() : this.engagedSymbolColor;
            this.symbolsGlow = symbolsGlow;
            this.encodedSymbolsGlow = encodedSymbolsGlow;
            this.engagedSymbolsGlow = engagedSymbolsGlow;
            this.engageEncodedSymbols = engageEncodedSymbols;
            this.engageSymbolsOnIncoming = engageSymbolsOnIncoming;
            if (permanentPointOfOrigin.isPresent()) {
                this.permanentPointOfOrigin = permanentPointOfOrigin.get();
            }
            if (permanentSymbols.isPresent()) {
                this.permanentSymbols = permanentSymbols.get();
            }
        }

        public SymbolsModel(ColorUtil.RGBA symbolColor) {
            this(symbolColor, Optional.empty(), Optional.empty(), false, false, false, false, false, Optional.empty(), Optional.empty());
        }

        public ColorUtil.RGBA symbolColor() {
            return this.symbolColor;
        }

        public ColorUtil.RGBA encodedSymbolColor() {
            return this.encodedSymbolColor;
        }

        public ColorUtil.RGBA engagedSymbolColor() {
            return this.engagedSymbolColor;
        }

        public boolean symbolsGlow() {
            return this.symbolsGlow;
        }

        public boolean encodedSymbolsGlow() {
            return this.encodedSymbolsGlow;
        }

        public boolean engagedSymbolsGlow() {
            return this.engagedSymbolsGlow;
        }

        public boolean engageEncodedSymbols() {
            return this.engageEncodedSymbols;
        }

        public boolean engageSymbolsOnIncoming() {
            return this.engageSymbolsOnIncoming;
        }

        public Optional<ResourceKey<PointOfOrigin>> permanentPointOfOrigin() {
            return Optional.ofNullable(this.permanentPointOfOrigin);
        }

        public Optional<ResourceKey<Symbols>> permanentSymbols() {
            return Optional.ofNullable(this.permanentSymbols);
        }
    }

    public static class Wormhole {
        public static final String DISTORTION = "distortion";
        public static final String HAS_STRUDEL = "has_strudel";
        public static final String EVENT_HORIZON = "event_horizon";
        public static final String KAWOOSH = "kawoosh";
        public static final String STRUDEL = "strudel";
        @Nullable
        private final Integer distortion;
        @Nullable
        private final Boolean hasStrudel;
        private final Either<FrontBack, WormholeTexture> eventHorizon;
        @Nullable
        private final Either<FrontBack, WormholeTexture> kawoosh;
        @Nullable
        private final Either<FrontBack, WormholeTexture> strudel;
        public static final Codec<Wormhole> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)25).optionalFieldOf(DISTORTION).forGetter(wormhole -> Optional.ofNullable(wormhole.distortion)), (App)Codec.BOOL.optionalFieldOf(HAS_STRUDEL).forGetter(wormhole -> Optional.ofNullable(wormhole.hasStrudel)), (App)Codec.either(FrontBack.CODEC, WormholeTexture.CODEC).fieldOf(EVENT_HORIZON).forGetter(Wormhole::eventHorizon), (App)Codec.either(FrontBack.CODEC, WormholeTexture.CODEC).optionalFieldOf(KAWOOSH).forGetter(wormhole -> Optional.ofNullable(wormhole.kawoosh)), (App)Codec.either(FrontBack.CODEC, WormholeTexture.CODEC).optionalFieldOf(STRUDEL).forGetter(wormhole -> Optional.ofNullable(wormhole.strudel))).apply((Applicative)instance, Wormhole::new));

        public Wormhole(Optional<Integer> distortion, Optional<Boolean> hasStrudel, Either<FrontBack, WormholeTexture> eventHorizon, Optional<Either<FrontBack, WormholeTexture>> kawoosh, Optional<Either<FrontBack, WormholeTexture>> strudel) {
            this.distortion = distortion.isPresent() ? distortion.get() : null;
            this.hasStrudel = hasStrudel.isPresent() ? hasStrudel.get() : null;
            this.eventHorizon = eventHorizon;
            this.kawoosh = kawoosh.isPresent() ? kawoosh.get() : null;
            this.strudel = strudel.isPresent() ? strudel.get() : null;
        }

        public Wormhole(Either<FrontBack, WormholeTexture> eventHorizon) {
            this(Optional.empty(), Optional.empty(), eventHorizon, Optional.empty(), Optional.empty());
        }

        public int distortion() {
            if (this.distortion != null) {
                return this.distortion;
            }
            return ClientStargateConfig.event_horizon_distortion.get();
        }

        public boolean hasStrudel() {
            if (this.hasStrudel != null) {
                return this.hasStrudel;
            }
            return ClientStargateConfig.enable_vortex.get();
        }

        public Either<FrontBack, WormholeTexture> eventHorizon() {
            return this.eventHorizon;
        }

        public Either<FrontBack, WormholeTexture> kawoosh() {
            return this.kawoosh != null ? this.kawoosh : this.eventHorizon;
        }

        public Either<FrontBack, WormholeTexture> strudel() {
            return this.strudel != null ? this.strudel : this.eventHorizon;
        }

        private static WormholeTexture getWormholeTexture(Either<FrontBack, WormholeTexture> eventHorizon, boolean front) {
            if (eventHorizon.left().isPresent()) {
                return front ? ((FrontBack)eventHorizon.left().get()).front() : ((FrontBack)eventHorizon.left().get()).back();
            }
            return (WormholeTexture)eventHorizon.right().get();
        }

        public WormholeTexture eventHorizonTexture(boolean front) {
            return Wormhole.getWormholeTexture(this.eventHorizon(), front);
        }

        public WormholeTexture kawooshTexture(boolean front) {
            return Wormhole.getWormholeTexture(this.kawoosh(), front);
        }

        public WormholeTexture strudelTexture(boolean front) {
            return Wormhole.getWormholeTexture(this.strudel(), front);
        }
    }

    public static class FrontBack {
        public static final String FRONT = "front";
        public static final String BACK = "back";
        public static final Codec<FrontBack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WormholeTexture.CODEC.fieldOf(FRONT).forGetter(FrontBack::front), (App)WormholeTexture.CODEC.fieldOf(BACK).forGetter(FrontBack::back)).apply((Applicative)instance, FrontBack::new));
        private final WormholeTexture front;
        private final WormholeTexture back;

        public FrontBack(WormholeTexture front, WormholeTexture back) {
            this.front = front;
            this.back = back;
        }

        public WormholeTexture front() {
            return this.front;
        }

        public WormholeTexture back() {
            return this.back;
        }
    }

    public static class WormholeTexture {
        public static final String TEXTURE = "texture";
        public static final String ROWS = "rows";
        public static final String COLUMNS = "columns";
        public static final String FRAMES = "frames";
        public static final String RGBA = "rgba";
        public static final ColorUtil.RGBA DEFAULT_OPAQUE_RGBA = new ColorUtil.RGBA(1.0f, 1.0f, 1.0f, 1.0f);
        public static final Codec<WormholeTexture> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf(TEXTURE).forGetter(WormholeTexture::texture), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf(ROWS).forGetter(WormholeTexture::rows), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf(COLUMNS).forGetter(WormholeTexture::columns), (App)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf(FRAMES).forGetter(WormholeTexture::columns), (App)ColorUtil.RGBA.CODEC.optionalFieldOf(RGBA, (Object)DEFAULT_OPAQUE_RGBA).forGetter(WormholeTexture::rgba)).apply((Applicative)instance, WormholeTexture::new));
        private final ResourceLocation texture;
        private final int rows;
        private final int columns;
        private final int frames;
        private final ColorUtil.RGBA rgba;
        private final float uScale;
        private final float vScale;

        public WormholeTexture(ResourceLocation texture, int rows, int columns, int frames, ColorUtil.RGBA rgba) {
            this.texture = texture;
            this.rows = rows;
            this.columns = columns;
            this.frames = frames;
            this.rgba = rgba;
            this.uScale = 1.0f / (float)columns;
            this.vScale = 1.0f / (float)rows;
        }

        public ResourceLocation texture() {
            return this.texture;
        }

        public int rows() {
            return this.rows;
        }

        public int columns() {
            return this.columns;
        }

        public int frames() {
            return this.frames;
        }

        public ColorUtil.RGBA rgba() {
            return this.rgba;
        }

        public float uScale() {
            return this.uScale;
        }

        public float vScale() {
            return this.vScale;
        }

        public int frame(int tick) {
            return tick % this.frames;
        }

        public float uOffset(int frame) {
            int xOffset = frame / this.rows;
            return (float)(xOffset % this.columns) / (float)this.columns;
        }

        public float vOffset(int frame) {
            return (float)(frame % this.rows) / (float)this.rows;
        }
    }
}

