/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.resourcepack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;

public class ResourcepackSounds {

    public static class Fail {
        public static final String DEFAULT = "default";
        public final ResourceLocation defaultSound;
        public static final Codec<Fail> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf(DEFAULT).forGetter(chevrons -> chevrons.defaultSound)).apply((Applicative)instance, Fail::new));

        public Fail(ResourceLocation defaultSound) {
            this.defaultSound = defaultSound;
        }

        public ResourceLocation getSound(StargateInfo.Feedback feedback) {
            switch (feedback) {
                default: 
            }
            return this.defaultSound;
        }
    }

    public static class Wormhole {
        public static final String OPEN_SOUND = "open";
        public static final String IDLE_SOUND = "idle";
        public static final String CLOSE_SOUND = "close";
        public static final Codec<Wormhole> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StargateInfo.IncomingOutgoing.bothCodec(ResourceLocation.CODEC).fieldOf(OPEN_SOUND).forGetter(Wormhole::openSound), (App)StargateInfo.IncomingOutgoing.bothCodec(ResourceLocation.CODEC).fieldOf(IDLE_SOUND).forGetter(Wormhole::idleSound), (App)StargateInfo.IncomingOutgoing.bothCodec(ResourceLocation.CODEC).fieldOf(CLOSE_SOUND).forGetter(Wormhole::closeSound)).apply((Applicative)instance, Wormhole::new));
        private final Either<StargateInfo.IncomingOutgoing<ResourceLocation>, ResourceLocation> openSound;
        private final Either<StargateInfo.IncomingOutgoing<ResourceLocation>, ResourceLocation> idleSound;
        private final Either<StargateInfo.IncomingOutgoing<ResourceLocation>, ResourceLocation> closeSound;

        public Wormhole(Either<StargateInfo.IncomingOutgoing<ResourceLocation>, ResourceLocation> openSound, Either<StargateInfo.IncomingOutgoing<ResourceLocation>, ResourceLocation> idleSound, Either<StargateInfo.IncomingOutgoing<ResourceLocation>, ResourceLocation> closeSound) {
            this.openSound = openSound;
            this.idleSound = idleSound;
            this.closeSound = closeSound;
        }

        public Either<StargateInfo.IncomingOutgoing<ResourceLocation>, ResourceLocation> openSound() {
            return this.openSound;
        }

        public Either<StargateInfo.IncomingOutgoing<ResourceLocation>, ResourceLocation> idleSound() {
            return this.idleSound;
        }

        public Either<StargateInfo.IncomingOutgoing<ResourceLocation>, ResourceLocation> closeSound() {
            return this.closeSound;
        }

        public ResourceLocation getOpenSound(boolean incoming) {
            if (this.openSound.left().isPresent()) {
                return incoming ? (ResourceLocation)((StargateInfo.IncomingOutgoing)this.openSound.left().get()).incoming() : (ResourceLocation)((StargateInfo.IncomingOutgoing)this.openSound.left().get()).outgoing();
            }
            return (ResourceLocation)this.openSound.right().get();
        }

        public ResourceLocation getIdleSound(boolean incoming) {
            if (this.idleSound.left().isPresent()) {
                return incoming ? (ResourceLocation)((StargateInfo.IncomingOutgoing)this.idleSound.left().get()).incoming() : (ResourceLocation)((StargateInfo.IncomingOutgoing)this.idleSound.left().get()).outgoing();
            }
            return (ResourceLocation)this.idleSound.right().get();
        }

        public ResourceLocation getCloseSound(boolean incoming) {
            if (this.closeSound.left().isPresent()) {
                return incoming ? (ResourceLocation)((StargateInfo.IncomingOutgoing)this.closeSound.left().get()).incoming() : (ResourceLocation)((StargateInfo.IncomingOutgoing)this.closeSound.left().get()).outgoing();
            }
            return (ResourceLocation)this.closeSound.right().get();
        }
    }

    public static class Rotation {
        public static final String ROTATION_STARTUP_SOUND = "rotation_startup_sound";
        public static final String ROTATION_SOUND = "rotation_sound";
        public static final String ROTATION_STOP_SOUND = "rotation_stop_sound";
        private ResourceLocation rotationStartupSound;
        private ResourceLocation rotationSound;
        private ResourceLocation rotationStopSound;
        public static final Codec<Rotation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.optionalFieldOf(ROTATION_STARTUP_SOUND, (Object)StargateJourney.EMPTY_LOCATION).forGetter(Rotation::rotationStartupSound), (App)ResourceLocation.CODEC.optionalFieldOf(ROTATION_SOUND, (Object)StargateJourney.EMPTY_LOCATION).forGetter(Rotation::rotationSound), (App)ResourceLocation.CODEC.optionalFieldOf(ROTATION_STOP_SOUND, (Object)StargateJourney.EMPTY_LOCATION).forGetter(Rotation::rotationStopSound)).apply((Applicative)instance, Rotation::new));

        public Rotation(ResourceLocation rotationStartupSound, ResourceLocation rotationSound, ResourceLocation rotationStopSound) {
            this.rotationStartupSound = rotationStartupSound;
            this.rotationSound = rotationSound;
            this.rotationStopSound = rotationStopSound;
        }

        public ResourceLocation rotationStartupSound() {
            return this.rotationStartupSound;
        }

        public ResourceLocation rotationSound() {
            return this.rotationSound;
        }

        public ResourceLocation rotationStopSound() {
            return this.rotationStopSound;
        }
    }

    public static class Chevron {
        public static final String DEFAULT = "default";
        public static final String PRIMARY = "primary_chevron";
        public static final String CHEVRON_1 = "chevron_1";
        public static final String CHEVRON_2 = "chevron_2";
        public static final String CHEVRON_3 = "chevron_3";
        public static final String CHEVRON_4 = "chevron_4";
        public static final String CHEVRON_5 = "chevron_5";
        public static final String CHEVRON_6 = "chevron_6";
        public static final String CHEVRON_7 = "chevron_7";
        public static final String CHEVRON_8 = "chevron_8";
        public final ResourceLocation defaultSound;
        public final ResourceLocation primaryChevron;
        public final ResourceLocation chevron1;
        public final ResourceLocation chevron2;
        public final ResourceLocation chevron3;
        public final ResourceLocation chevron4;
        public final ResourceLocation chevron5;
        public final ResourceLocation chevron6;
        public final ResourceLocation chevron7;
        public final ResourceLocation chevron8;
        public static final Codec<Chevron> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf(DEFAULT).forGetter(chevrons -> chevrons.defaultSound), (App)ResourceLocation.CODEC.optionalFieldOf(PRIMARY).forGetter(chevrons -> Optional.ofNullable(chevrons.primaryChevron)), (App)ResourceLocation.CODEC.optionalFieldOf(CHEVRON_1).forGetter(chevrons -> Optional.ofNullable(chevrons.chevron1)), (App)ResourceLocation.CODEC.optionalFieldOf(CHEVRON_2).forGetter(chevrons -> Optional.ofNullable(chevrons.chevron2)), (App)ResourceLocation.CODEC.optionalFieldOf(CHEVRON_3).forGetter(chevrons -> Optional.ofNullable(chevrons.chevron3)), (App)ResourceLocation.CODEC.optionalFieldOf(CHEVRON_4).forGetter(chevrons -> Optional.ofNullable(chevrons.chevron4)), (App)ResourceLocation.CODEC.optionalFieldOf(CHEVRON_5).forGetter(chevrons -> Optional.ofNullable(chevrons.chevron5)), (App)ResourceLocation.CODEC.optionalFieldOf(CHEVRON_6).forGetter(chevrons -> Optional.ofNullable(chevrons.chevron6)), (App)ResourceLocation.CODEC.optionalFieldOf(CHEVRON_7).forGetter(chevrons -> Optional.ofNullable(chevrons.chevron7)), (App)ResourceLocation.CODEC.optionalFieldOf(CHEVRON_8).forGetter(chevrons -> Optional.ofNullable(chevrons.chevron8))).apply((Applicative)instance, Chevron::new));

        public Chevron(ResourceLocation defaultSound, Optional<ResourceLocation> primaryChevron, Optional<ResourceLocation> chevron1, Optional<ResourceLocation> chevron2, Optional<ResourceLocation> chevron3, Optional<ResourceLocation> chevron4, Optional<ResourceLocation> chevron5, Optional<ResourceLocation> chevron6, Optional<ResourceLocation> chevron7, Optional<ResourceLocation> chevron8) {
            this.defaultSound = defaultSound;
            this.primaryChevron = primaryChevron.isPresent() ? primaryChevron.get() : this.defaultSound;
            this.chevron1 = chevron1.isPresent() ? chevron1.get() : this.defaultSound;
            this.chevron2 = chevron2.isPresent() ? chevron2.get() : this.defaultSound;
            this.chevron3 = chevron3.isPresent() ? chevron3.get() : this.defaultSound;
            this.chevron4 = chevron4.isPresent() ? chevron4.get() : this.defaultSound;
            this.chevron5 = chevron5.isPresent() ? chevron5.get() : this.defaultSound;
            this.chevron6 = chevron6.isPresent() ? chevron6.get() : this.defaultSound;
            this.chevron7 = chevron7.isPresent() ? chevron7.get() : this.defaultSound;
            this.chevron8 = chevron8.isPresent() ? chevron8.get() : this.defaultSound;
        }

        public Chevron(ResourceLocation defaultSound) {
            this(defaultSound, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }

        public ResourceLocation getSound(short chevron) {
            return switch (chevron) {
                case 0 -> this.primaryChevron;
                case 1 -> this.chevron1;
                case 2 -> this.chevron2;
                case 3 -> this.chevron3;
                case 4 -> this.chevron4;
                case 5 -> this.chevron5;
                case 6 -> this.chevron6;
                case 7 -> this.chevron7;
                case 8 -> this.chevron8;
                default -> this.defaultSound;
            };
        }
    }
}

