/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.povstalec.sgjourney.common.menu.AbstractDHDMenu;

public abstract class AbstractDHDScreen
extends AbstractContainerScreen<AbstractDHDMenu> {
    private ResourceLocation texture;

    public AbstractDHDScreen(AbstractDHDMenu menu, Inventory playerInventory, Component title, ResourceLocation texture) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 192;
        this.imageHeight = 192;
        this.texture = texture;
    }

    protected void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(this.texture, x, y, 0, 0, this.imageWidth, this.imageHeight + 1);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.render(graphics, mouseX, mouseY, delta);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    private void tooltip(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, String number) {
        if (this.isHovering(x, y, 16, 16, mouseX, mouseY)) {
            graphics.renderTooltip(this.font, (Component)Component.literal((String)number), mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
    }
}

