/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.widgets.GDOButton;
import net.povstalec.sgjourney.client.widgets.GDOLargeButton;
import net.povstalec.sgjourney.common.packets.ServerboundGDOUpdatePacket;

public class GDOScreen
extends Screen {
    private static final ResourceLocation TEXTURE = StargateJourney.sgjourneyLocation("textures/gui/gdo/gdo_background.png");
    private int imageWidth = 240;
    private int imageHeight = 120;
    private final UUID playerId;
    private final boolean mainHand;
    private String idc;
    private int frequency;
    private boolean toggledFrequency = false;

    public GDOScreen(UUID playerId, boolean mainHand, String idc, int frequency) {
        super((Component)Component.empty());
        this.playerId = playerId;
        this.idc = idc;
        this.frequency = frequency;
        this.mainHand = mainHand;
    }

    public void init() {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        super.init();
        this.addRenderableWidget((GuiEventListener)new GDOButton(x + 75, y + 37, (Component)Component.literal((String)"7"), button -> this.addToCode(7)));
        this.addRenderableWidget((GuiEventListener)new GDOButton(x + 93, y + 37, (Component)Component.literal((String)"8"), button -> this.addToCode(8)));
        this.addRenderableWidget((GuiEventListener)new GDOButton(x + 111, y + 37, (Component)Component.literal((String)"9"), button -> this.addToCode(9)));
        this.addRenderableWidget((GuiEventListener)new GDOButton(x + 75, y + 49, (Component)Component.literal((String)"4"), button -> this.addToCode(4)));
        this.addRenderableWidget((GuiEventListener)new GDOButton(x + 93, y + 49, (Component)Component.literal((String)"5"), button -> this.addToCode(5)));
        this.addRenderableWidget((GuiEventListener)new GDOButton(x + 111, y + 49, (Component)Component.literal((String)"6"), button -> this.addToCode(6)));
        this.addRenderableWidget((GuiEventListener)new GDOButton(x + 75, y + 61, (Component)Component.literal((String)"1"), button -> this.addToCode(1)));
        this.addRenderableWidget((GuiEventListener)new GDOButton(x + 93, y + 61, (Component)Component.literal((String)"2"), button -> this.addToCode(2)));
        this.addRenderableWidget((GuiEventListener)new GDOButton(x + 111, y + 61, (Component)Component.literal((String)"3"), button -> this.addToCode(3)));
        this.addRenderableWidget((GuiEventListener)new GDOButton(x + 75, y + 73, (Component)Component.translatable((String)"screen.sgjourney.gdo.symbol.delete"), (Component)Component.translatable((String)"screen.sgjourney.gdo.delete"), button -> this.removeFromCode()));
        this.addRenderableWidget((GuiEventListener)new GDOButton(x + 93, y + 73, (Component)Component.literal((String)"0"), button -> this.addToCode(0)));
        this.addRenderableWidget((GuiEventListener)new GDOButton(x + 111, y + 73, (Component)Component.translatable((String)"screen.sgjourney.gdo.symbol.toggle_frequency"), (Component)Component.translatable((String)"screen.sgjourney.gdo.toggle_frequency"), button -> this.toggleFrequency()));
        this.addRenderableWidget((GuiEventListener)new GDOLargeButton(x + 32, y + 46, (Component)Component.empty(), (Component)Component.translatable((String)"screen.sgjourney.gdo.send_transmission"), button -> this.sendTransmission()));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        this.renderBackground(graphics, mouseX, mouseY, delta);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        for (Renderable renderable : this.renderables) {
            renderable.render(graphics, mouseX, mouseY, delta);
        }
        PoseStack stack = graphics.pose();
        stack.pushPose();
        stack.scale(0.5f, 0.5f, 0.5f);
        stack.translate((float)x, (float)y, 0.0f);
        this.renderLabels(graphics, mouseX, mouseY, x, y);
        stack.popPose();
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY, int x, int y) {
        graphics.drawString(this.font, (Component)Component.literal((String)this.idc), x + 266, y + 104, 2763047, false);
        graphics.drawString(this.font, (Component)Component.translatable((String)"screen.sgjourney.transceiver.frequency").append((Component)Component.literal((String)(this.toggledFrequency ? ": #" : ":"))), x + 266, y + 120, 2763047, false);
        graphics.drawString(this.font, (Component)Component.literal((String)String.valueOf(this.frequency)), x + 266, y + 132, 2763047, false);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 48: 
            case 320: {
                this.addToCode(0);
                break;
            }
            case 49: 
            case 321: {
                this.addToCode(1);
                break;
            }
            case 50: 
            case 322: {
                this.addToCode(2);
                break;
            }
            case 51: 
            case 323: {
                this.addToCode(3);
                break;
            }
            case 52: 
            case 324: {
                this.addToCode(4);
                break;
            }
            case 53: 
            case 325: {
                this.addToCode(5);
                break;
            }
            case 54: 
            case 326: {
                this.addToCode(6);
                break;
            }
            case 55: 
            case 327: {
                this.addToCode(7);
                break;
            }
            case 56: 
            case 328: {
                this.addToCode(8);
                break;
            }
            case 57: 
            case 329: {
                this.addToCode(9);
                break;
            }
            case 259: 
            case 261: {
                this.removeFromCode();
                break;
            }
            case 257: 
            case 335: {
                this.sendTransmission();
                break;
            }
            case 341: 
            case 345: {
                this.toggleFrequency();
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private void sendTransmission() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundGDOUpdatePacket(this.mainHand, this.idc, this.frequency, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void updateServer() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundGDOUpdatePacket(this.mainHand, this.idc, this.frequency, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void toggleFrequency() {
        this.toggledFrequency = !this.toggledFrequency;
    }

    private void addToCode(int number) {
        if (!this.toggledFrequency) {
            if (this.idc.length() >= 16) {
                return;
            }
            this.idc = this.idc + String.valueOf(number);
        } else {
            long tempFrequency = this.frequency;
            if ((tempFrequency = tempFrequency * 10L + (long)number) > Integer.MAX_VALUE) {
                return;
            }
            this.frequency = (int)tempFrequency;
        }
        this.updateServer();
    }

    private void removeFromCode() {
        if (!this.toggledFrequency) {
            if (this.idc.length() <= 0) {
                return;
            }
            this.idc = this.idc.substring(0, this.idc.length() - 1);
        } else {
            if (this.frequency <= 0) {
                return;
            }
            this.frequency /= 10;
        }
        this.updateServer();
    }
}

