/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.sound.sounds;

import net.minecraft.sounds.SoundEvent;
import net.povstalec.sgjourney.client.sound.sounds.StargateSound;
import net.povstalec.sgjourney.common.block_entities.stargate.RotatingStargateEntity;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;

public class RotatingStargateRingStartupSound
extends StargateSound<RotatingStargateEntity> {
    private static final float VOLUME_MIN = 0.0f;
    private static final float VOLUME_MAX = 0.5f;

    public RotatingStargateRingStartupSound(RotatingStargateEntity stargate, SoundEvent soundEvent) {
        super(stargate, soundEvent);
        this.volume = 0.0f;
    }

    public boolean isLooping() {
        return false;
    }

    @Override
    public void tick() {
        if (((RotatingStargateEntity)this.stargate).isRotating()) {
            this.fadeIn();
        } else {
            this.fadeOut();
        }
        if (this.getDistanceFromSource() > (double)ClientStargateConfig.stargate_max_sound_distance.get()) {
            this.stopSound();
        }
        super.tick();
    }

    @Override
    public boolean canStartSilent() {
        return true;
    }

    private void fadeIn() {
        if (this.volume < 0.5f) {
            this.volume += 0.1f;
        }
    }

    private void fadeOut() {
        if (this.volume > 0.0f) {
            this.volume -= 0.1f;
        }
    }
}

