/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.sound.sounds;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;

public abstract class StargateSound<T extends AbstractStargateEntity>
extends AbstractTickableSoundInstance {
    protected T stargate;
    protected BlockPos stargatePos;
    protected Minecraft minecraft = Minecraft.getInstance();

    protected StargateSound(T stargate, SoundEvent soundEvent) {
        super(soundEvent, SoundSource.BLOCKS, SoundInstance.createUnseededRandom());
        this.stargate = stargate;
        this.stargatePos = stargate.getBlockPos();
        this.x = ((AbstractStargateEntity)stargate).getCenterPos().getX();
        this.y = ((AbstractStargateEntity)stargate).getCenterPos().getY();
        this.z = ((AbstractStargateEntity)stargate).getCenterPos().getZ();
        this.relative = true;
    }

    public void tick() {
        if (!(Minecraft.getInstance().level.getBlockEntity(this.stargatePos) instanceof AbstractStargateEntity)) {
            this.stop();
        }
    }

    public boolean canStartSilent() {
        return true;
    }

    public void stopSound() {
        this.stop();
    }

    public Vec3 getPosition() {
        return new Vec3(this.x, this.y, this.z);
    }

    public double getDistanceFromSource() {
        LocalPlayer player = this.minecraft.player;
        Vec3 playerPos = player.position();
        return this.getPosition().distanceTo(playerPos);
    }

    public float getVolume() {
        float maxDistance;
        float localVolume = 0.0f;
        double distanceFromSource = this.getDistanceFromSource();
        float fullDistance = ClientStargateConfig.stargate_full_sound_distance.get();
        if (fullDistance >= (maxDistance = (float)ClientStargateConfig.stargate_max_sound_distance.get())) {
            maxDistance = fullDistance + 1.0f;
        }
        localVolume = distanceFromSource <= (double)fullDistance ? this.getMaxVolume() : (distanceFromSource <= (double)maxDistance ? (float)((double)this.getMaxVolume() - (distanceFromSource - (double)fullDistance) / (double)(maxDistance - fullDistance)) : this.getMinVolume());
        return super.getVolume() * localVolume;
    }

    public float getMaxVolume() {
        return 1.0f;
    }

    public float getMinVolume() {
        return 0.0f;
    }
}

