/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.widgets.DHDButton;
import net.povstalec.sgjourney.common.menu.AbstractDHDMenu;

public class DHDBigButton
extends DHDButton {
    public ResourceLocation widgetsLocation;
    public AbstractDHDMenu menu;
    private static final int RADIUS = 27;
    private static final int DIAMETER = 54;
    private static final int RADIUS_2 = 729;

    public DHDBigButton(int x, int y, AbstractDHDMenu menu, Button.OnPress press, ResourceLocation widgets) {
        super(x, y, 54, 54, (Component)Component.empty(), press);
        this.menu = menu;
        this.widgetsLocation = widgets;
    }

    protected int getYImage(boolean isHovering) {
        if (isHovering) {
            if (this.menu.isCenterButtonEngaged()) {
                return 3;
            }
            return 1;
        }
        if (this.menu.isCenterButtonEngaged()) {
            return 2;
        }
        return 0;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.visible) {
            this.isHovered = Math.pow(mouseX - (this.getX() + 27), 2.0) + Math.pow(mouseY - (this.getY() + 27), 2.0) <= 729.0;
            Minecraft minecraft = Minecraft.getInstance();
            Font font = minecraft.font;
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.widgetsLocation);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            int yOffset = this.getYImage(this.isHoveredOrFocused());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            graphics.blit(this.widgetsLocation, this.getX(), this.getY(), 0, yOffset * 54, this.width, this.height);
            int j = this.getFGColor();
            graphics.drawCenteredString(font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        }
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.active && this.visible && Math.pow(mouseX - (double)(this.getX() + 27), 2.0) + Math.pow(mouseY - (double)(this.getY() + 27), 2.0) <= 729.0;
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return this.active && this.visible && Math.pow(mouseX - (double)(this.getX() + 27), 2.0) + Math.pow(mouseY - (double)(this.getY() + 27), 2.0) <= 729.0;
    }

    public static final class Classic
    extends DHDBigButton {
        public Classic(int x, int y, AbstractDHDMenu menu, Button.OnPress press) {
            super(x, y, menu, press, StargateJourney.sgjourneyLocation("textures/gui/dhd/classic/classic_dhd_big_red_button.png"));
        }
    }

    public static final class Pegasus
    extends DHDBigButton {
        public Pegasus(int x, int y, AbstractDHDMenu menu, Button.OnPress press) {
            super(x, y, menu, press, StargateJourney.sgjourneyLocation("textures/gui/dhd/pegasus/pegasus_dhd_big_blue_button.png"));
        }
    }

    public static final class MilkyWay
    extends DHDBigButton {
        public MilkyWay(int x, int y, AbstractDHDMenu menu, Button.OnPress press) {
            super(x, y, menu, press, StargateJourney.sgjourneyLocation("textures/gui/dhd/milky_way/milky_way_dhd_big_red_button.png"));
        }
    }
}

