/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.screens.InterfaceScreen;
import net.povstalec.sgjourney.client.widgets.SGJourneyButton;
import net.povstalec.sgjourney.common.blockstates.InterfaceMode;

public class InterfaceModeButton
extends SGJourneyButton {
    public static final ResourceLocation WIDGETS_LOCATION = StargateJourney.sgjourneyLocation("textures/gui/interface_widgets.png");
    protected InterfaceScreen screen;

    public InterfaceModeButton(int x, int y, Component component, Component tooltip, Button.OnPress press, InterfaceScreen screen) {
        super(WIDGETS_LOCATION, x, y, 16, 16, component, tooltip, press);
        this.screen = screen;
    }

    public InterfaceModeButton(int x, int y, Component component, Button.OnPress press, InterfaceScreen screen) {
        this(x, y, component, component, press, screen);
    }

    protected int getXImage(InterfaceMode mode) {
        return mode.ordinal();
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float pPartialTick) {
        this.isHovered = this.isHovered(mouseX, mouseY);
        Minecraft minecraft = Minecraft.getInstance();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        int x = this.getXImage(this.screen.getMode());
        int y = this.getYImage(this.isHoveredOrFocused());
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        graphics.blit(this.texture, this.getX(), this.getY(), this.xOffset + x * this.width, this.yOffset + y * this.height, this.width, this.height);
        graphics.blit(this.texture, this.getX() + this.width / 2, this.getY(), 200 - this.width / 2, 46 + y * 20, this.width / 2, this.height);
        int j = this.getFGColor();
        this.renderString(graphics, minecraft.font, j | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }
}

