/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class WormholeTravelCriterion
extends SimpleCriterionTrigger<WormholeTravelTriggerInstance> {
    public Codec<WormholeTravelTriggerInstance> codec() {
        return WormholeTravelTriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, ResourceLocation initialDimension, ResourceLocation destinationDimension, long distanceTraveled) {
        this.trigger(player, trigger -> trigger.matches(initialDimension, destinationDimension, distanceTraveled));
    }

    public record WormholeTravelTriggerInstance(Optional<ContextAwarePredicate> player, Optional<ResourceLocation> initialDimension, Optional<ResourceLocation> destinationDimension, Optional<Long> distanceTraveled) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<WormholeTravelTriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(WormholeTravelTriggerInstance::player), (App)ResourceLocation.CODEC.optionalFieldOf("from").forGetter(WormholeTravelTriggerInstance::initialDimension), (App)ResourceLocation.CODEC.optionalFieldOf("to").forGetter(WormholeTravelTriggerInstance::destinationDimension), (App)Codec.LONG.optionalFieldOf("distance").forGetter(WormholeTravelTriggerInstance::distanceTraveled)).apply((Applicative)instance, WormholeTravelTriggerInstance::new));

        public boolean matches(ResourceLocation initialDimension, ResourceLocation destinationDimension, long distanceTraveled) {
            if (this.initialDimension.isPresent() && !Objects.equals(this.initialDimension.get(), initialDimension)) {
                return false;
            }
            if (this.destinationDimension.isPresent() && !Objects.equals(this.destinationDimension.get(), destinationDimension)) {
                return false;
            }
            return !this.distanceTraveled.isPresent() || this.distanceTraveled.get() <= distanceTraveled;
        }
    }
}

