/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.dhd;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.ProtectedBlockEntity;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.tech.EnergyBlockEntity;
import net.povstalec.sgjourney.common.blocks.dhd.AbstractDHDBlock;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.config.CommonDHDConfig;
import net.povstalec.sgjourney.common.config.CommonPermissionConfig;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.config.StargateJourneyConfig;
import net.povstalec.sgjourney.common.items.ZeroPointModule;
import net.povstalec.sgjourney.common.items.energy_cores.IEnergyCore;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import net.povstalec.sgjourney.common.misc.LocatorHelper;
import net.povstalec.sgjourney.common.packets.ClientboundDHDUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.info.SymbolInfo;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDHDEntity
extends EnergyBlockEntity
implements StructureGenEntity,
SymbolInfo.Interface,
ProtectedBlockEntity {
    public static final String POINT_OF_ORIGIN = "point_of_origin";
    public static final String SYMBOLS = "symbols";
    public static final String ENERGY_INVENTORY = "energy_inventory";
    public static final String STARGATE_POS = "stargate_pos";
    public static final int DEFAULT_ENERGY_TARGET = 150000;
    public static final int DEFAULT_ENERGY_TRANSFER = 2500;
    public static final int DEFAULT_CONNECTION_DISTANCE = 16;
    protected StructureGenEntity.Step generationStep = StructureGenEntity.Step.GENERATED;
    protected Direction direction;
    @Nullable
    protected AbstractStargateEntity stargate;
    @Nullable
    protected Vec3i stargateRelativePos;
    protected boolean isCenterButtonEngaged = false;
    protected Address.Mutable address = new Address.Mutable();
    protected boolean enableAdvancedProtocols = false;
    protected boolean enableCallForwarding = false;
    protected long energyTarget = 150000L;
    protected int maxEnergyTransfer = 2500;
    protected final ItemStackHandler energyItemHandler = this.createEnergyItemHandler();
    protected final Lazy<IItemHandler> lazyEnergyItemHandler = Lazy.of(() -> this.energyItemHandler);
    protected SymbolInfo symbolInfo = new SymbolInfo();
    protected boolean isProtected = false;

    public AbstractDHDEntity(BlockEntityType<?> blockEntity, BlockPos pos, BlockState state) {
        super(blockEntity, pos, state);
        this.symbolInfo.setPointOfOrigin(StargateJourney.EMPTY_LOCATION);
        this.symbolInfo.setSymbols(StargateJourney.EMPTY_LOCATION);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.getLevel().isClientSide()) {
            return;
        }
        if (this.generationStep == StructureGenEntity.Step.READY) {
            this.generate();
        }
        this.setStargate();
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains(STARGATE_POS)) {
            int[] pos = tag.getIntArray(STARGATE_POS);
            this.stargateRelativePos = new Vec3i(pos[0], pos[1], pos[2]);
        } else {
            this.stargateRelativePos = null;
        }
        this.energyItemHandler.deserializeNBT(registries, tag.getCompound(ENERGY_INVENTORY));
        if (tag.contains("generation_step", 1)) {
            this.generationStep = StructureGenEntity.Step.fromByte(tag.getByte("generation_step"));
        }
        if (tag.contains("protected", 1)) {
            this.isProtected = tag.getBoolean("protected");
        }
        super.loadAdditional(tag, registries);
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.stargateRelativePos != null) {
            tag.putIntArray(STARGATE_POS, new int[]{this.stargateRelativePos.getX(), this.stargateRelativePos.getY(), this.stargateRelativePos.getZ()});
        }
        tag.put(ENERGY_INVENTORY, (Tag)this.energyItemHandler.serializeNBT(registries));
        if (this.generationStep != StructureGenEntity.Step.GENERATED) {
            tag.putByte("generation_step", this.generationStep.byteValue());
        }
        if (this.isProtected) {
            tag.putBoolean("protected", true);
        }
    }

    @Override
    public SymbolInfo symbolInfo() {
        return this.symbolInfo;
    }

    @Override
    public void invalidateCapabilities() {
        this.lazyEnergyItemHandler.invalidate();
        super.invalidateCapabilities();
    }

    protected ItemStackHandler createEnergyItemHandler() {
        return new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                AbstractDHDEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    return stack.getItem() instanceof IEnergyCore || stack.getItem() instanceof ZeroPointModule || stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
                }
                return true;
            }

            public int getSlotLimit(int slot) {
                if (slot == 0) {
                    return 1;
                }
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public int getMaxDistance() {
        return 16;
    }

    public long getEnergyTarget() {
        return this.energyTarget < 0L ? (Long)CommonStargateConfig.stargate_energy_capacity.get() : this.energyTarget;
    }

    public boolean enableAdvancedProtocols() {
        return this.enableAdvancedProtocols;
    }

    public long getStargateEnergy() {
        if (this.stargate == null) {
            return -1L;
        }
        return this.stargate.getEnergyStored();
    }

    public int getStargateOpenTime() {
        if (this.stargate == null) {
            return 0;
        }
        return this.stargate.getOpenTime();
    }

    public int getStargateTimeSinceLastTraveler() {
        if (this.stargate == null) {
            return 0;
        }
        return this.stargate.getTimeSinceLastTraveler();
    }

    protected void updateStargate() {
        if (this.stargate == null) {
            return;
        }
        this.stargate.dhdInfo().setDHD(this, this.enableAdvancedProtocols ? 10 : 0);
    }

    protected boolean setStargateFromPos(BlockPos pos) {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(pos);
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate;
            this.stargate = stargate = (AbstractStargateEntity)blockEntity;
            return true;
        }
        return false;
    }

    public void setStargate() {
        if (this.getLevel() == null) {
            return;
        }
        this.updateStargate();
        if (this.stargate != null) {
            if (this.distance(this.getBlockPos(), this.stargate.getBlockPos()) > (double)this.getMaxDistance()) {
                this.unsetStargate();
            }
            return;
        }
        if (this.stargateRelativePos == null) {
            this.stargateRelativePos = this.findNearestStargate(this.getMaxDistance());
        }
        if (this.stargateRelativePos != null) {
            BlockPos stargatePos;
            Vec3i pos = this.stargateRelativePos;
            Direction direction = this.getDirection();
            if (direction != null && (stargatePos = CoordinateHelper.Relative.getOffsetPos(direction, this.getBlockPos(), pos)) != null && !this.setStargateFromPos(stargatePos)) {
                this.stargateRelativePos = null;
            }
        }
        this.setChanged();
    }

    public void unsetStargate() {
        if (this.stargate != null) {
            this.stargate.dhdInfo().unsetDHD(false);
            this.stargate = null;
        }
        this.stargateRelativePos = null;
        this.updateDHD(new Address.Mutable(), false);
        this.setChanged();
    }

    public void updateDHD(Address.Mutable address, boolean isStargateConnected) {
        this.setAddress(address);
        this.setCenterButtonEngaged(isStargateConnected);
    }

    public void setAddress(Address.Mutable address) {
        this.address = address;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setCenterButtonEngaged(boolean isCenterButtonEngaged) {
        this.isCenterButtonEngaged = isCenterButtonEngaged;
    }

    public boolean isCenterButtonEngaged() {
        return this.isCenterButtonEngaged;
    }

    public IItemHandler getEnergyItemHandler(Direction side) {
        return (IItemHandler)this.lazyEnergyItemHandler.get();
    }

    protected abstract long buttonPressEnergyCost();

    public long minStoredEnergy() {
        return this.getEnergyCapacity() * 2L / 3L;
    }

    public abstract long maxEnergyDeplete();

    @Override
    public boolean isCorrectEnergySide(Direction side) {
        return true;
    }

    @Override
    public long maxExtract() {
        return (Long)CommonDHDConfig.milky_way_dhd_max_energy_extract.get();
    }

    private boolean stackHasEnergy(ItemStack stack) {
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage != null) {
            return energyStorage.canExtract() && energyStorage.getEnergyStored() > 0;
        }
        return false;
    }

    private void tryStoreEnergy(ItemStack energyStack) {
        IEnergyStorage energy;
        IEnergyCore energyCore;
        ItemStack inputStack = this.energyItemHandler.getStackInSlot(1);
        Item item = energyStack.getItem();
        if (item instanceof IEnergyCore && (energyCore = (IEnergyCore)item).maxGeneratedEnergy(energyStack, this.energyItemHandler.getStackInSlot(1)) <= this.getEnergyCapacity() - this.getEnergyStored()) {
            long generatedEnergy = energyCore.generateEnergy(energyStack, inputStack);
            if (generatedEnergy > 0L) {
                this.receiveEnergy(generatedEnergy, false);
            }
        } else if (energyStack.getCapability(Capabilities.EnergyStorage.ITEM) != null && (energy = (IEnergyStorage)energyStack.getCapability(Capabilities.EnergyStorage.ITEM)) != null) {
            if (energy instanceof SGJourneyEnergy) {
                SGJourneyEnergy sgjourneyEnergy = (SGJourneyEnergy)energy;
                long energyNeeded = this.getEnergyCapacity() - this.getEnergyStored();
                long energyExtracted = sgjourneyEnergy.extractLongEnergy(energyNeeded, false);
                this.receiveEnergy(energyExtracted, false);
            } else {
                int energyNeeded = (int)Math.min(this.getEnergyCapacity() - this.getEnergyStored(), Integer.MAX_VALUE);
                int energyExtracted = energy.extractEnergy(energyNeeded, false);
                this.receiveEnergy(energyExtracted, false);
            }
        }
    }

    private void tryPowerStargate(ItemStack energyStack) {
        if (this.stargate.getEnergyStored() < this.getEnergyTarget()) {
            long needed = SGJourneyEnergy.energyToTarget(this.getEnergyTarget(), this.stargate.getEnergyStored(), this.maxEnergyDeplete());
            if (this.stackHasEnergy(energyStack)) {
                IEnergyStorage energyStorage = (IEnergyStorage)energyStack.getCapability(Capabilities.EnergyStorage.ITEM);
                if (energyStorage instanceof SGJourneyEnergy) {
                    SGJourneyEnergy sgjourneyEnergy = (SGJourneyEnergy)energyStorage;
                    long energySent = sgjourneyEnergy.extractLongEnergy(needed, false);
                    this.stargate.receiveEnergy(energySent, false);
                } else {
                    int energySent = energyStorage.extractEnergy(SGJourneyEnergy.regularEnergy(needed), false);
                    this.stargate.receiveEnergy(energySent, false);
                }
            } else {
                long energySent = this.depleteEnergy(needed, false);
                this.stargate.receiveEnergy(energySent, false);
            }
        }
    }

    @Override
    protected void outputEnergy(Direction outputDirection) {
        if (this.stargate == null) {
            return;
        }
        ItemStack energyStack = this.energyItemHandler.getStackInSlot(0);
        if (this.getEnergyStored() < this.minStoredEnergy()) {
            try {
                this.tryStoreEnergy(energyStack);
            }
            catch (Exception e) {
                StargateJourney.LOGGER.error(e.getMessage());
            }
        } else {
            this.tryPowerStargate(energyStack);
        }
    }

    public void setCallForwardingState(boolean enableCallForwarding) {
        this.enableCallForwarding = enableCallForwarding;
    }

    public boolean callForwardingEnabled() {
        return this.enableCallForwarding;
    }

    protected BlockState getState() {
        BlockPos gatePos = this.getBlockPos();
        return this.level.getBlockState(gatePos);
    }

    public Direction getDirection() {
        if (this.direction == null) {
            BlockState gateState = this.getState();
            if (gateState.getBlock() instanceof AbstractDHDBlock) {
                this.direction = (Direction)gateState.getValue((Property)AbstractDHDBlock.FACING);
            } else {
                StargateJourney.LOGGER.error("Couldn't find DHD Direction");
            }
        }
        return this.direction;
    }

    private double distance(BlockPos pos, BlockPos targetPos) {
        int x = Math.abs(targetPos.getX() - pos.getX());
        int y = Math.abs(targetPos.getY() - pos.getY());
        int z = Math.abs(targetPos.getZ() - pos.getZ());
        double stargateDistance = Math.sqrt(x * x + y * y + z * z);
        return stargateDistance;
    }

    public Vec3i findNearestStargate(int maxDistance) {
        List<AbstractStargateEntity> stargates = LocatorHelper.getNearbyStargates(this.getLevel(), this.getBlockPos(), maxDistance);
        stargates.sort((stargateA, stargateB) -> Double.valueOf(this.distance(this.getBlockPos(), stargateA.getBlockPos())).compareTo(this.distance(this.getBlockPos(), stargateB.getBlockPos())));
        if (!stargates.isEmpty()) {
            for (AbstractStargateEntity stargate : stargates) {
                Direction direction;
                if (stargate.dhdInfo().hasDHD() || (direction = this.getDirection()) == null) continue;
                this.stargate = stargate;
                return CoordinateHelper.Relative.getRelativeOffset(direction, this.getBlockPos(), stargate.getBlockPos());
            }
        }
        return null;
    }

    public void sendMessageToNearbyPlayers(Component message, int distance) {
        AABB localBox = new AABB((double)(this.getBlockPos().getX() - distance), (double)(this.getBlockPos().getY() - distance), (double)(this.getBlockPos().getZ() - distance), (double)(this.getBlockPos().getX() + 1 + distance), (double)(this.getBlockPos().getY() + 1 + distance), (double)(this.getBlockPos().getZ() + 1 + distance));
        this.level.getEntitiesOfClass(Player.class, localBox).stream().forEach(player -> player.displayClientMessage(message, true));
    }

    protected abstract SoundEvent getEnterSound();

    protected abstract SoundEvent getPressSound();

    public void engageChevron(int symbol) {
        if (this.stargate != null) {
            if (!StargateJourneyConfig.disable_energy_use.get() && this.getEnergyStored() < this.buttonPressEnergyCost()) {
                this.sendMessageToNearbyPlayers((Component)Component.translatable((String)"message.sgjourney.dhd.error.not_enough_energy").withStyle(ChatFormatting.DARK_RED), 5);
                return;
            }
            if (symbol == 0) {
                this.level.playSound(null, this.getBlockPos(), this.getEnterSound(), SoundSource.BLOCKS, 0.5f, 1.0f);
            } else {
                this.level.playSound(null, this.getBlockPos(), this.getPressSound(), SoundSource.BLOCKS, 0.25f, 1.0f);
            }
            this.stargate.dhdEngageSymbol(symbol);
            this.depleteEnergy(this.buttonPressEnergyCost(), false);
        } else {
            this.sendMessageToNearbyPlayers((Component)Component.translatable((String)"message.sgjourney.dhd.error.not_connected_to_stargate").withStyle(ChatFormatting.DARK_RED), 5);
        }
    }

    public boolean isSymbolEngaged(int symbol) {
        return this.address.containsSymbol(symbol);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractDHDEntity dhd) {
        if (level.isClientSide()) {
            return;
        }
        dhd.outputEnergy(null);
        dhd.updateClient();
    }

    public void updateClient() {
        if (this.level.isClientSide()) {
            return;
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)this.level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientboundDHDUpdatePacket(this.worldPosition, this.getEnergyStored(), this.symbolInfo().pointOfOrigin(), this.symbolInfo().symbols(), this.address.getArray(), this.isCenterButtonEngaged), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void generateInStructure(WorldGenLevel level, RandomSource randomSource) {
        if (this.generationStep == StructureGenEntity.Step.SETUP) {
            this.generationStep = StructureGenEntity.Step.READY;
        }
    }

    public void generate() {
        this.generateEnergyCore();
        this.generationStep = StructureGenEntity.Step.GENERATED;
    }

    public void setToGenerate() {
        this.generationStep = StructureGenEntity.Step.SETUP;
    }

    protected abstract void generateEnergyCore();

    @Override
    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public boolean hasPermissions(Player player, boolean sendMessage) {
        if (this.isProtected() && !player.hasPermissions(CommonPermissionConfig.protected_dhd_permissions.get())) {
            if (sendMessage) {
                player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.protected_permissions").withStyle(ChatFormatting.DARK_RED), true);
            }
            return false;
        }
        return true;
    }
}

