/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.stargate;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.RotatingStargateEntity;
import net.povstalec.sgjourney.common.compatibility.cctweaked.CCTweakedCompatibility;
import net.povstalec.sgjourney.common.compatibility.cctweaked.StargatePeripheralWrapper;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.Symbols;
import net.povstalec.sgjourney.common.sgjourney.stargate.ClassicStargate;

public class ClassicStargateEntity
extends RotatingStargateEntity {
    public static final String ROTATION = "rotation";
    public static final float CLASSIC_THICKNESS = 8.0f;
    public static final float HORIZONTAL_CENTER_CLASSIC_HEIGHT = 0.25f;
    public static final int TOTAL_SYMBOLS = 39;
    public static final int MAX_ROTATION = 156;
    private static final short ROTATION_TICK_DURATION = 40;
    private static final short CHEVRON_LOCK_TICK_DURATION = 20;
    public int[] addressBuffer = new int[0];
    public int symbolBuffer = 0;

    public ClassicStargateEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.CLASSIC_STARGATE.get(), StargateJourney.sgjourneyLocation("classic/classic"), pos, state, 39, StargateInfo.Gen.NONE, 0, 0.5f, 0.25f, 156);
    }

    @Override
    public CompoundTag serializeStargateInfo(CompoundTag tag, HolderLookup.Provider registries) {
        super.serializeStargateInfo(tag, registries);
        tag.putString("point_of_origin", this.symbolInfo().pointOfOrigin().toString());
        tag.putString("symbols", this.symbolInfo().symbols().toString());
        return tag;
    }

    @Override
    public void deserializeStargateInfo(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgraded) {
        if (tag.contains("point_of_origin")) {
            this.symbolInfo().setPointOfOrigin(ResourceLocation.tryParse((String)tag.getString("point_of_origin")));
        }
        if (tag.contains("symbols")) {
            this.symbolInfo().setSymbols(ResourceLocation.tryParse((String)tag.getString("symbols")));
        }
        super.deserializeStargateInfo(tag, registries, isUpgraded);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ClassicStargateEntity stargate) {
        RotatingStargateEntity.tick(level, pos, state, stargate);
    }

    @Override
    public StargateInfo.ChevronLockSpeed getChevronLockSpeed(boolean doKawoosh) {
        return doKawoosh ? ClassicStargate.CHEVRON_LOCK_SPEED : StargateInfo.ChevronLockSpeed.FAST;
    }

    @Override
    public void registerInterfaceMethods(StargatePeripheralWrapper wrapper) {
        CCTweakedCompatibility.registerClassicStargateMethods(wrapper);
    }

    @Override
    public void generate() {
        super.generate();
        Random random = new Random();
        this.setRotation(2 * random.nextInt(0, 79));
    }

    @Override
    public void generateAdditional(StructureGenEntity.Step generationStep) {
        if (generationStep == StructureGenEntity.Step.SETUP) {
            if (!PointOfOrigin.validLocation(this.level.getServer(), this.symbolInfo().pointOfOrigin())) {
                this.symbolInfo().setPointOfOrigin(StargateJourney.EMPTY_LOCATION);
            }
            if (!Symbols.validLocation(this.level.getServer(), this.symbolInfo().symbols())) {
                this.symbolInfo().setSymbols(StargateJourney.EMPTY_LOCATION);
            }
        } else {
            if (!PointOfOrigin.validLocation(this.level.getServer(), this.symbolInfo().pointOfOrigin())) {
                if (this.localPointOfOrigin) {
                    this.symbolInfo().setPointOfOrigin(PointOfOrigin.fromDimension(this.level.getServer(), (ResourceKey<Level>)this.level.dimension()));
                } else {
                    this.symbolInfo().setPointOfOrigin(PointOfOrigin.randomPointOfOrigin(this.level.getServer(), (ResourceKey<Level>)this.level.dimension()));
                }
            }
            if (!Symbols.validLocation(this.level.getServer(), this.symbolInfo().symbols())) {
                this.symbolInfo().setSymbols(Symbols.fromDimension(this.level.getServer(), (ResourceKey<Level>)this.level.dimension()));
            }
        }
    }
}

