/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.packets.ClientboundNaquadahLiquidizerUpdatePacket;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractNaquadahLiquidizerEntity
extends BlockEntity {
    private static final String PROGRESS = "progress";
    private static final String INPUT_INVENTORY = "input_inventory";
    private static final String FLUID_INPUT_INVENTORY = "fluid_input_inventory";
    private static final String FLUID_OUTPUT_INVENTORY = "fluid_output_inventory";
    public static final String FLUID_TANK_1 = "fluid_tank_1";
    public static final String FLUID_TANK_2 = "fluid_tank_2";
    public static final int TANK_CAPACITY = 4000;
    public static final int MAX_PROGRESS = 100;
    protected final ItemStackHandler itemInputHandler = this.createItemInputHandler();
    protected final Lazy<IItemHandler> lazyInputHandler = Lazy.of(() -> this.itemInputHandler);
    protected final ItemStackHandler fluidItemInputHandler = this.createFluidItemHandler();
    protected final Lazy<IItemHandler> lazyFluidInputHandler = Lazy.of(() -> this.fluidItemInputHandler);
    protected final ItemStackHandler fluidItemOutputHandler = this.createFluidItemHandler();
    protected final Lazy<IItemHandler> lazyFluidOutputHandler = Lazy.of(() -> this.fluidItemOutputHandler);
    protected final FluidTank fluidTank1 = this.createFluidTank1();
    protected Lazy<IFluidHandler> lazyFluidHandler1 = Lazy.of(() -> this.fluidTank1);
    protected final FluidTank fluidTank2 = this.createFluidTank2();
    protected Lazy<IFluidHandler> lazyFluidHandler2 = Lazy.of(() -> this.fluidTank2);
    public int progress = 0;

    public AbstractNaquadahLiquidizerEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.lazyFluidHandler1.invalidate();
        this.lazyFluidHandler2.invalidate();
        this.lazyInputHandler.invalidate();
        this.lazyFluidInputHandler.invalidate();
        this.lazyFluidOutputHandler.invalidate();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemInputHandler.deserializeNBT(registries, tag.getCompound(INPUT_INVENTORY));
        this.fluidItemInputHandler.deserializeNBT(registries, tag.getCompound(FLUID_INPUT_INVENTORY));
        this.fluidItemOutputHandler.deserializeNBT(registries, tag.getCompound(FLUID_OUTPUT_INVENTORY));
        this.fluidTank1.readFromNBT(registries, tag.getCompound(FLUID_TANK_1));
        this.fluidTank2.readFromNBT(registries, tag.getCompound(FLUID_TANK_2));
        this.progress = tag.getInt(PROGRESS);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag tag1 = new CompoundTag();
        CompoundTag tag2 = new CompoundTag();
        tag.put(INPUT_INVENTORY, (Tag)this.itemInputHandler.serializeNBT(registries));
        tag.put(FLUID_INPUT_INVENTORY, (Tag)this.fluidItemInputHandler.serializeNBT(registries));
        tag.put(FLUID_OUTPUT_INVENTORY, (Tag)this.fluidItemOutputHandler.serializeNBT(registries));
        this.fluidTank1.writeToNBT(registries, tag1);
        tag.put(FLUID_TANK_1, (Tag)tag1);
        this.fluidTank2.writeToNBT(registries, tag2);
        tag.put(FLUID_TANK_2, (Tag)tag2);
        tag.putInt(PROGRESS, this.progress);
        super.saveAdditional(tag, registries);
    }

    private FluidTank createFluidTank1() {
        return new FluidTank(4000){

            protected void onContentsChanged() {
                AbstractNaquadahLiquidizerEntity.this.setChanged();
            }

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid() == AbstractNaquadahLiquidizerEntity.this.getDesiredFluid1();
            }
        };
    }

    private FluidTank createFluidTank2() {
        return new FluidTank(4000){

            protected void onContentsChanged() {
                AbstractNaquadahLiquidizerEntity.this.setChanged();
            }

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid() == AbstractNaquadahLiquidizerEntity.this.getDesiredFluid2();
            }
        };
    }

    public IFluidHandler getFluidHandler(Direction side) {
        if (side == Direction.DOWN) {
            return (IFluidHandler)this.lazyFluidHandler2.get();
        }
        return (IFluidHandler)this.lazyFluidHandler1.get();
    }

    public IItemHandler getItemHandler(Direction side) {
        if (side == Direction.UP) {
            return (IItemHandler)this.lazyInputHandler.get();
        }
        if (side == Direction.DOWN) {
            return (IItemHandler)this.lazyFluidOutputHandler.get();
        }
        return (IItemHandler)this.lazyFluidInputHandler.get();
    }

    public abstract Fluid getDesiredFluid1();

    public abstract Fluid getDesiredFluid2();

    public void setFluid1(FluidStack fluidStack) {
        this.fluidTank1.setFluid(fluidStack);
    }

    public FluidStack getFluid1() {
        return this.fluidTank1.getFluid();
    }

    public void setFluid2(FluidStack fluidStack) {
        this.fluidTank2.setFluid(fluidStack);
    }

    public FluidStack getFluid2() {
        return this.fluidTank2.getFluid();
    }

    private ItemStackHandler createItemInputHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                AbstractNaquadahLiquidizerEntity.this.setChanged();
            }

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
    }

    private ItemStackHandler createFluidItemHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                AbstractNaquadahLiquidizerEntity.this.setChanged();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.getCapability(Capabilities.FluidHandler.ITEM) != null;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public boolean hasFluidItem1() {
        return this.fluidItemInputHandler.getStackInSlot(0).getCount() > 0;
    }

    public boolean hasFluidItem2() {
        return this.fluidItemOutputHandler.getStackInSlot(0).getCount() > 0;
    }

    public void fillTank1(FluidStack stack, ItemStack container) {
        this.fluidTank1.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        this.fluidItemInputHandler.extractItem(0, 1, false);
        this.fluidItemInputHandler.insertItem(0, container, false);
    }

    public void fillTank2(FluidStack stack, ItemStack container) {
        this.fluidTank1.fill(stack, IFluidHandler.FluidAction.EXECUTE);
    }

    public void drainFluidFromItem() {
        IFluidHandlerItem cap = (IFluidHandlerItem)this.fluidItemInputHandler.getStackInSlot(0).getCapability(Capabilities.FluidHandler.ITEM);
        if (cap != null) {
            int drainAmount = Math.min(this.fluidTank1.getSpace(), 1000);
            FluidStack fluidStack = cap.getFluidInTank(0);
            if (this.fluidTank1.isFluidValid(fluidStack)) {
                fluidStack = cap.drain(drainAmount, IFluidHandler.FluidAction.EXECUTE);
                this.fillTank1(fluidStack, cap.getContainer());
            }
        }
    }

    public void putFluidInsideItem() {
        ItemStack stack = this.fluidItemOutputHandler.getStackInSlot(0);
        IFluidHandlerItem cap = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM);
        if (cap != null) {
            if (!cap.isFluidValid(0, this.getFluid2())) {
                return;
            }
            int fillAmount = cap.fill(this.getFluid2(), IFluidHandler.FluidAction.EXECUTE);
            this.fluidItemOutputHandler.setStackInSlot(0, cap.getContainer());
            this.fluidTank2.drain(fillAmount, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    protected abstract boolean hasMaterial();

    protected abstract void makeLiquidNaquadah();

    protected void useUpItems(int amount) {
        this.itemInputHandler.extractItem(0, amount, false);
    }

    public void outputLiquid() {
        BlockEntity blockEntity = this.level.getBlockEntity(this.worldPosition.relative(Direction.DOWN));
        if (blockEntity == null) {
            return;
        }
        IFluidHandler fluidHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.worldPosition.relative(Direction.DOWN), (Object)Direction.UP);
        if (fluidHandler != null) {
            FluidStack simulatedOutputAmount = this.fluidTank2.drain(100, IFluidHandler.FluidAction.SIMULATE);
            int simulatedReceiveAmount = fluidHandler.fill(simulatedOutputAmount, IFluidHandler.FluidAction.SIMULATE);
            fluidHandler.fill(this.fluidTank2.drain(simulatedReceiveAmount, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AbstractNaquadahLiquidizerEntity naquadahLiquidizer) {
        if (level.isClientSide()) {
            return;
        }
        if (naquadahLiquidizer.hasFluidItem1()) {
            naquadahLiquidizer.drainFluidFromItem();
        }
        if (naquadahLiquidizer.hasMaterial() && naquadahLiquidizer.fluidTank1.getFluidAmount() > 0 && naquadahLiquidizer.fluidTank2.getFluidAmount() + 100 <= naquadahLiquidizer.fluidTank2.getCapacity()) {
            ++naquadahLiquidizer.progress;
            naquadahLiquidizer.fluidTank1.drain(1, IFluidHandler.FluidAction.EXECUTE);
            AbstractNaquadahLiquidizerEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            if (naquadahLiquidizer.progress >= 100) {
                naquadahLiquidizer.makeLiquidNaquadah();
            }
        } else {
            naquadahLiquidizer.progress = 0;
            AbstractNaquadahLiquidizerEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
        if (naquadahLiquidizer.hasFluidItem2()) {
            naquadahLiquidizer.putFluidInsideItem();
        }
        naquadahLiquidizer.outputLiquid();
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)level.getChunkAt(naquadahLiquidizer.worldPosition).getPos(), (CustomPacketPayload)new ClientboundNaquadahLiquidizerUpdatePacket(naquadahLiquidizer.worldPosition, naquadahLiquidizer.getFluid1(), naquadahLiquidizer.getFluid2(), naquadahLiquidizer.progress), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

