/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.tech.EnergyBlockEntity;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.packets.ClientboundBatteryBlockUpdatePacket;
import org.jetbrains.annotations.NotNull;

public abstract class BatteryBlockEntity
extends EnergyBlockEntity {
    public static final String INVENTORY = "inventory";
    private final ItemStackHandler itemHandler = this.createHandler();
    private final Lazy<IItemHandler> lazyItemHandler = Lazy.of(() -> this.itemHandler);

    public BatteryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void invalidateCapabilities() {
        super.invalidateCapabilities();
        this.lazyItemHandler.invalidate();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.itemHandler.deserializeNBT(registries, nbt.getCompound(INVENTORY));
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.put(INVENTORY, (Tag)this.itemHandler.serializeNBT(registries));
    }

    public IItemHandler getItemHandler() {
        return (IItemHandler)this.lazyItemHandler.get();
    }

    public IItemHandler getItemHandler(Direction side) {
        return (IItemHandler)this.lazyItemHandler.get();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(2){

            protected void onContentsChanged(int slot) {
                BatteryBlockEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BatteryBlockEntity battery) {
        if (level.isClientSide()) {
            return;
        }
        battery.extractItemEnergy(battery.itemHandler.getStackInSlot(0));
        battery.fillItemEnergy(battery.itemHandler.getStackInSlot(1));
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)level), (ChunkPos)level.getChunkAt(battery.getBlockPos()).getPos(), (CustomPacketPayload)new ClientboundBatteryBlockUpdatePacket(battery.getBlockPos(), battery.getEnergyStored()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static class Naquadah
    extends BatteryBlockEntity {
        public Naquadah(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.LARGE_NAQUADAH_BATTERY.get(), pos, state);
        }

        @Override
        protected long capacity() {
            return (Long)CommonTechConfig.large_naquadah_battery_capacity.get();
        }

        @Override
        protected long maxReceive() {
            return (Long)CommonTechConfig.large_naquadah_battery_max_transfer.get();
        }

        @Override
        protected long maxExtract() {
            return (Long)CommonTechConfig.large_naquadah_battery_max_transfer.get();
        }
    }
}

