/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.povstalec.sgjourney.common.blocks.tech.CableBlock;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.config.CommonCableConfig;
import net.povstalec.sgjourney.common.config.CommonZPMConfig;
import net.povstalec.sgjourney.common.data.ConduitNetworks;
import net.povstalec.sgjourney.common.init.BlockEntityInit;

public abstract class CableBlockEntity
extends BlockEntity {
    public static final String NETWORK_ID = "network_id";
    protected SGJourneyEnergy ENERGY_STORAGE = this.createEnergyStorage();
    private Lazy<IEnergyStorage> lazyEnergyHandler = Lazy.of(() -> this.ENERGY_STORAGE);
    private int networkID = 0;
    private ConduitNetworks.ConduitNetwork cableNetwork = null;
    private List<Direction> connectedSides = null;

    public CableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void invalidateCapabilities() {
        this.lazyEnergyHandler.invalidate();
        super.invalidateCapabilities();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.networkID = tag.getInt(NETWORK_ID);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt(NETWORK_ID, this.networkID);
    }

    public abstract long maxTransfer();

    @Nonnull
    protected SGJourneyEnergy createEnergyStorage() {
        return new SGJourneyEnergy(this.maxTransfer(), this.maxTransfer(), this.maxTransfer()){

            @Override
            public long receiveLongEnergy(long maxReceive, boolean simulate) {
                return CableBlockEntity.this.transferEnergy(Math.min(CableBlockEntity.this.maxTransfer(), maxReceive), simulate, false);
            }

            @Override
            public long receiveZeroPointEnergy(long maxReceive, boolean simulate) {
                return CableBlockEntity.this.transferEnergy(Math.min(CableBlockEntity.this.maxTransfer(), maxReceive), simulate, true);
            }

            @Override
            public int extractEnergy(int maxExtract, boolean simulate) {
                return 0;
            }

            @Override
            public boolean canExtract() {
                return false;
            }

            @Override
            public boolean canReceive() {
                return true;
            }

            @Override
            public void onEnergyChanged(long difference, boolean simulate) {
                CableBlockEntity.this.setChanged();
            }
        };
    }

    public void setNetworkID(int networkID) {
        this.networkID = networkID;
        this.cableNetwork = null;
    }

    public int networkID() {
        return this.networkID;
    }

    @Nullable
    private ConduitNetworks.ConduitNetwork getNetwork() {
        if (this.cableNetwork != null) {
            return this.cableNetwork;
        }
        if (this.networkID == 0) {
            return null;
        }
        this.cableNetwork = ConduitNetworks.get(this.getLevel()).getCableNetwork(this.networkID);
        return this.cableNetwork;
    }

    public void update() {
        this.connectedSides = null;
    }

    public boolean isOutput() {
        for (Direction direction : this.getConnectedSides()) {
            IEnergyStorage energy;
            BlockPos outputPos = this.getBlockPos().relative(direction);
            BlockEntity blockEntity = this.level.getBlockEntity(outputPos);
            if (blockEntity == null || blockEntity instanceof CableBlockEntity || (energy = (IEnergyStorage)this.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, outputPos, (Object)direction.getOpposite())) == null || !energy.canReceive()) continue;
            return true;
        }
        return false;
    }

    public List<Direction> getConnectedSides() {
        if (this.connectedSides == null) {
            this.connectedSides = new ArrayList<Direction>();
            for (Direction direction : Direction.values()) {
                if (CableBlock.connectionTypeSide((BlockGetter)this.getLevel(), this.getBlockPos(), direction) != CableBlock.ConnectorType.BLOCK) continue;
                this.connectedSides.add(direction);
            }
        }
        return this.connectedSides;
    }

    public int validOutputs() {
        int outputs = 0;
        for (Direction direction : this.getConnectedSides()) {
            SGJourneyEnergy sgjourneyEnergy;
            IEnergyStorage energy;
            BlockPos outputPos = this.getBlockPos().relative(direction);
            BlockEntity blockEntity = this.level.getBlockEntity(outputPos);
            if (blockEntity == null || !(energy = (IEnergyStorage)this.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, outputPos, (Object)direction.getOpposite())).canReceive()) continue;
            if (energy instanceof SGJourneyEnergy && (sgjourneyEnergy = (SGJourneyEnergy)energy).getTrueEnergyStored() < sgjourneyEnergy.getTrueMaxEnergyStored()) {
                ++outputs;
                continue;
            }
            if (energy.getEnergyStored() >= energy.getMaxEnergyStored()) continue;
            ++outputs;
        }
        return outputs;
    }

    public long outputEnergy(Direction direction, long toOutput, boolean simulate, boolean zeroPointEnergy) {
        BlockPos outputPos = this.getBlockPos().relative(direction);
        BlockEntity blockEntity = this.level.getBlockEntity(outputPos);
        if (blockEntity == null) {
            return 0L;
        }
        IEnergyStorage energy = (IEnergyStorage)this.getLevel().getCapability(Capabilities.EnergyStorage.BLOCK, outputPos, (Object)direction.getOpposite());
        if (energy == null || !energy.canReceive()) {
            return 0L;
        }
        if (energy instanceof SGJourneyEnergy) {
            SGJourneyEnergy sgjourneyEnergy = (SGJourneyEnergy)energy;
            return zeroPointEnergy ? sgjourneyEnergy.receiveZeroPointEnergy(toOutput, simulate) : sgjourneyEnergy.receiveLongEnergy(toOutput, simulate);
        }
        if (zeroPointEnergy && !((Boolean)CommonZPMConfig.other_mods_use_zero_point_energy.get()).booleanValue()) {
            return 0L;
        }
        return energy.receiveEnergy(SGJourneyEnergy.regularEnergy(toOutput), simulate);
    }

    public long transferEnergy(long toTransfer, boolean simulate, boolean zeroPointEnergy) {
        if (zeroPointEnergy && !this.canTransferZeroPointEnergy()) {
            return 0L;
        }
        ConduitNetworks.ConduitNetwork cableNetwork = this.getNetwork();
        if (cableNetwork == null) {
            return 0L;
        }
        return cableNetwork.transferEnergy(this.getLevel(), toTransfer, simulate, zeroPointEnergy);
    }

    public abstract boolean canTransferZeroPointEnergy();

    public IEnergyStorage getEnergyHandler(Direction direction) {
        return this.ENERGY_STORAGE;
    }

    public static class LargeNaquadahCable
    extends CableBlockEntity {
        public LargeNaquadahCable(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.LARGE_NAQUADAH_CABLE.get(), pos, state);
        }

        @Override
        public long maxTransfer() {
            return (Long)CommonCableConfig.large_naquadah_cable_max_transfer.get();
        }

        @Override
        public boolean canTransferZeroPointEnergy() {
            return (Boolean)CommonCableConfig.large_naquadah_cable_transfers_zero_point_energy.get();
        }
    }

    public static class MediumNaquadahCable
    extends CableBlockEntity {
        public MediumNaquadahCable(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.MEDIUM_NAQUADAH_CABLE.get(), pos, state);
        }

        @Override
        public long maxTransfer() {
            return (Long)CommonCableConfig.medium_naquadah_cable_max_transfer.get();
        }

        @Override
        public boolean canTransferZeroPointEnergy() {
            return (Boolean)CommonCableConfig.medium_naquadah_cable_transfers_zero_point_energy.get();
        }
    }

    public static class SmallNaquadahCable
    extends CableBlockEntity {
        public SmallNaquadahCable(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.SMALL_NAQUADAH_CABLE.get(), pos, state);
        }

        @Override
        public long maxTransfer() {
            return (Long)CommonCableConfig.small_naquadah_cable_max_transfer.get();
        }

        @Override
        public boolean canTransferZeroPointEnergy() {
            return (Boolean)CommonCableConfig.small_naquadah_cable_transfers_zero_point_energy.get();
        }
    }

    public static class NaquadahWire
    extends CableBlockEntity {
        public NaquadahWire(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityInit.NAQUADAH_WIRE.get(), pos, state);
        }

        @Override
        public long maxTransfer() {
            return (Long)CommonCableConfig.naquadah_wire_max_transfer.get();
        }

        @Override
        public boolean canTransferZeroPointEnergy() {
            return (Boolean)CommonCableConfig.naquadah_wire_transfers_zero_point_energy.get();
        }
    }
}

