/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.tech;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.config.CommonZPMConfig;
import org.jetbrains.annotations.NotNull;

public abstract class EnergyBlockEntity
extends BlockEntity {
    public static final String ENERGY = "energy";
    private boolean canGenerateEnergy;
    protected SGJourneyEnergy ENERGY_STORAGE = this.createEnergyStorage();
    private Lazy<IEnergyStorage> lazyEnergyHandler = Lazy.of(() -> this.ENERGY_STORAGE);

    public EnergyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, boolean canGenerateEnergy) {
        super(type, pos, state);
        this.canGenerateEnergy = canGenerateEnergy;
    }

    public EnergyBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, false);
    }

    public void onLoad() {
        this.lazyEnergyHandler = Lazy.of(() -> this.ENERGY_STORAGE);
        super.onLoad();
    }

    public void invalidateCapabilities() {
        this.lazyEnergyHandler.invalidate();
        super.invalidateCapabilities();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.ENERGY_STORAGE.setEnergy(tag.getLong(ENERGY));
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putLong(ENERGY, this.ENERGY_STORAGE.getTrueEnergyStored());
    }

    public SGJourneyEnergy getEnergyStorage() {
        return this.ENERGY_STORAGE;
    }

    @Nullable
    public IEnergyStorage getEnergyHandler(Direction side) {
        if (this.isCorrectEnergySide(side)) {
            return (IEnergyStorage)this.lazyEnergyHandler.get();
        }
        return null;
    }

    @Nonnull
    protected SGJourneyEnergy createEnergyStorage() {
        return new SGJourneyEnergy(this.capacity(), this.maxReceive(), this.maxExtract()){

            @Override
            public long receiveZeroPointEnergy(long maxReceive, boolean simulate) {
                return EnergyBlockEntity.this.canReceiveZeroPointEnergy() ? this.receiveLongEnergy(maxReceive, simulate) : 0L;
            }

            @Override
            public boolean canExtract() {
                return EnergyBlockEntity.this.outputsEnergy();
            }

            @Override
            public boolean canReceive() {
                return EnergyBlockEntity.this.receivesEnergy();
            }

            @Override
            public void onEnergyChanged(long difference, boolean simulate) {
                EnergyBlockEntity.this.changeEnergy(difference, simulate);
            }
        };
    }

    protected boolean isCorrectEnergySide(Direction side) {
        return true;
    }

    protected boolean canReceiveZeroPointEnergy() {
        return (Boolean)CommonZPMConfig.tech_uses_zero_point_energy.get();
    }

    protected boolean outputsEnergy() {
        return this.getMaxExtract() > 0L;
    }

    protected boolean receivesEnergy() {
        return this.getMaxReceive() > 0L;
    }

    protected abstract long capacity();

    protected abstract long maxReceive();

    protected abstract long maxExtract();

    protected void changeEnergy(long difference, boolean simulate) {
        this.setChanged();
    }

    public long depleteEnergy(long amount, boolean simulate) {
        long storedEnergy = this.getEnergyStored();
        long maxEnergyDepletion = Math.min(amount, this.maxExtract());
        long energyDepleted = Math.min(storedEnergy, maxEnergyDepletion);
        if (!simulate) {
            this.setEnergy(storedEnergy - energyDepleted);
        }
        if (energyDepleted != 0L) {
            this.ENERGY_STORAGE.onEnergyChanged(energyDepleted, simulate);
        }
        return energyDepleted;
    }

    public long getEnergyStored() {
        return this.ENERGY_STORAGE.getTrueEnergyStored();
    }

    public long extractEnergy(long maxExtract, boolean simulate) {
        return this.ENERGY_STORAGE.extractLongEnergy(maxExtract, simulate);
    }

    public long receiveEnergy(long maxReceive, boolean simulate) {
        return this.ENERGY_STORAGE.receiveLongEnergy(maxReceive, simulate);
    }

    public long setEnergy(long energy) {
        return this.ENERGY_STORAGE.setEnergy(energy);
    }

    public boolean canExtract() {
        return this.ENERGY_STORAGE.canExtract();
    }

    public boolean canExtractEnergy(long energy) {
        if (this.ENERGY_STORAGE.getTrueMaxEnergyStored() < energy) {
            return false;
        }
        if (this.ENERGY_STORAGE.maxExtract() < energy) {
            return false;
        }
        return this.ENERGY_STORAGE.getTrueEnergyStored() >= energy;
    }

    public boolean canReceive() {
        return this.ENERGY_STORAGE.canReceive();
    }

    public long getEnergyCapacity() {
        return this.ENERGY_STORAGE.getTrueMaxEnergyStored();
    }

    public long getMaxExtract() {
        return this.ENERGY_STORAGE.maxExtract();
    }

    public long getMaxReceive() {
        return this.ENERGY_STORAGE.maxReceive();
    }

    protected void generateEnergy(long energyGenerated) {
        if (!this.canGenerateEnergy) {
            return;
        }
        long moreEnergy = this.getEnergyStored() + energyGenerated;
        if (this.capacity() >= moreEnergy) {
            this.ENERGY_STORAGE.setEnergy(moreEnergy);
        }
    }

    public boolean canReceive(long receivedEnergy) {
        return this.ENERGY_STORAGE.canReceive(receivedEnergy);
    }

    protected void drainEnergyStorage(IEnergyStorage energyStorage) {
        if (!energyStorage.canExtract()) {
            return;
        }
        if (energyStorage instanceof SGJourneyEnergy) {
            SGJourneyEnergy sgjourneyEnergy = (SGJourneyEnergy)energyStorage;
            long simulatedOutputAmount = sgjourneyEnergy.extractLongEnergy(this.ENERGY_STORAGE.maxExtract(), true);
            long simulatedReceiveAmount = this.ENERGY_STORAGE.receiveLongEnergy(simulatedOutputAmount, true);
            sgjourneyEnergy.extractLongEnergy(simulatedReceiveAmount, false);
            this.ENERGY_STORAGE.receiveLongEnergy(simulatedReceiveAmount, false);
        } else {
            int simulatedOutputAmount = energyStorage.extractEnergy(SGJourneyEnergy.regularEnergy(this.ENERGY_STORAGE.maxExtract()), true);
            int simulatedReceiveAmount = this.ENERGY_STORAGE.receiveEnergy(simulatedOutputAmount, true);
            energyStorage.extractEnergy(simulatedReceiveAmount, false);
            this.ENERGY_STORAGE.receiveEnergy(simulatedReceiveAmount, false);
        }
    }

    protected void fillEnergyStorage(IEnergyStorage energyStorage) {
        if (!energyStorage.canReceive()) {
            return;
        }
        if (energyStorage instanceof SGJourneyEnergy) {
            SGJourneyEnergy sgjourneyEnergy = (SGJourneyEnergy)energyStorage;
            long simulatedOutputAmount = this.ENERGY_STORAGE.extractLongEnergy(this.ENERGY_STORAGE.maxExtract(), true);
            long simulatedReceiveAmount = sgjourneyEnergy.receiveLongEnergy(simulatedOutputAmount, true);
            this.ENERGY_STORAGE.extractLongEnergy(simulatedReceiveAmount, false);
            sgjourneyEnergy.receiveLongEnergy(simulatedReceiveAmount, false);
        } else {
            int simulatedOutputAmount = this.ENERGY_STORAGE.extractEnergy(SGJourneyEnergy.regularEnergy(this.ENERGY_STORAGE.maxExtract()), true);
            int simulatedReceiveAmount = energyStorage.receiveEnergy(simulatedOutputAmount, true);
            this.ENERGY_STORAGE.extractEnergy(simulatedReceiveAmount, false);
            energyStorage.receiveEnergy(simulatedReceiveAmount, false);
        }
    }

    protected void outputEnergy(Direction outputDirection) {
        if (outputDirection == null) {
            return;
        }
        if (this.ENERGY_STORAGE.canExtract()) {
            BlockEntity blockentity = this.level.getBlockEntity(this.worldPosition.relative(outputDirection));
            if (blockentity == null) {
                return;
            }
            IEnergyStorage energyStorage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, this.getBlockPos().relative(outputDirection), null);
            if (energyStorage != null) {
                this.fillEnergyStorage(energyStorage);
            }
        }
    }

    public void extractItemEnergy(ItemStack stack) {
        IEnergyStorage itemEnergy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (itemEnergy != null) {
            this.drainEnergyStorage(itemEnergy);
        }
    }

    public void fillItemEnergy(ItemStack stack) {
        IEnergyStorage itemEnergy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (itemEnergy != null) {
            this.fillEnergyStorage(itemEnergy);
        }
    }

    public void getStatus(Player player) {
        if (this.level.isClientSide()) {
            return;
        }
        player.sendSystemMessage((Component)Component.translatable((String)"info.sgjourney.energy").append((Component)Component.literal((String)(": " + this.getEnergyStored() + " FE"))).withStyle(ChatFormatting.DARK_RED));
    }
}

