/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities.transporter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.povstalec.sgjourney.common.block_entities.transporter.TransportRingsEntity;
import net.povstalec.sgjourney.common.block_entities.transporter.TransporterControllerEntity;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.crystals.MemoryCrystalItem;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import net.povstalec.sgjourney.common.misc.LocatorHelper;
import net.povstalec.sgjourney.common.packets.ClientboundRingPanelUpdatePacket;
import net.povstalec.sgjourney.common.sgjourney.Transporting;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;
import org.jetbrains.annotations.NotNull;

public class RingPanelEntity
extends TransporterControllerEntity {
    public static final String INVENTORY = "inventory";
    private BlockPos targetPos;
    public ArrayList<BlockPos> ringsPos = new ArrayList();
    public ArrayList<Component> ringsName = new ArrayList();
    private final ItemStackHandler itemStackHandler = this.createHandler();
    private final Lazy<IItemHandler> lazyItemHandler = Lazy.of(() -> this.itemStackHandler);
    private TransportRingsEntity transportRings;

    public RingPanelEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityInit.RING_PANEL.get(), pos, state);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.itemStackHandler.deserializeNBT(registries, nbt.getCompound(INVENTORY));
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.put(INVENTORY, (Tag)this.itemStackHandler.serializeNBT(registries));
        super.saveAdditional(nbt, registries);
    }

    private void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemStackHandler.getSlots());
        for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemStackHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void setRemoved() {
        super.setRemoved();
        this.lazyItemHandler.invalidate();
    }

    public IItemHandler getItemHandler() {
        return (IItemHandler)this.lazyItemHandler.get();
    }

    public IItemHandler getItemHandler(Direction side) {
        return (IItemHandler)this.lazyItemHandler.get();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                RingPanelEntity.this.setChanged();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.getItem() == ItemInit.MEMORY_CRYSTAL.get();
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void getNearest6Rings(ServerLevel level, BlockPos pos, double maxDistance) {
        if (this.transportRings == null) {
            return;
        }
        List<Transporter> transporters = LocatorHelper.findNearestTransporters(level, pos);
        this.ringsPos.clear();
        this.ringsName.clear();
        int ringsFound = transporters.size();
        int j = 0;
        if (ringsFound > 0 && transporters.get(0).getBlockPos().equals((Object)this.transportRings.getBlockPos())) {
            ++j;
        }
        for (int i = 0; i < 6 && j < ringsFound; ++i, ++j) {
            Transporter transporter = transporters.get(j);
            this.ringsPos.add(transporter.getBlockPos());
            this.ringsName.add(transporter.getName());
        }
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)level, (ChunkPos)level.getChunkAt(this.worldPosition).getPos(), (CustomPacketPayload)new ClientboundRingPanelUpdatePacket(this.worldPosition, this.ringsPos, this.ringsName), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public TransportRingsEntity findNearestTransportRings(int maxDistance) {
        Iterator<TransportRingsEntity> iterator;
        List<TransportRingsEntity> transportRingsList = this.getNearbyTransportRings(maxDistance);
        transportRingsList.sort((transportRingsA, transportRingsB) -> Long.compare(CoordinateHelper.Relative.distanceSqr((Vec3i)this.getBlockPos(), (Vec3i)transportRingsA.getBlockPos()), CoordinateHelper.Relative.distanceSqr((Vec3i)this.getBlockPos(), (Vec3i)transportRingsB.getBlockPos())));
        if (!transportRingsList.isEmpty() && (iterator = transportRingsList.iterator()).hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public void setTransportRings() {
        if (this.getLevel() == null) {
            return;
        }
        this.transportRings = this.findNearestTransportRings(16);
    }

    public void activateRings(int chosenNumber) {
        if (this.transportRings == null || !this.transportRings.canTransport()) {
            return;
        }
        ItemStack stack = this.itemStackHandler.getStackInSlot(chosenNumber);
        if (stack.getItem() instanceof MemoryCrystalItem) {
            UUID uuid = MemoryCrystalItem.getFirstUUID(stack);
            Transporting.startTransport(this.level.getServer(), this.transportRings.getTransporter(), uuid);
        } else {
            if (chosenNumber < this.ringsPos.size()) {
                this.targetPos = this.ringsPos.get(chosenNumber);
            }
            if (this.targetPos == null) {
                return;
            }
            if (this.transportRings == null || !this.transportRings.canTransport()) {
                return;
            }
            BlockEntity targetRings = this.level.getBlockEntity(this.targetPos);
            if (targetRings instanceof TransportRingsEntity) {
                TransportRingsEntity target = (TransportRingsEntity)targetRings;
                if (!target.canTransport()) {
                    return;
                }
                Transporter transporter = target.getTransporter();
                if (transporter != null) {
                    this.transportRings.startTransport(transporter);
                }
            }
        }
    }

    public int[] getTargetCoords(int chosenNumber) {
        ItemStack stack = this.itemStackHandler.getStackInSlot(chosenNumber);
        return new int[]{0, 0, 0};
    }
}

