/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.capabilities.AncientGene;
import net.povstalec.sgjourney.common.misc.ComponentHelper;
import net.povstalec.sgjourney.common.tech.AncientTech;

public class ATAGeneDetectorBlock
extends Block
implements AncientTech {
    public static final IntegerProperty MEASURED_GENE = IntegerProperty.create((String)"measured_gene", (int)0, (int)3);
    public static final double DETECTION_DISTANCE = 5.0;
    private static final int TICKS_ACTIVE = 20;
    private static final int NO_GENE = 0;
    private static final int ARTIFICIAL_GENE = 9;
    private static final int INHERITED_GENE = 12;
    private static final int ANCIENT_GENE = 15;
    private int signalStrength = 0;

    public ATAGeneDetectorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)MEASURED_GENE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{MEASURED_GENE});
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            int measured = switch (this.getGeneType((Entity)player)) {
                case AncientGene.ATAGene.ARTIFICIAL -> 1;
                case AncientGene.ATAGene.INHERITED -> 2;
                case AncientGene.ATAGene.ANCIENT -> 3;
                default -> 0;
            };
            if ((Integer)state.getValue((Property)MEASURED_GENE) != measured) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MEASURED_GENE, (Comparable)Integer.valueOf(measured)), 3);
            }
        }
        level.scheduleTick(pos, (Block)this, 20);
        return InteractionResult.SUCCESS;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        level.setBlock(pos, (BlockState)state.setValue((Property)MEASURED_GENE, (Comparable)Integer.valueOf(0)), 3);
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        int measuredGene = (Integer)state.getValue((Property)MEASURED_GENE);
        switch (measuredGene) {
            case 1: {
                return 9;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 15;
            }
        }
        return 0;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean bool) {
        if (level.isClientSide()) {
            return;
        }
        int newSignalStrength = level.getBestNeighborSignal(pos);
        if (newSignalStrength > this.signalStrength || newSignalStrength == 0) {
            this.signalStrength = newSignalStrength;
        }
        if (level.hasNeighborSignal(pos) && this.signalStrength == newSignalStrength) {
            int measured = this.detectATAGene(state, level, pos, (double)this.signalStrength * 2.0);
            if ((Integer)state.getValue((Property)MEASURED_GENE) != measured) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MEASURED_GENE, (Comparable)Integer.valueOf(measured)), 3);
            }
        }
    }

    private int detectATAGene(BlockState state, Level level, BlockPos pos, double detectionDistance) {
        AABB localBox = new AABB((double)pos.getX() - detectionDistance, (double)pos.getY() - detectionDistance, (double)pos.getZ() - detectionDistance, (double)(pos.getX() + 1) + detectionDistance, (double)(pos.getY() + 1) + detectionDistance, (double)(pos.getZ() + 1) + detectionDistance);
        List localEntities = level.getEntitiesOfClass(Entity.class, localBox);
        return this.measureHighestLevel(localEntities);
    }

    private int measureHighestLevel(List<Entity> entities) {
        int measured = 0;
        if (entities.stream().anyMatch(entity -> this.getGeneType((Entity)entity) == AncientGene.ATAGene.ARTIFICIAL)) {
            measured = 1;
        }
        if (entities.stream().anyMatch(entity -> this.getGeneType((Entity)entity) == AncientGene.ATAGene.INHERITED)) {
            measured = 2;
        }
        if (entities.stream().anyMatch(entity -> this.getGeneType((Entity)entity) == AncientGene.ATAGene.ANCIENT)) {
            measured = 3;
        }
        return measured;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)ComponentHelper.description("block.sgjourney.ancient_gene_detector.description"));
        tooltipComponents.add((Component)ComponentHelper.usage("block.sgjourney.ancient_gene_detector.right_click"));
        tooltipComponents.add((Component)ComponentHelper.usage("block.sgjourney.ancient_gene_detector.redstone"));
    }
}

