/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.povstalec.sgjourney.common.blocks.UnityClusterBlock;
import net.povstalec.sgjourney.common.init.BlockInit;

public class BuddingUnityBlock
extends Block {
    public static final int GROWTH_CHANCE = 5;
    private static final Direction[] DIRECTIONS = Direction.values();

    public BuddingUnityBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (randomSource.nextInt(5) == 0) {
            Direction direction = DIRECTIONS[randomSource.nextInt(DIRECTIONS.length)];
            BlockPos crystalPos = pos.relative(direction);
            BlockState crystalState = level.getBlockState(crystalPos);
            Block crystalBlock = null;
            if (BuddingUnityBlock.canClusterGrowAtState(crystalState)) {
                crystalBlock = (Block)BlockInit.SMALL_UNITY_BUD.get();
            } else if (crystalState.is((Block)BlockInit.SMALL_UNITY_BUD.get()) && crystalState.getValue((Property)UnityClusterBlock.FACING) == direction) {
                crystalBlock = (Block)BlockInit.MEDIUM_UNITY_BUD.get();
            } else if (crystalState.is((Block)BlockInit.MEDIUM_UNITY_BUD.get()) && crystalState.getValue((Property)UnityClusterBlock.FACING) == direction) {
                crystalBlock = (Block)BlockInit.LARGE_UNITY_BUD.get();
            } else if (crystalState.is((Block)BlockInit.LARGE_UNITY_BUD.get()) && crystalState.getValue((Property)UnityClusterBlock.FACING) == direction) {
                crystalBlock = (Block)BlockInit.UNITY_CLUSTER.get();
            }
            if (crystalBlock != null) {
                BlockState newCrystalState = (BlockState)((BlockState)crystalBlock.defaultBlockState().setValue((Property)UnityClusterBlock.FACING, (Comparable)direction)).setValue((Property)UnityClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(crystalState.getFluidState().getType() == Fluids.WATER));
                level.setBlockAndUpdate(crystalPos, newCrystalState);
            }
        }
    }

    public static boolean canClusterGrowAtState(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER) && state.getFluidState().getAmount() == 8;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }
}

