/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChevronBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.ORIENTATION;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape TOP = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOTTOM = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape NORTH = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape WEST = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public ChevronBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(ORIENTATION, (Comparable)FrontAndTop.UP_NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{ORIENTATION}).add(new Property[]{LIT}).add(new Property[]{WATERLOGGED});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(ORIENTATION, (Comparable)rotation.rotation().rotate((FrontAndTop)state.getValue(ORIENTATION)));
    }

    public BlockState mirror(BlockState rotation, Mirror mirror) {
        return (BlockState)rotation.setValue(ORIENTATION, (Comparable)mirror.rotation().rotate((FrontAndTop)rotation.getValue(ORIENTATION)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        Direction direction1 = direction.getAxis() == Direction.Axis.Y ? context.getHorizontalDirection().getOpposite() : Direction.UP;
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue(ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)direction, (Direction)direction1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos1, Block block, BlockPos pos2, boolean p_55671_) {
        boolean isLit;
        if (!level.isClientSide() && (isLit = ((Boolean)state.getValue((Property)LIT)).booleanValue()) != level.hasNeighborSignal(pos1)) {
            if (isLit) {
                level.scheduleTick(pos1, (Block)this, 4);
            } else {
                level.setBlock(pos1, (BlockState)state.cycle((Property)LIT), 2);
            }
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue() && !level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)LIT), 2);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collision) {
        FrontAndTop orientation = (FrontAndTop)state.getValue(ORIENTATION);
        if (orientation == FrontAndTop.NORTH_UP) {
            return NORTH;
        }
        if (orientation == FrontAndTop.EAST_UP) {
            return EAST;
        }
        if (orientation == FrontAndTop.SOUTH_UP) {
            return SOUTH;
        }
        if (orientation == FrontAndTop.WEST_UP) {
            return WEST;
        }
        if (orientation.front() == Direction.DOWN) {
            return TOP;
        }
        return BOTTOM;
    }

    private boolean canSupport(BlockState state, LevelReader levelReader, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.relative(direction.getOpposite());
        BlockState blockstate = levelReader.getBlockState(blockPos);
        return blockstate.isFaceSturdy((BlockGetter)levelReader, pos, direction);
    }

    public boolean canSurvive(BlockState state, LevelReader levelReader, BlockPos pos) {
        FrontAndTop orientation = (FrontAndTop)state.getValue(ORIENTATION);
        if (orientation == FrontAndTop.NORTH_UP) {
            return this.canSupport(state, levelReader, pos, Direction.NORTH);
        }
        if (orientation == FrontAndTop.EAST_UP) {
            return this.canSupport(state, levelReader, pos, Direction.EAST);
        }
        if (orientation == FrontAndTop.SOUTH_UP) {
            return this.canSupport(state, levelReader, pos, Direction.SOUTH);
        }
        if (orientation == FrontAndTop.WEST_UP) {
            return this.canSupport(state, levelReader, pos, Direction.WEST);
        }
        if (orientation.front() == Direction.DOWN) {
            return this.canSupport(state, levelReader, pos, Direction.DOWN);
        }
        return this.canSupport(state, levelReader, pos, Direction.UP);
    }

    public BlockState updateShape(BlockState state1, Direction direction, BlockState state2, LevelAccessor levelAccessor, BlockPos pos1, BlockPos pos2) {
        if (((Boolean)state1.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(pos1, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return !this.canSurvive(state1, (LevelReader)levelAccessor, pos1) ? Blocks.AIR.defaultBlockState() : super.updateShape(state1, direction, state2, levelAccessor, pos1, pos2);
    }

    public void onPlace(BlockState state1, Level level, BlockPos pos, BlockState state2, boolean p_55728_) {
        for (Direction direction : Direction.values()) {
            level.updateNeighborsAt(pos.relative(direction), (Block)this);
        }
    }
}

