/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.IrisStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.ShieldingState;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.DataComponentInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.StargateVariantItem;
import net.povstalec.sgjourney.common.misc.InventoryUtil;
import net.povstalec.sgjourney.common.sgjourney.Address;
import net.povstalec.sgjourney.common.sgjourney.StargateInfo;
import net.povstalec.sgjourney.common.sgjourney.StargateVariant;

public abstract class AbstractStargateBaseBlock
extends AbstractStargateBlock
implements EntityBlock {
    public static final String EMPTY = StargateJourney.EMPTY;
    public static final String LOCAL_POINT_OF_ORIGIN = "local_point_of_origin";

    public AbstractStargateBaseBlock(BlockBehaviour.Properties properties, double width, double horizontalOffset) {
        super(properties, width, horizontalOffset);
    }

    public abstract AbstractStargateRingBlock getRing();

    public abstract AbstractShieldingBlock getIris();

    public boolean setVariant(Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item instanceof StargateVariantItem) {
            if (!stack.has(DataComponentInit.STARGATE_VARIANT)) {
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof AbstractStargateEntity) {
                    AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
                    if (!stargate.hasPermissions(player, true)) {
                        return false;
                    }
                    if (stargate.getVariant().equals((Object)StargateJourney.EMPTY)) {
                        player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.stargate.same_variant"), true);
                        return true;
                    }
                    stargate.setVariant(StargateJourney.EMPTY_LOCATION);
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                }
                return true;
            }
            ResourceLocation variant = StargateVariantItem.getStargateVariant(stack);
            if (variant != null) {
                if (level.isClientSide()) {
                    return true;
                }
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof AbstractStargateEntity) {
                    AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
                    if (!stargate.hasPermissions(player, true)) {
                        return false;
                    }
                    if (variant.equals((Object)stargate.getVariant())) {
                        player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.stargate.same_variant"), true);
                        return true;
                    }
                    RegistryAccess.Frozen registries = level.getServer().registryAccess();
                    Registry variantRegistry = registries.registryOrThrow(StargateVariant.REGISTRY_KEY);
                    Optional<StargateVariant> stargateVariant = Optional.ofNullable((StargateVariant)variantRegistry.get(variant));
                    if (stargateVariant.isPresent() && !stargateVariant.get().getBaseStargate().equals((Object)BlockEntityType.getKey((BlockEntityType)stargate.getType()))) {
                        player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.stargate.incorrect_stargate_type"), true);
                        return true;
                    }
                    stargate.setVariant(variant);
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    return true;
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.stargate.invalid_variant"), true);
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is((Item)ItemInit.STARGATE_VARIANT_CRYSTAL.get())) {
            return this.setVariant(level, pos, player, hand) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.FAIL;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        Player player = context.getPlayer();
        Orientation orientation = Orientation.getOrientationFromXRot(player);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER))).setValue((Property)ORIENTATION, (Comparable)((Object)orientation));
    }

    @Nullable
    public abstract BlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    public abstract BlockState ringState();

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        for (StargatePart part : this.getParts()) {
            if (part.equals(StargatePart.BASE)) continue;
            level.setBlock(part.getRingPos(pos, (Direction)state.getValue((Property)FACING), (Orientation)((Object)state.getValue((Property)ORIENTATION))), (BlockState)((BlockState)((BlockState)((BlockState)this.ringState().setValue((Property)AbstractStargateRingBlock.PART, (Comparable)((Object)part))).setValue((Property)AbstractStargateRingBlock.FACING, (Comparable)((Direction)level.getBlockState(pos).getValue((Property)FACING)))).setValue((Property)AbstractStargateRingBlock.ORIENTATION, (Comparable)((Object)((Orientation)((Object)level.getBlockState(pos).getValue((Property)ORIENTATION)))))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(part.getRingPos(pos, (Direction)state.getValue((Property)FACING), (Orientation)((Object)state.getValue((Property)ORIENTATION)))).getType() == Fluids.WATER)), 3);
        }
        AbstractStargateEntity stargate = this.getStargate((BlockGetter)level, pos, state);
        if (stargate != null && stargate instanceof IrisStargateEntity) {
            IrisStargateEntity irisStargate = (IrisStargateEntity)stargate;
            this.updateIris(level, pos, state, irisStargate.irisInfo().getShieldingState());
        }
    }

    public void onRemove(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (oldState.getBlock() != newState.getBlock()) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof AbstractStargateEntity) {
                AbstractStargateEntity stargate = (AbstractStargateEntity)blockentity;
                stargate.bypassDisconnectStargate(StargateInfo.Feedback.STARGATE_DESTROYED, false);
                stargate.dhdInfo().unsetDHD(true);
                stargate.removeStargateFromNetwork();
            }
            this.destroyStargate(level, pos, this.getParts(), this.getShieldingParts(), (Direction)oldState.getValue((Property)FACING), (Orientation)((Object)oldState.getValue((Property)ORIENTATION)), (StargatePart)((Object)oldState.getValue((Property)PART)));
            super.onRemove(oldState, level, pos, newState, isMoving);
        }
    }

    public void updateStargate(Level level, BlockPos pos, BlockState state, ShieldingState shieldingState) {
        if (!(state.getBlock() instanceof AbstractStargateBlock)) {
            return;
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        Orientation orientation = (Orientation)((Object)state.getValue((Property)ORIENTATION));
        for (StargatePart part : this.getParts(shieldingState != ShieldingState.OPEN)) {
            BlockPos ringPos;
            if (part.equals(StargatePart.BASE) || !(level.getBlockState(ringPos = part.getRingPos(pos, direction, orientation)).getBlock() instanceof AbstractStargateBlock)) continue;
            level.setBlock(part.getRingPos(pos, direction, orientation), (BlockState)((BlockState)((BlockState)((BlockState)this.ringState().setValue((Property)AbstractStargateRingBlock.PART, (Comparable)((Object)part))).setValue((Property)AbstractStargateRingBlock.FACING, (Comparable)((Direction)level.getBlockState(pos).getValue((Property)FACING)))).setValue((Property)AbstractStargateRingBlock.ORIENTATION, (Comparable)((Object)((Orientation)((Object)level.getBlockState(pos).getValue((Property)ORIENTATION)))))).setValue((Property)AbstractStargateRingBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(part.getRingPos(pos, (Direction)state.getValue((Property)FACING), (Orientation)((Object)state.getValue((Property)ORIENTATION)))).getType() == Fluids.WATER)), 3);
        }
    }

    public void unsetIris(BlockState state, Level level, BlockPos pos) {
        AbstractStargateEntity stargate = this.getStargate((BlockGetter)level, pos, state);
        if (stargate != null && stargate instanceof IrisStargateEntity) {
            IrisStargateEntity irisStargate = (IrisStargateEntity)stargate;
            irisStargate.irisInfo().removeIris();
        }
        this.updateStargate(level, pos, state, ShieldingState.OPEN);
    }

    public void updateIris(Level level, BlockPos pos, BlockState state, ShieldingState shieldingState) {
        if (this.getIris() == null) {
            return;
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        Orientation orientation = (Orientation)((Object)state.getValue((Property)ORIENTATION));
        AbstractShieldingBlock.setIrisState(this.getIris(), level, pos, this.getShieldingParts(), direction, orientation, shieldingState);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        long energy = 0L;
        String id = "";
        CompoundTag blockEntityTag = InventoryUtil.getBlockEntityTag(stack);
        if (blockEntityTag != null) {
            String variant;
            if (blockEntityTag.contains("variant") && !(variant = blockEntityTag.getString("variant")).equals(EMPTY)) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.variant").append((Component)Component.literal((String)(": " + variant))).withStyle(ChatFormatting.GREEN));
            }
            if (blockEntityTag.contains("energy")) {
                energy = blockEntityTag.getLong("energy");
            }
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.energy").append((Component)Component.literal((String)(": " + SGJourneyEnergy.energyToString(energy)))).withStyle(ChatFormatting.DARK_RED));
        if (blockEntityTag != null) {
            if ((blockEntityTag.contains("display_id") && blockEntityTag.getBoolean("display_id") || ((Boolean)CommonStargateConfig.always_display_stargate_id.get()).booleanValue()) && blockEntityTag.contains("9_hevron_address")) {
                id = Address.addressIntArrayToString(blockEntityTag.getIntArray("9_hevron_address"));
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.9_chevron_address").append((Component)Component.literal((String)(": " + id))).withStyle(ChatFormatting.AQUA));
            }
            if (blockEntityTag.contains("upgraded") && blockEntityTag.getBoolean("upgraded")) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.upgraded").withStyle(ChatFormatting.DARK_GREEN));
            }
            if (blockEntityTag.contains(LOCAL_POINT_OF_ORIGIN)) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.local_point_of_origin").withStyle(ChatFormatting.GREEN));
            }
            if (blockEntityTag.contains("generation_step", 1) && StructureGenEntity.Step.SETUP == StructureGenEntity.Step.fromByte(blockEntityTag.getByte("generation_step"))) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.generates_inside_structure").withStyle(ChatFormatting.YELLOW));
            }
            if (blockEntityTag.contains("primary", 1) && blockEntityTag.getBoolean("primary")) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.is_primary").withStyle(ChatFormatting.DARK_GREEN));
            }
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static ItemStack localPointOfOrigin(ItemStack stack, BlockEntityType<?> blockEntityType) {
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.putBoolean(LOCAL_POINT_OF_ORIGIN, true);
        BlockEntity.addEntityType((CompoundTag)compoundtag, blockEntityType);
        stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)compoundtag));
        return stack;
    }

    @Override
    public AbstractStargateEntity getStargate(BlockGetter reader, BlockPos pos, BlockState state) {
        BlockEntity blockentity = reader.getBlockEntity(pos);
        if (blockentity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockentity;
            return stargate;
        }
        return null;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> typeA, BlockEntityType<E> typeB, BlockEntityTicker<? super E> ticker) {
        return typeB == typeA ? ticker : null;
    }
}

