/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.ClassicStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.ClassicStargateRingBlock;
import net.povstalec.sgjourney.common.blocks.stargate.RotatingStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.shielding.AbstractShieldingBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.config.ClientStargateConfig;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.StargateUpgradeItem;
import net.povstalec.sgjourney.common.sgjourney.PointOfOrigin;
import net.povstalec.sgjourney.common.sgjourney.Symbols;

public class ClassicStargateBlock
extends RotatingStargateBaseBlock {
    public ClassicStargateBlock(BlockBehaviour.Properties properties) {
        super(properties, 8.0, 0.0);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        ClassicStargateEntity stargate = new ClassicStargateEntity(pos, state);
        return stargate;
    }

    @Override
    public AbstractStargateRingBlock getRing() {
        return (AbstractStargateRingBlock)BlockInit.CLASSIC_RING.get();
    }

    @Override
    public AbstractShieldingBlock getIris() {
        return (AbstractShieldingBlock)BlockInit.CLASSIC_SHIELDING.get();
    }

    @Override
    public BlockState ringState() {
        return ((ClassicStargateRingBlock)BlockInit.CLASSIC_RING.get()).defaultBlockState();
    }

    public boolean upgradeStargate(Level level, BlockPos pos, Player player, InteractionHand hand) {
        if (!((Boolean)CommonStargateConfig.enable_classic_stargate_upgrades.get()).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.stargate.classic.upgrading_disabled"), true);
            return true;
        }
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (item instanceof StargateUpgradeItem) {
            StargateUpgradeItem upgrade = (StargateUpgradeItem)item;
            Optional<AbstractStargateBaseBlock> baseBlock = upgrade.getStargateBaseBlock(stack);
            if (!baseBlock.isPresent()) {
                player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.stargate.classic.invalid_upgrade"), true);
                return true;
            }
            CompoundTag tag = new CompoundTag();
            BlockEntity oldEntity = level.getBlockEntity(pos);
            if (oldEntity instanceof AbstractStargateEntity) {
                AbstractStargateEntity stargate = (AbstractStargateEntity)oldEntity;
                if (!level.isClientSide()) {
                    tag = stargate.serializeStargateInfo(new CompoundTag(), (HolderLookup.Provider)level.getServer().registryAccess());
                }
            }
            Direction direction = (Direction)level.getBlockState(pos).getValue((Property)FACING);
            Orientation orientation = (Orientation)((Object)level.getBlockState(pos).getValue((Property)ORIENTATION));
            for (StargatePart stargatePart : baseBlock.get().getParts()) {
                BlockState partState = level.getBlockState(stargatePart.getRingPos(pos, direction, orientation));
                if (stargatePart.equals(StargatePart.BASE) || partState.canBeReplaced() || partState.getBlock() instanceof AbstractStargateBlock) continue;
                player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.stargate.not_enough_space"), true);
                return true;
            }
            Block block = level.getBlockState(pos).getBlock();
            if (block instanceof AbstractStargateBaseBlock) {
                AbstractStargateBaseBlock oldBaseBlock = (AbstractStargateBaseBlock)block;
                for (StargatePart part3 : oldBaseBlock.getParts()) {
                    level.setBlock(part3.getRingPos(pos, direction, orientation), Blocks.AIR.defaultBlockState(), 3);
                }
                for (StargatePart part : baseBlock.get().getParts()) {
                    if (part.equals(StargatePart.BASE)) continue;
                    level.setBlock(part.getRingPos(pos, direction, orientation), (BlockState)((BlockState)((BlockState)baseBlock.get().getRing().defaultBlockState().setValue((Property)AbstractStargateRingBlock.PART, (Comparable)((Object)part))).setValue((Property)AbstractStargateRingBlock.FACING, (Comparable)direction)).setValue((Property)AbstractStargateRingBlock.ORIENTATION, (Comparable)((Object)orientation)), 3);
                }
                level.setBlock(pos, (BlockState)((BlockState)baseBlock.get().defaultBlockState().setValue((Property)AbstractStargateRingBlock.FACING, (Comparable)direction)).setValue((Property)AbstractStargateRingBlock.ORIENTATION, (Comparable)((Object)orientation)), 3);
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof AbstractStargateEntity) {
                    AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
                    if (!level.isClientSide()) {
                        stargate.deserializeStargateInfo(tag, (HolderLookup.Provider)level.getServer().registryAccess(), true);
                        stargate.addStargateToNetwork();
                    }
                }
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.getItemInHand(hand).is((Item)ItemInit.STARGATE_UPGRADE_CRYSTAL.get())) {
            return this.upgradeStargate(level, pos, player, hand) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.FAIL;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return ClassicStargateBlock.createTickerHelper(type, (BlockEntityType)BlockEntityInit.CLASSIC_STARGATE.get(), ClassicStargateEntity::tick);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientPacketListener clientPacketListener = minecraft.getConnection();
        if (clientPacketListener != null) {
            RegistryAccess.Frozen registries = clientPacketListener.registryAccess();
            Registry pointOfOriginRegistry = registries.registryOrThrow(PointOfOrigin.REGISTRY_KEY);
            Registry symbolsRegistry = registries.registryOrThrow(Symbols.REGISTRY_KEY);
            String pointOfOrigin = "";
            boolean hasData = stack.has(DataComponents.BLOCK_ENTITY_DATA);
            if (hasData && ((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).getUnsafe().contains("point_of_origin")) {
                ResourceLocation location = ResourceLocation.parse((String)((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).getUnsafe().getString("point_of_origin"));
                pointOfOrigin = location.toString().equals("sgjourney:empty") ? "Empty" : (pointOfOriginRegistry.containsKey(location) ? ((PointOfOrigin)pointOfOriginRegistry.get(location)).getName() : "Error");
            }
            String symbols = "";
            if (hasData && ((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).getUnsafe().contains("symbols")) {
                ResourceLocation location = ResourceLocation.parse((String)((CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)).getUnsafe().getString("symbols"));
                symbols = location.toString().equals("sgjourney:empty") ? "Empty" : (symbolsRegistry.containsKey(location) ? ((Symbols)symbolsRegistry.get(location)).getTranslationName(!ClientStargateConfig.unique_symbols.get()) : "Error");
            }
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.point_of_origin").append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)pointOfOrigin)).withStyle(ChatFormatting.DARK_PURPLE));
            tooltipComponents.add((Component)Component.translatable((String)Symbols.symbolsOrSet()).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)symbols)).withStyle(ChatFormatting.LIGHT_PURPLE));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

