/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.stargate.shielding;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.ProtectedBlockEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.IrisStargateEntity;
import net.povstalec.sgjourney.common.blocks.ProtectedBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBaseBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.blockstates.ShieldingPart;
import net.povstalec.sgjourney.common.blockstates.ShieldingState;
import net.povstalec.sgjourney.common.config.CommonIrisConfig;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.misc.VoxelShapeProvider;

public abstract class AbstractShieldingBlock
extends Block
implements SimpleWaterloggedBlock,
ProtectedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Orientation> ORIENTATION = EnumProperty.create((String)"orientation", Orientation.class);
    public static final EnumProperty<ShieldingState> SHIELDING_STATE = EnumProperty.create((String)"shielding_state", ShieldingState.class);
    public static final EnumProperty<ShieldingPart> PART = EnumProperty.create((String)"shielding_part", ShieldingPart.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected VoxelShapeProvider shapeProvider;

    public AbstractShieldingBlock(BlockBehaviour.Properties properties, double width, double horizontalOffset) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(ORIENTATION, (Comparable)((Object)Orientation.REGULAR))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(PART, (Comparable)((Object)ShieldingPart.ABOVE))).setValue(SHIELDING_STATE, (Comparable)((Object)ShieldingState.OPEN)));
        this.shapeProvider = new VoxelShapeProvider(width, horizontalOffset);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{FACING}).add(new Property[]{WATERLOGGED}).add(new Property[]{ORIENTATION}).add(new Property[]{PART}).add(new Property[]{SHIELDING_STATE});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        SoundType soundtype = state.getSoundType((LevelReader)level, pos, null);
        level.playLocalSound(pos, soundtype.getBreakSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f, false);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        IrisStargateEntity stargate;
        BlockEntity blockentity = level.getBlockEntity(((ShieldingPart)((Object)state.getValue(PART))).getBaseBlockPos(pos, (Direction)state.getValue((Property)FACING), (Orientation)((Object)state.getValue(ORIENTATION))));
        if (blockentity instanceof IrisStargateEntity && (stargate = (IrisStargateEntity)blockentity).irisInfo().getIris() != null && !stargate.irisInfo().getIris().isEmpty()) {
            return stargate.irisInfo().getIris().copy();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos position, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        Orientation orientation = (Orientation)((Object)state.getValue(ORIENTATION));
        ShieldingState shieldingState = (ShieldingState)((Object)state.getValue(SHIELDING_STATE));
        return switch ((ShieldingPart)((Object)state.getValue(PART))) {
            case ShieldingPart.LEFT_ABOVE5, ShieldingPart.ABOVE5, ShieldingPart.RIGHT_ABOVE5 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_1) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_TOP, direction, orientation);
            case ShieldingPart.LEFT2_ABOVE4, ShieldingPart.LEFT2_ABOVE3, ShieldingPart.LEFT2_ABOVE2 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_1) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_LEFT, direction, orientation);
            case ShieldingPart.RIGHT2_ABOVE2, ShieldingPart.RIGHT2_ABOVE3, ShieldingPart.RIGHT2_ABOVE4 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_1) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_RIGHT, direction, orientation);
            case ShieldingPart.LEFT_ABOVE, ShieldingPart.ABOVE, ShieldingPart.RIGHT_ABOVE -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_1) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_BOTTOM, direction, orientation);
            case ShieldingPart.LEFT_ABOVE4 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_2) ? (shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_STAIR_BOTTOM_RIGHT) : this.shapeProvider.IRIS_CORNER_TOP_LEFT, direction, orientation);
            case ShieldingPart.RIGHT_ABOVE4 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_2) ? (shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_STAIR_BOTTOM_LEFT) : this.shapeProvider.IRIS_CORNER_TOP_RIGHT, direction, orientation);
            case ShieldingPart.LEFT_ABOVE2 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_2) ? (shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_STAIR_TOP_RIGHT) : this.shapeProvider.IRIS_CORNER_BOTTOM_LEFT, direction, orientation);
            case ShieldingPart.RIGHT_ABOVE2 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_2) ? (shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_STAIR_TOP_LEFT) : this.shapeProvider.IRIS_CORNER_BOTTOM_RIGHT, direction, orientation);
            case ShieldingPart.ABOVE4 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_TOP, direction, orientation);
            case ShieldingPart.LEFT_ABOVE3 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_LEFT, direction, orientation);
            case ShieldingPart.RIGHT_ABOVE3 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_RIGHT, direction, orientation);
            case ShieldingPart.ABOVE2 -> VoxelShapeProvider.getShapeFromArray(shieldingState.isAfter(ShieldingState.MOVING_3) ? this.shapeProvider.IRIS_FULL : this.shapeProvider.IRIS_BOTTOM, direction, orientation);
            default -> VoxelShapeProvider.getShapeFromArray(this.shapeProvider.IRIS_FULL, direction, orientation);
        };
    }

    public AbstractStargateEntity getStargate(BlockGetter reader, BlockPos pos, BlockState state) {
        BlockPos baseBlockPos = ((ShieldingPart)((Object)state.getValue(PART))).getBaseBlockPos(pos, (Direction)state.getValue((Property)FACING), (Orientation)((Object)state.getValue(ORIENTATION)));
        BlockState stargateState = reader.getBlockState(baseBlockPos);
        Block block = stargateState.getBlock();
        if (block instanceof AbstractStargateBlock) {
            AbstractStargateBlock stargateBlock = (AbstractStargateBlock)block;
            return stargateBlock.getStargate(reader, baseBlockPos, stargateState);
        }
        return null;
    }

    @Override
    public ProtectedBlockEntity getProtectedBlockEntity(BlockGetter reader, BlockPos pos, BlockState state) {
        return this.getStargate(reader, pos, state);
    }

    @Override
    public boolean hasPermissions(BlockGetter reader, BlockPos pos, BlockState state, Player player, boolean sendMessage) {
        AbstractStargateEntity stargate = this.getStargate(reader, pos, state);
        if (stargate != null) {
            return stargate.hasPermissions(player, sendMessage);
        }
        return true;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        AbstractStargateBaseBlock stargateBlock;
        AbstractStargateEntity stargate;
        BlockPos baseBlockPos = ((ShieldingPart)((Object)state.getValue(PART))).getBaseBlockPos(pos, (Direction)state.getValue((Property)FACING), (Orientation)((Object)state.getValue(ORIENTATION)));
        BlockState stargateState = level.getBlockState(baseBlockPos);
        Block block = stargateState.getBlock();
        if (block instanceof AbstractStargateBaseBlock && (stargate = (stargateBlock = (AbstractStargateBaseBlock)block).getStargate((BlockGetter)level, baseBlockPos, stargateState)) != null && stargate instanceof IrisStargateEntity) {
            IrisStargateEntity irisStargate = (IrisStargateEntity)stargate;
            ItemStack irisStack = irisStargate.irisInfo().getIris();
            if (!(level.isClientSide() || player.isCreative() || irisStack.equals(ItemStack.EMPTY))) {
                ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, irisStack);
                itementity.setDefaultPickUpDelay();
                itementity.setUnlimitedLifetime();
                level.addFreshEntity((Entity)itementity);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onRemove(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (oldState.getBlock() != newState.getBlock()) {
            AbstractStargateBaseBlock stargateBlock;
            AbstractStargateEntity stargate;
            ShieldingPart shieldingPart = (ShieldingPart)((Object)oldState.getValue(PART));
            BlockPos baseBlockPos = shieldingPart.getBaseBlockPos(pos, (Direction)oldState.getValue((Property)FACING), (Orientation)((Object)oldState.getValue(ORIENTATION)));
            BlockState stargateState = level.getBlockState(baseBlockPos);
            Block block = stargateState.getBlock();
            if (block instanceof AbstractStargateBaseBlock && (stargate = (stargateBlock = (AbstractStargateBaseBlock)block).getStargate((BlockGetter)level, baseBlockPos, stargateState)) != null && stargate instanceof IrisStargateEntity) {
                IrisStargateEntity irisStargate = (IrisStargateEntity)stargate;
                if (shieldingPart.shieldingState().isBefore(irisStargate.irisInfo().getIrisProgress())) {
                    AbstractShieldingBlock.destroyShielding(level, baseBlockPos, this.getShieldingParts(), (Direction)oldState.getValue((Property)FACING), (Orientation)((Object)oldState.getValue(ORIENTATION)));
                    stargateBlock.unsetIris(stargateState, level, baseBlockPos);
                }
            }
            super.onRemove(oldState, level, pos, newState, isMoving);
        }
    }

    public abstract ArrayList<ShieldingPart> getShieldingParts();

    public static void destroyShielding(Level level, BlockPos baseBlockPos, ArrayList<ShieldingPart> parts, Direction direction, Orientation orientation) {
        if (direction == null) {
            StargateJourney.LOGGER.error("Failed to destroy Shielding because direction is null");
            return;
        }
        if (orientation == null) {
            StargateJourney.LOGGER.error("Failed to destroy Shielding because orientation is null");
            return;
        }
        for (ShieldingPart part : parts) {
            BlockPos ringPos = part.getShieldingPos(baseBlockPos, direction, orientation);
            BlockState state = level.getBlockState(ringPos);
            if (!(state.getBlock() instanceof AbstractShieldingBlock)) continue;
            boolean waterlogged = (Boolean)state.getValue((Property)WATERLOGGED);
            level.setBlock(ringPos, waterlogged ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState(), 3);
        }
    }

    public static void setIrisState(AbstractShieldingBlock irisBlock, Level level, BlockPos baseBlockPos, ArrayList<ShieldingPart> parts, Direction direction, Orientation orientation, ShieldingState shieldingState) {
        if (direction == null) {
            StargateJourney.LOGGER.error("Failed to place Shielding because direction is null");
            return;
        }
        if (orientation == null) {
            StargateJourney.LOGGER.error("Failed to place Shielding because orientation is null");
            return;
        }
        for (ShieldingPart part : parts) {
            BlockPos shieldingPos = part.getShieldingPos(baseBlockPos, direction, orientation);
            BlockState state = level.getBlockState(shieldingPos);
            if (state.getBlock() instanceof AbstractShieldingBlock && !part.canExist(shieldingState)) {
                boolean waterlogged = (Boolean)state.getValue((Property)WATERLOGGED);
                level.setBlock(shieldingPos, waterlogged ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState(), 3);
                continue;
            }
            if (!part.canExist(shieldingState)) continue;
            float destroySpeed = state.getDestroySpeed((BlockGetter)level, shieldingPos);
            if (state.getBlock() instanceof AbstractShieldingBlock || state.is(Blocks.AIR) || state.is(Blocks.WATER)) {
                level.setBlock(part.getShieldingPos(baseBlockPos, direction, orientation), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)irisBlock.defaultBlockState().setValue(SHIELDING_STATE, (Comparable)((Object)shieldingState))).setValue(PART, (Comparable)((Object)part))).setValue((Property)FACING, (Comparable)direction)).setValue(ORIENTATION, (Comparable)((Object)orientation))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(part.getShieldingPos(baseBlockPos, direction, orientation)).getType() == Fluids.WATER)), 3);
                continue;
            }
            if (!(destroySpeed > 0.0f) || !((double)destroySpeed < (Double)CommonIrisConfig.iris_breaking_strength.get()) || state.is(TagInit.Blocks.IRIS_RESISTANT)) continue;
            level.levelEvent((Player)null, 2001, shieldingPos, AbstractShieldingBlock.getId((BlockState)state));
            level.setBlock(part.getShieldingPos(baseBlockPos, direction, orientation), (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)irisBlock.defaultBlockState().setValue(SHIELDING_STATE, (Comparable)((Object)shieldingState))).setValue(PART, (Comparable)((Object)part))).setValue((Property)FACING, (Comparable)direction)).setValue(ORIENTATION, (Comparable)((Object)orientation))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(part.getShieldingPos(baseBlockPos, direction, orientation)).getType() == Fluids.WATER)), 3);
        }
    }
}

