/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.tech;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.block_entities.tech.BatteryBlockEntity;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.menu.BatteryMenu;
import net.povstalec.sgjourney.common.misc.NetworkUtils;

public abstract class BatteryBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    public BatteryBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{FACING});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection());
    }

    public void use(Level level, BlockPos pos, Player player) {
        if (!level.isClientSide()) {
            final BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BatteryBlockEntity) {
                MenuProvider containerProvider = new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"screen.sgjourney.naquadah_battery");
                    }

                    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                        return new BatteryMenu(windowId, playerInventory, blockEntity);
                    }
                };
                NetworkUtils.openMenu((ServerPlayer)player, containerProvider, blockEntity.getBlockPos());
            } else {
                throw new IllegalStateException("Our named container provider is missing!");
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        this.use(level, pos, player);
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        this.use(level, pos, player);
        return ItemInteractionResult.SUCCESS;
    }

    public abstract Block getDroppedBlock();

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof BatteryBlockEntity && !level.isClientSide() && !player.isCreative() && player.hasCorrectToolForDrops(state)) {
            ItemStack itemstack = new ItemStack((ItemLike)this.getDroppedBlock());
            blockentity.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess());
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public static class Naquadah
    extends BatteryBlock {
        public static final MapCodec<Naquadah> CODEC = Naquadah.simpleCodec(Naquadah::new);

        public Naquadah(BlockBehaviour.Properties properties) {
            super(properties);
        }

        protected MapCodec<Naquadah> codec() {
            return CODEC;
        }

        @Nullable
        public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
            return new BatteryBlockEntity.Naquadah(pos, state);
        }

        @Nullable
        public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
            return Naquadah.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BlockEntityInit.LARGE_NAQUADAH_BATTERY.get()), BatteryBlockEntity::tick);
        }

        @Override
        public Block getDroppedBlock() {
            return (Block)BlockInit.LARGE_NAQUADAH_BATTERY.get();
        }
    }
}

