/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.tech;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.povstalec.sgjourney.common.block_entities.tech.TransceiverEntity;
import net.povstalec.sgjourney.common.blockstates.Receiving;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.menu.TransceiverMenu;
import net.povstalec.sgjourney.common.misc.ComponentHelper;
import net.povstalec.sgjourney.common.misc.NetworkUtils;
import net.povstalec.sgjourney.common.misc.VoxelShapeProvider;
import org.joml.Vector3d;

public class TransceiverBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<Receiving> RECEIVING = EnumProperty.create((String)"receiving", Receiving.class);
    public static final BooleanProperty TRANSMITTING = BooleanProperty.create((String)"transmitting");
    private static final int TICKS_ACTIVE = 20;
    private static final ArrayList<Tuple<Vector3d, Vector3d>> MIN_MAX = new ArrayList<Tuple>(Arrays.asList(new Tuple((Object)new Vector3d(2.0, 0.0, 3.0), (Object)new Vector3d(14.0, 4.0, 16.0))));
    private static final VoxelShape SHAPE_NORTH = VoxelShapeProvider.getDirectionalShapes(MIN_MAX, Direction.NORTH);
    private static final VoxelShape SHAPE_EAST = VoxelShapeProvider.getDirectionalShapes(MIN_MAX, Direction.EAST);
    private static final VoxelShape SHAPE_SOUTH = VoxelShapeProvider.getDirectionalShapes(MIN_MAX, Direction.SOUTH);
    private static final VoxelShape SHAPE_WEST = VoxelShapeProvider.getDirectionalShapes(MIN_MAX, Direction.WEST);

    public TransceiverBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(RECEIVING, (Comparable)((Object)Receiving.FALSE))).setValue((Property)TRANSMITTING, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TransceiverEntity(pos, state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext collision) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{FACING}).add(new Property[]{RECEIVING}).add(new Property[]{TRANSMITTING});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotation().rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.rotation().rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void use(Level level, BlockPos pos, Player player) {
        if (!level.isClientSide()) {
            final BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof TransceiverEntity) {
                MenuProvider containerProvider = new MenuProvider(){

                    public Component getDisplayName() {
                        return Component.translatable((String)"screen.sgjourney.transceiver");
                    }

                    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                        return new TransceiverMenu(windowId, playerInventory, blockEntity);
                    }
                };
                NetworkUtils.openMenu((ServerPlayer)player, containerProvider, blockEntity.getBlockPos());
            } else {
                throw new IllegalStateException("Our named container provider is missing!");
            }
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        this.use(level, pos, player);
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        this.use(level, pos, player);
        return ItemInteractionResult.SUCCESS;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        level.setBlock(pos, (BlockState)state.setValue(RECEIVING, (Comparable)((Object)Receiving.FALSE)), 3);
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        Receiving receiving = (Receiving)((Object)state.getValue(RECEIVING));
        if (receiving != null) {
            return receiving.getRedstonePower();
        }
        return 0;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean bool) {
        BlockEntity blockEntity;
        if (level.isClientSide()) {
            return;
        }
        if (level.hasNeighborSignal(pos) && (blockEntity = level.getBlockEntity(pos)) instanceof TransceiverEntity) {
            TransceiverEntity transceiver = (TransceiverEntity)blockEntity;
            transceiver.sendTransmission();
        }
        super.neighborChanged(state, level, pos, block, pos2, bool);
    }

    public void receiveTransmission(BlockState state, Level level, BlockPos pos, boolean codeIsCorrect) {
        if (codeIsCorrect) {
            level.setBlock(pos, (BlockState)state.setValue(RECEIVING, (Comparable)((Object)Receiving.RECEIVING_CORRECT)), 3);
        } else {
            level.setBlock(pos, (BlockState)state.setValue(RECEIVING, (Comparable)((Object)Receiving.RECEIVING_INCORRECT)), 3);
        }
        level.scheduleTick(pos, (Block)this, 20);
    }

    public void stopTransmitting(BlockState state, Level level, BlockPos pos) {
        level.setBlock(pos, (BlockState)state.setValue((Property)TRANSMITTING, (Comparable)Boolean.valueOf(false)), 2);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)ComponentHelper.description("block.sgjourney.transceiver.description"));
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> typeA, BlockEntityType<E> typeB, BlockEntityTicker<? super E> ticker) {
        return typeB == typeA ? ticker : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return TransceiverBlock.createTickerHelper(type, (BlockEntityType)BlockEntityInit.TRANSCEIVER.get(), TransceiverEntity::tick);
    }
}

