/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.tech_interface;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.IrisStargateEntity;
import net.povstalec.sgjourney.common.block_entities.tech.EnergyBlockEntity;
import net.povstalec.sgjourney.common.block_entities.tech_interface.AbstractInterfaceEntity;
import net.povstalec.sgjourney.common.blockstates.InterfaceMode;
import net.povstalec.sgjourney.common.menu.InterfaceMenu;
import net.povstalec.sgjourney.common.misc.InventoryUtil;
import net.povstalec.sgjourney.common.misc.NetworkUtils;

public abstract class AbstractInterfaceBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty UPDATE = BooleanProperty.create((String)"update");
    public static final EnumProperty<InterfaceMode> MODE = EnumProperty.create((String)"mode", InterfaceMode.class);

    protected AbstractInterfaceBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)UPDATE, (Comparable)Boolean.valueOf(false))).setValue(MODE, (Comparable)((Object)InterfaceMode.OFF)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> state) {
        state.add(new Property[]{FACING}).add(new Property[]{UPDATE}).add(new Property[]{MODE});
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getNearestLookingDirection());
    }

    public void setMode(BlockState state, Level level, BlockPos pos, InterfaceMode mode) {
        BlockState newModeState = (BlockState)state.setValue(MODE, (Comparable)((Object)mode));
        level.setBlock(pos, newModeState, 3);
    }

    public InterfaceMode cycleModes(BlockState state, Level level, BlockPos pos, AbstractInterfaceEntity interfaceEntity) {
        InterfaceMode nextMode = ((InterfaceMode)((Object)state.getValue(MODE))).next(interfaceEntity.getInterfaceType().hasAdvancedCrystalMethods());
        this.setMode(state, level, pos, nextMode);
        return nextMode;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            final BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof AbstractInterfaceEntity) {
                InterfaceMode nextMode;
                final AbstractInterfaceEntity interfaceEntity = (AbstractInterfaceEntity)blockEntity;
                if (!player.isShiftKeyDown()) {
                    MenuProvider containerProvider = new MenuProvider(){

                        public Component getDisplayName() {
                            return Component.translatable((String)("screen.sgjourney." + interfaceEntity.getInterfaceType().getName()));
                        }

                        public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
                            return new InterfaceMenu(windowId, playerInventory, blockEntity);
                        }
                    };
                    NetworkUtils.openMenu((ServerPlayer)player, containerProvider, blockEntity.getBlockPos());
                } else if (player.isShiftKeyDown() && player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && (nextMode = this.cycleModes(state, level, pos, interfaceEntity)) != null) {
                    player.displayClientMessage((Component)Component.translatable((String)"block.sgjourney.interface.mode").append((Component)Component.literal((String)": ").append(nextMode.getName())), true);
                }
            } else {
                throw new IllegalStateException("Our named container provider is missing!");
            }
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public abstract Block getDroppedBlock();

    public abstract long getCapacity();

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof AbstractInterfaceEntity && !level.isClientSide() && !player.isCreative() && player.hasCorrectToolForDrops(state)) {
            ItemStack itemstack = new ItemStack((ItemLike)this.getDroppedBlock());
            blockentity.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess());
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource source) {
        level.setBlock(pos, (BlockState)state.setValue((Property)UPDATE, (Comparable)Boolean.valueOf(false)), 3);
    }

    public void updateInterface(BlockState state, Level level, BlockPos pos) {
        level.setBlock(pos, (BlockState)state.setValue((Property)UPDATE, (Comparable)Boolean.valueOf(true)), 3);
        level.scheduleTick(pos, (Block)this, 2);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean bool) {
        AbstractInterfaceEntity interfaceEntity;
        BlockEntity blockEntity;
        if (level.isClientSide()) {
            return;
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos targetPos = pos.relative(direction);
        if (targetPos.equals((Object)pos2) && (blockEntity = level.getBlockEntity(pos)) instanceof AbstractInterfaceEntity && (interfaceEntity = (AbstractInterfaceEntity)blockEntity).updateInterface(level, targetPos, block, state)) {
            level.updateNeighborsAtExceptFromFacing(pos, state.getBlock(), (Direction)state.getValue((Property)FACING));
        }
        boolean hasSignal = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof AbstractInterfaceEntity) {
            AbstractInterfaceEntity interfaceEntity2 = (AbstractInterfaceEntity)blockentity;
            interfaceEntity2.signalStrength = hasSignal ? level.getBestNeighborSignal(pos) : 0;
        }
    }

    private int getRingSegmentOutput(EnergyBlockEntity blockEntity) {
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            return stargate.getRedstoneSegmentOutput();
        }
        return 0;
    }

    private int getRotationOutput(EnergyBlockEntity blockEntity) {
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            return stargate.getRedstoneSymbolOutput();
        }
        return 0;
    }

    private int getChevronOutput(EnergyBlockEntity blockEntity) {
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            return stargate.getChevronsEngaged();
        }
        return 0;
    }

    private int getConnectionOutput(EnergyBlockEntity blockEntity) {
        if (blockEntity instanceof AbstractStargateEntity) {
            AbstractStargateEntity stargate = (AbstractStargateEntity)blockEntity;
            return stargate.isConnected() ? (stargate.isDialingOut() ? 15 : 7) : 0;
        }
        return 0;
    }

    private int getIrisOutput(EnergyBlockEntity blockEntity) {
        if (blockEntity instanceof IrisStargateEntity) {
            IrisStargateEntity stargate = (IrisStargateEntity)blockEntity;
            return Math.round(15.0f * (float)stargate.irisInfo().getIrisProgress() / 58.0f);
        }
        return 0;
    }

    public int comparatorOutput(BlockState state, EnergyBlockEntity blockEntity) {
        switch ((InterfaceMode)((Object)state.getValue(MODE))) {
            case RING_SEGMENT: {
                return this.getRingSegmentOutput(blockEntity);
            }
            case RING_ROTATION: {
                return this.getRotationOutput(blockEntity);
            }
            case CHEVRONS_ACTIVE: {
                return this.getChevronOutput(blockEntity);
            }
            case WORMHOLE_ACTIVE: {
                return this.getConnectionOutput(blockEntity);
            }
            case IRIS: {
                return this.getIrisOutput(blockEntity);
            }
        }
        return 0;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof AbstractInterfaceEntity) {
            AbstractInterfaceEntity interfaceEntity = (AbstractInterfaceEntity)entity;
            return this.comparatorOutput(state, interfaceEntity.getEnergyBlockEntity());
        }
        return 0;
    }

    public long getEnergy(ItemStack stack) {
        CompoundTag blockEntityTag = InventoryUtil.getBlockEntityTag(stack);
        if (blockEntityTag != null && blockEntityTag.contains("energy", 4)) {
            return blockEntityTag.getLong("energy");
        }
        return 0L;
    }
}

