/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.transporter;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.transporter.AbstractTransporterEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.misc.InventoryUtil;

public abstract class AbstractTransporterBlock
extends BaseEntityBlock {
    protected AbstractTransporterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity entity;
        if (state.getBlock() != newState.getBlock() && (entity = level.getBlockEntity(pos)) instanceof AbstractTransporterEntity) {
            AbstractTransporterEntity transporterEntity = (AbstractTransporterEntity)entity;
            transporterEntity.disconnectTransporter();
            transporterEntity.removeTransporterFromNetwork();
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof AbstractTransporterEntity) {
            AbstractTransporterEntity transporter = (AbstractTransporterEntity)blockentity;
            if (!level.isClientSide() && !player.isCreative()) {
                ItemStack itemstack = new ItemStack((ItemLike)BlockInit.TRANSPORT_RINGS.get());
                blockentity.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess());
                if (transporter.hasCustomName()) {
                    itemstack.set(DataComponents.ITEM_NAME, (Object)transporter.getCustomName());
                }
                ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack);
                itementity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itementity);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        CompoundTag blockEntityTag = InventoryUtil.getBlockEntityTag(stack);
        String id = blockEntityTag != null && blockEntityTag.contains("transporter_id") ? blockEntityTag.getString("transporter_id") : "-";
        tooltipComponents.add((Component)Component.literal((String)("ID: " + id)).withStyle(ChatFormatting.AQUA));
        if (blockEntityTag != null && blockEntityTag.contains("generation_step", 1) && StructureGenEntity.Step.SETUP == StructureGenEntity.Step.fromByte(blockEntityTag.getByte("generation_step"))) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.sgjourney.generates_inside_structure").withStyle(ChatFormatting.YELLOW));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }
}

