/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blockstates;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.enums.BubbleColumnDirection;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.EventHooks;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.config.CommonStargateConfig;
import net.povstalec.sgjourney.common.sgjourney.StargateBlockCover;
import net.povstalec.sgjourney.common.sgjourney.StargateConnection;
import org.jetbrains.annotations.Nullable;

public class StargateBlockState
extends BlockState {
    public StargateBlockState(Block block, Reference2ObjectArrayMap<Property<?>, Comparable<?>> properties, MapCodec<BlockState> states) {
        super(block, properties, states);
    }

    public float getDestroySpeed(BlockGetter reader, BlockPos pos) {
        Block block;
        if (reader != null && pos != null && (block = this.getBlock()) instanceof AbstractStargateBlock) {
            StargateConnection.State state;
            AbstractStargateBlock stargateBlock = (AbstractStargateBlock)block;
            AbstractStargateEntity stargate = stargateBlock.getStargate(reader, pos, reader.getBlockState(pos));
            if (stargate != null && !((Boolean)CommonStargateConfig.can_break_connected_stargate.get()).booleanValue() && (state = stargate.getConnectionState()).isConnected()) {
                return -1.0f;
            }
            Optional<StargateBlockCover> blockCover = stargateBlock.getBlockCover(reader, this, pos);
            if (blockCover.isPresent()) {
                StargatePart part = (StargatePart)((Object)this.getValue((Property)AbstractStargateBlock.PART));
                Optional<BlockState> coverState = blockCover.get().getBlockAt(part);
                if (coverState.isPresent()) {
                    return coverState.get().getDestroySpeed(reader, pos);
                }
            }
        }
        return super.getDestroySpeed(reader, pos);
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        float speed = state.getDestroySpeed(level, pos);
        if (speed == -1.0f) {
            return 0.0f;
        }
        int i = EventHooks.doPlayerHarvestCheck((Player)player, (BlockState)state, (BlockGetter)level, (BlockPos)pos) ? 30 : 100;
        return player.getDigSpeed(state, pos) / speed / (float)i;
    }

    public float getDestroyProgress(Player player, BlockGetter reader, BlockPos pos) {
        AbstractStargateBlock stargate;
        Optional<StargateBlockCover> blockCover;
        float destroySpeed = this.getDestroySpeed(reader, pos);
        if (destroySpeed == -1.0f) {
            return 0.0f;
        }
        Block block = this.getBlock();
        if (block instanceof AbstractStargateBlock && (blockCover = (stargate = (AbstractStargateBlock)block).getBlockCover(reader, this, pos)).isPresent()) {
            StargatePart part = (StargatePart)((Object)this.getValue((Property)AbstractStargateBlock.PART));
            Optional<BlockState> coverState = blockCover.get().getBlockAt(part);
            if (coverState.isPresent()) {
                float multiplier = player.hasCorrectToolForDrops(coverState.get()) ? 30.0f : 100.0f;
                return player.getDigSpeed(coverState.get(), pos) / destroySpeed / multiplier;
            }
        }
        return this.getDestroyProgress(this.asState(), player, reader, pos);
    }

    public SoundType getSoundType(LevelReader level, BlockPos pos, @Nullable Entity entity) {
        AbstractStargateBlock stargate;
        Optional<StargateBlockCover> blockCover;
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof AbstractStargateBlock && (blockCover = (stargate = (AbstractStargateBlock)block).getBlockCover((BlockGetter)level, state, pos)).isPresent()) {
            StargatePart part = (StargatePart)((Object)state.getValue(AbstractStargateBlock.PART));
            Optional<BlockState> coverState = blockCover.get().getBlockAt(part);
            if (coverState.isPresent()) {
                return coverState.get().getSoundType(level, pos, entity);
            }
        }
        return this.self().getBlock().getSoundType(this.self(), level, pos, entity);
    }

    protected BlockState asState() {
        return this;
    }

    private BlockState self() {
        return this;
    }

    public float getFriction(LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.self().getBlock().getFriction(this.self(), level, pos, entity);
    }

    public boolean hasDynamicLightEmission() {
        return this.self().getBlock().hasDynamicLightEmission(this.self());
    }

    public int getLightEmission(BlockGetter level, BlockPos pos) {
        return this.self().getBlock().getLightEmission(this.self(), level, pos);
    }

    public boolean isLadder(LevelReader level, BlockPos pos, LivingEntity entity) {
        return this.self().getBlock().isLadder(this.self(), level, pos, entity);
    }

    public boolean canHarvestBlock(BlockGetter level, BlockPos pos, Player player) {
        return this.self().getBlock().canHarvestBlock(this.self(), level, pos, player);
    }

    public boolean onDestroyedByPlayer(Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return this.self().getBlock().onDestroyedByPlayer(this.self(), level, pos, player, willHarvest, fluid);
    }

    public void onDestroyedByPushReaction(Level level, BlockPos pos, Direction pushDirection, FluidState fluid) {
        this.self().getBlock().onDestroyedByPushReaction(this.self(), level, pos, pushDirection, fluid);
    }

    public boolean isBed(BlockGetter level, BlockPos pos, LivingEntity sleeper) {
        return this.self().getBlock().isBed(this.self(), level, pos, sleeper);
    }

    public Optional<ServerPlayer.RespawnPosAngle> getRespawnPosition(EntityType<?> type, LevelReader level, BlockPos pos, float orientation) {
        return this.self().getBlock().getRespawnPosition(this.self(), type, level, pos, orientation);
    }

    public void setBedOccupied(Level level, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        this.self().getBlock().setBedOccupied(this.self(), level, pos, sleeper, occupied);
    }

    public Direction getBedDirection(LevelReader level, BlockPos pos) {
        return this.self().getBlock().getBedDirection(this.self(), level, pos);
    }

    public float getExplosionResistance(BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.self().getBlock().getExplosionResistance(this.self(), level, pos, explosion);
    }

    public ItemStack getCloneItemStack(HitResult target, LevelReader level, BlockPos pos, Player player) {
        return this.self().getBlock().getCloneItemStack(this.self(), target, level, pos, player);
    }

    public boolean addLandingEffects(ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return this.self().getBlock().addLandingEffects(this.self(), level, pos, state2, entity, numberOfParticles);
    }

    public boolean addRunningEffects(Level level, BlockPos pos, Entity entity) {
        return this.self().getBlock().addRunningEffects(this.self(), level, pos, entity);
    }

    public TriState canSustainPlant(BlockGetter level, BlockPos soilPosition, Direction facing, BlockState plant) {
        return this.self().getBlock().canSustainPlant(this.self(), level, soilPosition, facing, plant);
    }

    public boolean onTreeGrow(LevelReader level, BiConsumer<BlockPos, BlockState> placeFunction, RandomSource randomSource, BlockPos pos, TreeConfiguration config) {
        return this.self().getBlock().onTreeGrow(this.self(), level, placeFunction, randomSource, pos, config);
    }

    public boolean isFertile(BlockGetter level, BlockPos pos) {
        return this.self().getBlock().isFertile(this.self(), level, pos);
    }

    public boolean isConduitFrame(LevelReader level, BlockPos pos, BlockPos conduit) {
        return this.self().getBlock().isConduitFrame(this.self(), level, pos, conduit);
    }

    public boolean isPortalFrame(BlockGetter level, BlockPos pos) {
        return this.self().getBlock().isPortalFrame(this.self(), level, pos);
    }

    public int getExpDrop(LevelAccessor level, BlockPos pos, @Nullable BlockEntity blockEntity, @Nullable Entity breaker, ItemStack tool) {
        return this.self().getBlock().getExpDrop(this.self(), level, pos, blockEntity, breaker, tool);
    }

    public BlockState rotate(LevelAccessor level, BlockPos pos, Rotation direction) {
        return this.self().getBlock().rotate(this.self(), level, pos, direction);
    }

    public float getEnchantPowerBonus(LevelReader level, BlockPos pos) {
        return this.self().getBlock().getEnchantPowerBonus(this.self(), level, pos);
    }

    public void onNeighborChange(LevelReader level, BlockPos pos, BlockPos neighbor) {
        this.self().getBlock().onNeighborChange(this.self(), level, pos, neighbor);
    }

    public boolean shouldCheckWeakPower(SignalGetter level, BlockPos pos, Direction side) {
        return this.self().getBlock().shouldCheckWeakPower(this.self(), level, pos, side);
    }

    public boolean getWeakChanges(LevelReader level, BlockPos pos) {
        return this.self().getBlock().getWeakChanges(this.self(), level, pos);
    }

    @Nullable
    public Integer getBeaconColorMultiplier(LevelReader level, BlockPos pos, BlockPos beacon) {
        return this.self().getBlock().getBeaconColorMultiplier(this.self(), level, pos, beacon);
    }

    public BlockState getStateAtViewpoint(BlockGetter level, BlockPos pos, Vec3 viewpoint) {
        return this.self().getBlock().getStateAtViewpoint(this.self(), level, pos, viewpoint);
    }

    public boolean isSlimeBlock() {
        return this.self().getBlock().isSlimeBlock(this.self());
    }

    public boolean isStickyBlock() {
        return this.self().getBlock().isStickyBlock(this.self());
    }

    public boolean canStickTo(BlockState other) {
        return this.self().getBlock().canStickTo(this.self(), other);
    }

    public int getFlammability(BlockGetter level, BlockPos pos, Direction face) {
        return this.self().getBlock().getFlammability(this.self(), level, pos, face);
    }

    public boolean isFlammable(BlockGetter level, BlockPos pos, Direction face) {
        return this.self().getBlock().isFlammable(this.self(), level, pos, face);
    }

    public void onCaughtFire(Level level, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        this.self().getBlock().onCaughtFire(this.self(), level, pos, face, igniter);
    }

    public int getFireSpreadSpeed(BlockGetter level, BlockPos pos, Direction face) {
        return this.self().getBlock().getFireSpreadSpeed(this.self(), level, pos, face);
    }

    public boolean isFireSource(LevelReader level, BlockPos pos, Direction side) {
        return this.self().getBlock().isFireSource(this.self(), level, pos, side);
    }

    public boolean canEntityDestroy(BlockGetter level, BlockPos pos, Entity entity) {
        return this.self().getBlock().canEntityDestroy(this.self(), level, pos, entity);
    }

    public boolean isBurning(BlockGetter level, BlockPos pos) {
        return this.self().getBlock().isBurning(this.self(), level, pos);
    }

    @Nullable
    public PathType getBlockPathType(BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return this.self().getBlock().getBlockPathType(this.self(), level, pos, mob);
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockGetter level, BlockPos pos, @Nullable Mob mob, PathType originalType) {
        return this.self().getBlock().getAdjacentBlockPathType(this.self(), level, pos, mob, originalType);
    }

    public boolean canDropFromExplosion(BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.self().getBlock().canDropFromExplosion(this.self(), level, pos, explosion);
    }

    public void onBlockExploded(Level level, BlockPos pos, Explosion explosion) {
        this.self().getBlock().onBlockExploded(this.self(), level, pos, explosion);
    }

    public boolean collisionExtendsVertically(BlockGetter level, BlockPos pos, Entity collidingEntity) {
        return this.self().getBlock().collisionExtendsVertically(this.self(), level, pos, collidingEntity);
    }

    public boolean shouldDisplayFluidOverlay(BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return this.self().getBlock().shouldDisplayFluidOverlay(this.self(), level, pos, fluidState);
    }

    @Nullable
    public BlockState getToolModifiedState(UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        BlockState eventState = EventHooks.onToolUse((BlockState)this.self(), (UseOnContext)context, (ItemAbility)itemAbility, (boolean)simulate);
        return eventState != this.self() ? eventState : this.self().getBlock().getToolModifiedState(this.self(), context, itemAbility, simulate);
    }

    public boolean isScaffolding(LivingEntity entity) {
        return this.self().getBlock().isScaffolding(this.self(), (LevelReader)entity.level(), entity.blockPosition(), entity);
    }

    public boolean canRedstoneConnectTo(BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return this.self().getBlock().canConnectRedstone(this.self(), level, pos, direction);
    }

    public boolean hidesNeighborFace(BlockGetter level, BlockPos pos, BlockState neighborState, Direction dir) {
        return this.self().getBlock().hidesNeighborFace(level, pos, this.self(), neighborState, dir);
    }

    public boolean supportsExternalFaceHiding() {
        return this.self().getBlock().supportsExternalFaceHiding(this.self());
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState) {
        this.self().getBlock().onBlockStateChange(level, pos, oldState, this.self());
    }

    public boolean canBeHydrated(BlockGetter getter, BlockPos pos, FluidState fluid, BlockPos fluidPos) {
        return this.self().getBlock().canBeHydrated(this.self(), getter, pos, fluid, fluidPos);
    }

    public BlockState getAppearance(BlockAndTintGetter level, BlockPos pos, Direction side, @Nullable BlockState queryState, @Nullable BlockPos queryPos) {
        return this.self().getBlock().getAppearance(this.self(), level, pos, side, queryState, queryPos);
    }

    public boolean isEmpty() {
        return this.self().getBlock().isEmpty(this.self());
    }

    public BubbleColumnDirection getBubbleColumnDirection() {
        return this.self().getBlock().getBubbleColumnDirection(this.self());
    }

    public boolean isPathfindable(PathComputationType pathComputationType) {
        return switch (pathComputationType) {
            case PathComputationType.LAND -> {
                if (!this.self().isCollisionShapeFullBlock((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO)) {
                    yield true;
                }
                yield false;
            }
            case PathComputationType.WATER -> this.self().getFluidState().is(FluidTags.WATER);
            case PathComputationType.AIR -> {
                if (!this.self().isCollisionShapeFullBlock((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.ZERO)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

