/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.capabilities;

import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.povstalec.sgjourney.common.capabilities.SGJourneyEnergy;
import net.povstalec.sgjourney.common.config.CommonZPMConfig;
import net.povstalec.sgjourney.common.init.DataComponentInit;

public abstract class ZeroPointEnergy
extends SGJourneyEnergy {
    public static final int MAX_ENTROPY = 1000;
    public static final long ENERGY_PER_ENTROPY_LEVEL = (Long)CommonZPMConfig.zpm_energy_per_level_of_entropy.get();
    protected int maxEntropy;
    protected int entropy;

    public ZeroPointEnergy(int maxEntropy, long capacity, long maxReceive, long maxExtract) {
        super(capacity, maxReceive, maxExtract);
        this.maxEntropy = maxEntropy;
        this.energy = capacity;
    }

    @Override
    public long receiveLongEnergy(long maxReceive, boolean simulate) {
        return 0L;
    }

    @Override
    public long extractLongEnergy(long maxExtract, boolean simulate) {
        int entropy;
        if (!this.canExtract() || this.entropy >= 1000) {
            return 0L;
        }
        long energy = this.energy;
        long energyExtracted = 0L;
        for (entropy = this.entropy; maxExtract >= energy && entropy < 1000; ++entropy) {
            maxExtract -= energy;
            energyExtracted += energy;
            energy = ENERGY_PER_ENTROPY_LEVEL;
        }
        if (entropy >= 1000) {
            if (!simulate) {
                this.energy = 0L;
                this.entropy = entropy;
            }
            if (energyExtracted != 0L) {
                this.onEnergyChanged(energyExtracted, simulate);
            }
            return energyExtracted;
        }
        energy -= maxExtract;
        energyExtracted += maxExtract;
        if (!simulate) {
            this.energy = energy;
            this.entropy = entropy;
        }
        if (energyExtracted != 0L) {
            this.onEnergyChanged(energyExtracted, simulate);
        }
        return energyExtracted;
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        return (Boolean)CommonZPMConfig.other_mods_use_zero_point_energy.get() != false ? ZeroPointEnergy.regularEnergy(this.extractLongEnergy(maxExtract, simulate)) : 0;
    }

    @Override
    public int getEnergyStored() {
        return ZeroPointEnergy.regularEnergy(this.getTrueEnergyStored());
    }

    @Override
    public long getTrueEnergyStored() {
        return this.energy;
    }

    public int getEntropy() {
        return this.entropy;
    }

    public int setEntropy(int entropy) {
        this.entropy = entropy;
        return this.entropy;
    }

    public boolean isNearMaxEntropy() {
        return this.entropy >= this.maxEntropy - 1;
    }

    public Tag serializeEntropy() {
        return IntTag.valueOf((int)this.entropy);
    }

    public void deserializeEntropy(Tag nbt) {
        if (!(nbt instanceof IntTag)) {
            throw new IllegalArgumentException("Can not deserialize to an instance that isn't the default implementation");
        }
        IntTag intTag = (IntTag)nbt;
        this.setEntropy(intTag.getAsInt());
    }

    public static String zeroPointEnergyToString(int entropy, long levelEnergy) {
        int prefix;
        if (entropy >= 999) {
            return SGJourneyEnergy.energyToString(levelEnergy);
        }
        double decimals = (double)levelEnergy / (double)ENERGY_PER_ENTROPY_LEVEL;
        double total = ((double)(1000 - entropy - 1) + decimals) * (double)ENERGY_PER_ENTROPY_LEVEL;
        for (prefix = -1; total >= 1000.0 && prefix < PREFIXES.length; total /= 1000.0, ++prefix) {
        }
        total *= 100.0;
        total = Math.floor(total);
        return (total /= 100.0) + " " + PREFIXES[prefix] + "FE";
    }

    public static class Item
    extends ZeroPointEnergy {
        protected ItemStack stack;

        public Item(ItemStack stack, int maxEntropy, long capacity, long maxReceive, long maxExtract) {
            super(maxEntropy, capacity, maxReceive, maxExtract);
            this.stack = stack;
            this.entropy = (Integer)stack.getOrDefault(DataComponentInit.ENTROPY, (Object)0);
            this.energy = (Long)stack.getOrDefault(DataComponentInit.ENERGY, (Object)ENERGY_PER_ENTROPY_LEVEL);
        }

        @Override
        public void onEnergyChanged(long difference, boolean simulate) {
            this.stack.set(DataComponentInit.ENTROPY, (Object)this.entropy);
            this.stack.set(DataComponentInit.ENERGY, (Object)this.energy);
        }
    }
}

