/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.compatibility.cctweaked;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.PeripheralCapability;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.povstalec.sgjourney.common.block_entities.tech_interface.AbstractInterfaceEntity;
import net.povstalec.sgjourney.common.compatibility.cctweaked.StargatePeripheralWrapper;
import net.povstalec.sgjourney.common.compatibility.cctweaked.methods.IrisMethods;
import net.povstalec.sgjourney.common.compatibility.cctweaked.methods.MilkyWayStargateMethods;
import net.povstalec.sgjourney.common.compatibility.cctweaked.methods.PegasusStargateMethods;
import net.povstalec.sgjourney.common.compatibility.cctweaked.methods.RotationMethods;
import net.povstalec.sgjourney.common.compatibility.cctweaked.methods.StargateFilterMethods;
import net.povstalec.sgjourney.common.compatibility.cctweaked.methods.StargateMethods;
import net.povstalec.sgjourney.common.compatibility.cctweaked.peripherals.StargatePeripheral;
import net.povstalec.sgjourney.common.init.BlockEntityInit;

public class CCTweakedCompatibility {
    public static void registerPeripherals(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)BlockEntityInit.BASIC_INTERFACE.get(), (blockEntity, direction) -> blockEntity.getPeripheralWrapper() != null ? (IPeripheral)blockEntity.getPeripheralWrapper().newPeripheral().get() : null);
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)BlockEntityInit.CRYSTAL_INTERFACE.get(), (blockEntity, direction) -> blockEntity.getPeripheralWrapper() != null ? (IPeripheral)blockEntity.getPeripheralWrapper().newPeripheral().get() : null);
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)BlockEntityInit.ADVANCED_CRYSTAL_INTERFACE.get(), (blockEntity, direction) -> blockEntity.getPeripheralWrapper() != null ? (IPeripheral)blockEntity.getPeripheralWrapper().newPeripheral().get() : null);
        event.registerBlockEntity(PeripheralCapability.get(), (BlockEntityType)BlockEntityInit.TRANSCEIVER.get(), (blockEntity, direction) -> blockEntity.getPeripheralWrapper() != null ? (IPeripheral)blockEntity.getPeripheralWrapper().newPeripheral().get() : null);
    }

    private static void irisMethods(StargatePeripheral peripheral) {
        peripheral.registerMethod(new IrisMethods.GetIris());
        peripheral.registerMethod(new IrisMethods.CloseIris());
        peripheral.registerMethod(new IrisMethods.OpenIris());
        peripheral.registerMethod(new IrisMethods.StopIris());
        peripheral.registerMethod(new IrisMethods.GetIrisProgress());
        peripheral.registerMethod(new IrisMethods.GetIrisProgressPercentage());
        peripheral.registerMethod(new IrisMethods.GetIrisDurability());
        peripheral.registerMethod(new IrisMethods.GetIrisMaxDurability());
    }

    private static void genericRotationMethods(StargatePeripheral peripheral) {
        peripheral.registerMethod(new RotationMethods.GetCurrentSymbol());
        peripheral.registerMethod(new RotationMethods.IsCurrentSymbol());
        peripheral.registerMethod(new RotationMethods.EncodeChevron());
        peripheral.registerMethod(new RotationMethods.GetRotation());
        peripheral.registerMethod(new RotationMethods.GetRotationDegrees());
        peripheral.registerMethod(new RotationMethods.RotateClockwise());
        peripheral.registerMethod(new RotationMethods.RotateAntiClockwise());
        peripheral.registerMethod(new RotationMethods.EndRotation());
    }

    private static void genericBasicMethods(StargatePeripheral peripheral) {
        peripheral.registerMethod(new StargateMethods.GetRecentFeedback());
        peripheral.registerMethod(new StargateMethods.SendStargateMessage());
        peripheral.registerMethod(new StargateMethods.GetStargateVariant());
        peripheral.registerMethod(new StargateMethods.GetPointOfOrigin());
        peripheral.registerMethod(new StargateMethods.GetSymbols());
        peripheral.registerMethod(new StargateMethods.HasDHD());
    }

    private static void genericCrystalMethods(StargatePeripheral peripheral) {
        peripheral.registerMethod(new StargateMethods.EngageSymbol());
        peripheral.registerMethod(new StargateMethods.DialedAddress());
    }

    private static void genericAdvancedCrystalMethods(StargatePeripheral peripheral) {
        peripheral.registerMethod(new StargateMethods.ConnectedAddress());
        peripheral.registerMethod(new StargateMethods.LocalAddress());
        peripheral.registerMethod(new StargateMethods.GetNetwork());
        peripheral.registerMethod(new StargateMethods.SetNetwork());
        peripheral.registerMethod(new StargateMethods.SetRestrictNetwork());
        peripheral.registerMethod(new StargateMethods.GetRestrictNetwork());
    }

    private static void filterMethods(StargatePeripheral peripheral) {
        peripheral.registerMethod(new StargateFilterMethods.GetFilterType());
        peripheral.registerMethod(new StargateFilterMethods.SetFilterType());
        peripheral.registerMethod(new StargateFilterMethods.AddToWhitelist());
        peripheral.registerMethod(new StargateFilterMethods.RemoveFromWhitelist());
        peripheral.registerMethod(new StargateFilterMethods.GetWhitelist());
        peripheral.registerMethod(new StargateFilterMethods.ClearWhitelist());
        peripheral.registerMethod(new StargateFilterMethods.AddToBlacklist());
        peripheral.registerMethod(new StargateFilterMethods.RemoveFromBlacklist());
        peripheral.registerMethod(new StargateFilterMethods.GetBlacklist());
        peripheral.registerMethod(new StargateFilterMethods.ClearBlacklist());
    }

    public static void registerUniverseStargateMethods(StargatePeripheralWrapper wrapper) {
        StargatePeripheral peripheral = wrapper.getPeripheral();
        AbstractInterfaceEntity.InterfaceType type = wrapper.getType();
        CCTweakedCompatibility.irisMethods(peripheral);
        CCTweakedCompatibility.genericRotationMethods(peripheral);
        CCTweakedCompatibility.genericBasicMethods(peripheral);
        if (type.hasCrystalMethods()) {
            CCTweakedCompatibility.genericCrystalMethods(peripheral);
        }
        if (type.hasAdvancedCrystalMethods()) {
            CCTweakedCompatibility.genericAdvancedCrystalMethods(peripheral);
            CCTweakedCompatibility.filterMethods(peripheral);
        }
    }

    public static void registerMilkyWayStargateMethods(StargatePeripheralWrapper wrapper) {
        StargatePeripheral peripheral = wrapper.getPeripheral();
        CCTweakedCompatibility.irisMethods(peripheral);
        peripheral.registerMethod(new RotationMethods.GetCurrentSymbol());
        peripheral.registerMethod(new RotationMethods.IsCurrentSymbol());
        peripheral.registerMethod(new RotationMethods.EncodeChevron());
        peripheral.registerMethod(new RotationMethods.GetRotation());
        peripheral.registerMethod(new RotationMethods.GetRotationDegrees());
        peripheral.registerMethod(new MilkyWayStargateMethods.RotateClockwise());
        peripheral.registerMethod(new MilkyWayStargateMethods.RotateAntiClockwise());
        peripheral.registerMethod(new RotationMethods.EndRotation());
        peripheral.registerMethod(new MilkyWayStargateMethods.OpenChevron());
        peripheral.registerMethod(new MilkyWayStargateMethods.CloseChevron());
        peripheral.registerMethod(new MilkyWayStargateMethods.IsChevronOpen());
        AbstractInterfaceEntity.InterfaceType type = wrapper.getType();
        CCTweakedCompatibility.genericBasicMethods(peripheral);
        if (type.hasCrystalMethods()) {
            peripheral.registerMethod(new StargateMethods.SetChevronConfiguration());
            CCTweakedCompatibility.genericCrystalMethods(peripheral);
        }
        if (type.hasAdvancedCrystalMethods()) {
            CCTweakedCompatibility.genericAdvancedCrystalMethods(peripheral);
            CCTweakedCompatibility.filterMethods(peripheral);
        }
    }

    public static void registerPegasusStargateMethods(StargatePeripheralWrapper wrapper) {
        StargatePeripheral peripheral = wrapper.getPeripheral();
        AbstractInterfaceEntity.InterfaceType type = wrapper.getType();
        CCTweakedCompatibility.irisMethods(peripheral);
        CCTweakedCompatibility.genericBasicMethods(peripheral);
        if (type.hasCrystalMethods()) {
            peripheral.registerMethod(new StargateMethods.SetChevronConfiguration());
            CCTweakedCompatibility.genericCrystalMethods(peripheral);
        }
        if (type.hasAdvancedCrystalMethods()) {
            CCTweakedCompatibility.genericAdvancedCrystalMethods(peripheral);
            peripheral.registerMethod(new PegasusStargateMethods.DynamicSymbols());
            peripheral.registerMethod(new PegasusStargateMethods.OverrideSymbols());
            peripheral.registerMethod(new PegasusStargateMethods.OverridePointOfOrigin());
            peripheral.registerMethod(new StargateMethods.GetRestrictNetwork());
            CCTweakedCompatibility.filterMethods(peripheral);
        }
    }

    public static void registerTollanStargateMethods(StargatePeripheralWrapper wrapper) {
        StargatePeripheral peripheral = wrapper.getPeripheral();
        AbstractInterfaceEntity.InterfaceType type = wrapper.getType();
        CCTweakedCompatibility.genericBasicMethods(peripheral);
        if (type.hasCrystalMethods()) {
            peripheral.registerMethod(new StargateMethods.SetChevronConfiguration());
            CCTweakedCompatibility.genericCrystalMethods(peripheral);
        }
        if (type.hasAdvancedCrystalMethods()) {
            CCTweakedCompatibility.genericAdvancedCrystalMethods(peripheral);
            CCTweakedCompatibility.filterMethods(peripheral);
        }
    }

    public static void registerClassicStargateMethods(StargatePeripheralWrapper wrapper) {
        StargatePeripheral peripheral = wrapper.getPeripheral();
        AbstractInterfaceEntity.InterfaceType type = wrapper.getType();
        CCTweakedCompatibility.irisMethods(peripheral);
        CCTweakedCompatibility.genericRotationMethods(peripheral);
        CCTweakedCompatibility.genericBasicMethods(peripheral);
        if (type.hasCrystalMethods()) {
            peripheral.registerMethod(new StargateMethods.SetChevronConfiguration());
            CCTweakedCompatibility.genericCrystalMethods(peripheral);
        }
        if (type.hasAdvancedCrystalMethods()) {
            CCTweakedCompatibility.genericAdvancedCrystalMethods(peripheral);
            CCTweakedCompatibility.filterMethods(peripheral);
        }
    }
}

