/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.compatibility.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.FluidInit;
import net.povstalec.sgjourney.common.recipe.AdvancedCrystallizerRecipe;

public class AdvancedCrystallizerRecipeCategory
implements IRecipeCategory<AdvancedCrystallizerRecipe> {
    public static final ResourceLocation RECIPE_ID = StargateJourney.sgjourneyLocation("advanced_crystallizing");
    public static final ResourceLocation TEXTURE = StargateJourney.sgjourneyLocation("textures/gui/jei/crystallizer_gui.png");
    public static final RecipeType<AdvancedCrystallizerRecipe> ADVANCED_CRYSTALLIZING_TYPE = RecipeType.create((String)RECIPE_ID.getNamespace(), (String)RECIPE_ID.getPath(), AdvancedCrystallizerRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public AdvancedCrystallizerRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 85);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)BlockInit.ADVANCED_CRYSTALLIZER.get()));
    }

    public RecipeType<AdvancedCrystallizerRecipe> getRecipeType() {
        return ADVANCED_CRYSTALLIZING_TYPE;
    }

    public int getWidth() {
        return 176;
    }

    public int getHeight() {
        return 85;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.sgjourney.advanced_crystallizer");
    }

    public void draw(AdvancedCrystallizerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics, 0, 1);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AdvancedCrystallizerRecipe recipe, IFocusGroup focuses) {
        ItemStack stack1 = ((Ingredient)recipe.getIngredients().get(0)).getItems()[0].copy();
        ItemStack stack2 = ((Ingredient)recipe.getIngredients().get(1)).getItems()[0].copy();
        ItemStack stack3 = ((Ingredient)recipe.getIngredients().get(2)).getItems()[0].copy();
        stack1.setCount(recipe.getAmountInSlot(0));
        stack2.setCount(recipe.getAmountInSlot(1));
        stack3.setCount(recipe.getAmountInSlot(2));
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 12, 20).addFluidStack((Fluid)FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get(), 200L).setFluidRenderer(4000L, true, 16, 54);
        builder.addSlot(RecipeIngredientRole.INPUT, 80, 20).addItemStack(stack1);
        builder.addSlot(RecipeIngredientRole.INPUT, 67, 50).addItemStack(stack2);
        builder.addSlot(RecipeIngredientRole.INPUT, 93, 50).addItemStack(stack3);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 130, 36).addItemStack(recipe.getResultItem(null));
    }
}

