/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.entities;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.povstalec.sgjourney.common.entities.PlasmaProjectile;
import net.povstalec.sgjourney.common.entities.goals.StaffWeaponAttackGoal;
import net.povstalec.sgjourney.common.init.EntityInit;
import net.povstalec.sgjourney.common.init.SoundInit;
import net.povstalec.sgjourney.common.items.StaffWeaponItem;

public abstract class Anthropoid
extends AgeableMob
implements RangedAttackMob {
    private final StaffWeaponAttackGoal staffWeaponGoal = new StaffWeaponAttackGoal<Anthropoid>(this, 1.0, 8.0f, 12.0f);
    private final RangedBowAttackGoal<Anthropoid> bowGoal = new RangedBowAttackGoal((Mob)this, 1.0, 20, 15.0f);
    private final MeleeAttackGoal meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

        public void stop() {
            super.stop();
            Anthropoid.this.setAggressive(false);
        }

        public void start() {
            super.start();
            Anthropoid.this.setAggressive(true);
        }
    };

    public Anthropoid(EntityType<? extends Anthropoid> type, Level level) {
        super(type, level);
        this.reassessWeaponGoal();
    }

    public abstract ResourceLocation texture();

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public void reassessWeaponGoal() {
        if (this.level() == null || this.level().isClientSide()) {
            return;
        }
        this.goalSelector.removeGoal((Goal)this.meleeGoal);
        this.goalSelector.removeGoal(this.bowGoal);
        this.goalSelector.removeGoal((Goal)this.staffWeaponGoal);
        ItemStack itemstack = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> Anthropoid.isWeapon(item)));
        if (itemstack.getItem() instanceof StaffWeaponItem) {
            this.goalSelector.addGoal(2, (Goal)this.staffWeaponGoal);
        } else if (itemstack.getItem() instanceof BowItem) {
            int i = 20;
            if (this.level().getDifficulty() != Difficulty.HARD) {
                i = 40;
            }
            this.bowGoal.setMinAttackInterval(i);
            this.goalSelector.addGoal(4, this.bowGoal);
        } else {
            this.goalSelector.addGoal(4, (Goal)this.meleeGoal);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setCanPickUpLoot(true);
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.reassessWeaponGoal();
        return spawnGroupData;
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.reassessWeaponGoal();
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
        super.setItemSlot(slot, stack);
        if (!this.level().isClientSide()) {
            this.reassessWeaponGoal();
        }
    }

    public void performRangedAttack(LivingEntity entity, float distanceFactor) {
        if (this.getMainHandItem().getItem() instanceof StaffWeaponItem) {
            this.performStaffWeaponAttack(entity, distanceFactor);
        } else {
            this.performBowAttack(entity, distanceFactor);
        }
    }

    protected void performBowAttack(LivingEntity entity, float distanceFactor) {
        ItemStack bow = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
        ItemStack itemstack = this.getProjectile(bow);
        AbstractArrow abstractarrow = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor, (ItemStack)bow);
        if (this.getMainHandItem().getItem() instanceof BowItem) {
            abstractarrow = ((BowItem)this.getMainHandItem().getItem()).customArrow(abstractarrow, itemstack, bow);
        }
        double d0 = entity.getX() - this.getX();
        double d1 = entity.getY(0.3333333333333333) - abstractarrow.getY();
        double d2 = entity.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)abstractarrow);
    }

    protected void performStaffWeaponAttack(LivingEntity entity, float distanceFactor) {
        StaffWeaponItem staffWeapon;
        ItemStack itemstack = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof StaffWeaponItem));
        Item item2 = itemstack.getItem();
        if (item2 instanceof StaffWeaponItem && (staffWeapon = (StaffWeaponItem)item2).tryDepleteLiquidNaquadah(itemstack)) {
            PlasmaProjectile plasmaProjectile = new PlasmaProjectile((EntityType<? extends Projectile>)((EntityType)EntityInit.JAFFA_PLASMA.get()), (LivingEntity)this, this.level(), staffWeapon.getExplosionPower(itemstack));
            double x = entity.getX() - this.getX();
            double y = entity.getY(0.3333333333333333) - plasmaProjectile.getY();
            double z = entity.getZ() - this.getZ();
            double distance = Math.sqrt(x * x + z * z);
            plasmaProjectile.shoot(x, y + distance * 0.125, z, 1.6f, 14 - this.level().getDifficulty().getId() * 4);
            this.playSound((SoundEvent)SoundInit.MATOK_FIRE.get(), 0.25f, 1.0f);
            this.level().addFreshEntity((Entity)plasmaProjectile);
        }
    }

    public static boolean isWeapon(Item item) {
        if (item instanceof SwordItem) {
            return true;
        }
        if (item instanceof StaffWeaponItem) {
            return true;
        }
        if (item instanceof BowItem) {
            return true;
        }
        return item instanceof CrossbowItem;
    }
}

