/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.entities;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.entities.Human;
import net.povstalec.sgjourney.common.entities.goals.NearestThreatGoal;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.StaffWeaponItem;

public class Jaffa
extends Human {
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"textures/entity/player/wide/efe.png");
    private static final ResourceLocation ABYDOS = StargateJourney.sgjourneyLocation("abydos");

    public Jaffa(EntityType<? extends Jaffa> type, Level level) {
        super((EntityType<? extends Human>)type, level);
    }

    @Override
    public ResourceLocation texture() {
        return TEXTURE;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, new NearestThreatGoal<Player>((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Human.createAttributes().add(Attributes.ATTACK_DAMAGE, 2.0);
    }

    protected void setupHelmet() {
        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemInit.JAFFA_HELMET.get()));
    }

    protected void setupDimensionHelmet(ServerLevelAccessor level, RandomSource randomSource) {
        if (level.getLevel().dimension().location().equals((Object)ABYDOS)) {
            this.setItemSlot(EquipmentSlot.HEAD, randomSource.nextFloat() > 0.7f ? new ItemStack((ItemLike)ItemInit.JACKAL_HELMET.get()) : new ItemStack((ItemLike)ItemInit.FALCON_HELMET.get()));
        } else {
            this.setupHelmet();
        }
    }

    protected void setupArmor() {
        this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)ItemInit.JAFFA_CHESTPLATE.get()));
        this.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)ItemInit.JAFFA_LEGGINGS.get()));
        this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)ItemInit.JAFFA_BOOTS.get()));
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        RandomSource randomSource = level.getRandom();
        spawnGroupData = super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
        this.setItemInHand(InteractionHand.MAIN_HAND, StaffWeaponItem.filledStaffWeapon(randomSource.nextFloat() > (float)difficulty.getDifficulty().getId() / 3.0f, (int)(randomSource.nextFloat() * (float)((Integer)CommonTechConfig.vial_capacity.get()).intValue())));
        if (spawnType != MobSpawnType.EVENT) {
            if (spawnType == MobSpawnType.NATURAL) {
                this.setupDimensionHelmet(level, randomSource);
            } else {
                this.setupHelmet();
            }
            this.setupArmor();
        }
        return spawnGroupData;
    }
}

