/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.entities.goals;

import java.util.EnumSet;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.povstalec.sgjourney.common.items.StaffWeaponItem;

public class StaffWeaponAttackGoal<T extends PathfinderMob>
extends MeleeAttackGoal {
    public static final int ATTACK_DELAY = 40;
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.rangeOfSeconds((int)1, (int)2);
    protected final T mob;
    protected final double speedModifier;
    protected final float meleeAttackRadiusSqr;
    protected final float pursueRadiusSqr;
    protected int seeTime;
    protected int attackDelay;
    protected int updatePathDelay;

    public StaffWeaponAttackGoal(T mob, double speedModifier, float meleeRadius, float pursueRadius) {
        super(mob, speedModifier, false);
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.meleeAttackRadiusSqr = meleeRadius * meleeRadius;
        this.pursueRadiusSqr = pursueRadius * pursueRadius;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.attackDelay = 40;
    }

    public boolean canUse() {
        return this.isValidTarget() && this.isHoldingStaffWeapon();
    }

    private boolean isHoldingStaffWeapon() {
        return this.mob.isHolding(stack -> stack.getItem() instanceof StaffWeaponItem);
    }

    private boolean staffWeaponCanFire() {
        return this.mob.isHolding(stack -> {
            StaffWeaponItem staffWeapon;
            Item patt0$temp = stack.getItem();
            return patt0$temp instanceof StaffWeaponItem && (staffWeapon = (StaffWeaponItem)patt0$temp).getFluidAmount((ItemStack)stack) > 0;
        });
    }

    public boolean canContinueToUse() {
        return this.isValidTarget() && (this.canUse() || !this.mob.getNavigation().isDone()) && this.isHoldingStaffWeapon();
    }

    private boolean isValidTarget() {
        return this.mob.getTarget() != null && this.mob.getTarget().isAlive();
    }

    public void stop() {
        super.stop();
        this.mob.setAggressive(false);
        this.mob.setTarget(null);
        this.seeTime = 0;
        if (this.mob.isUsingItem()) {
            this.mob.stopUsingItem();
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void meleeTick(LivingEntity target) {
        super.tick();
    }

    public void rangedTick(LivingEntity target, double distanceSqr) {
        boolean shouldMoveToTarget;
        boolean hasSeenTarget;
        boolean hasLineOfSight = this.mob.getSensing().hasLineOfSight((Entity)target);
        boolean bl = hasSeenTarget = this.seeTime > 0;
        if (hasLineOfSight != hasSeenTarget) {
            this.seeTime = 0;
        }
        this.seeTime = hasLineOfSight ? ++this.seeTime : --this.seeTime;
        boolean bl2 = shouldMoveToTarget = distanceSqr > (double)this.pursueRadiusSqr || this.seeTime < 5;
        if (shouldMoveToTarget) {
            --this.updatePathDelay;
            if (this.updatePathDelay <= 0) {
                this.mob.getNavigation().moveTo((Entity)target, this.speedModifier);
                this.updatePathDelay = PATHFINDING_DELAY_RANGE.sample(this.mob.getRandom());
            }
        } else {
            this.updatePathDelay = 0;
            this.mob.getNavigation().stop();
        }
        this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
        if (this.attackDelay > 0) {
            --this.attackDelay;
        } else {
            ((RangedAttackMob)this.mob).performRangedAttack(target, 1.0f);
            this.attackDelay = 40;
        }
    }

    public void tick() {
        LivingEntity target = this.mob.getTarget();
        if (target == null) {
            return;
        }
        double distanceSqr = this.mob.distanceToSqr((Entity)target);
        if (distanceSqr > (double)this.meleeAttackRadiusSqr && this.staffWeaponCanFire()) {
            this.rangedTick(target, distanceSqr);
        } else {
            this.meleeTick(target);
        }
    }
}

