/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.events;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.blocks.ProtectedBlock;
import net.povstalec.sgjourney.common.blocks.stargate.AbstractStargateBlock;
import net.povstalec.sgjourney.common.blockstates.StargatePart;
import net.povstalec.sgjourney.common.capabilities.AncientGene;
import net.povstalec.sgjourney.common.capabilities.BloodstreamNaquadah;
import net.povstalec.sgjourney.common.capabilities.GoauldHost;
import net.povstalec.sgjourney.common.config.CommonCableConfig;
import net.povstalec.sgjourney.common.config.CommonGeneticConfig;
import net.povstalec.sgjourney.common.data.Factions;
import net.povstalec.sgjourney.common.data.StargateNetwork;
import net.povstalec.sgjourney.common.data.TransporterNetwork;
import net.povstalec.sgjourney.common.entities.Human;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.TagInit;
import net.povstalec.sgjourney.common.init.VillagerInit;
import net.povstalec.sgjourney.common.items.armor.PersonalShieldItem;
import net.povstalec.sgjourney.common.misc.TreasureMapForEmeraldsTrade;

@EventBusSubscriber(modid="sgjourney", bus=EventBusSubscriber.Bus.GAME)
public class ForgeEvents {
    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        StargateNetwork.get(server).updateNetwork(server);
        StargateNetwork.get(server).addStargates(server);
        TransporterNetwork.get(server).updateNetwork(server);
    }

    @SubscribeEvent
    public static void onTick(ServerTickEvent.Pre event) {
        MinecraftServer server = event.getServer();
        Factions.get(server).tickFactions(server.getTickCount());
        StargateNetwork.get(server).handleConnections();
        TransporterNetwork.get(server).handleConnections();
    }

    private static AbstractStargateEntity getStargateAtPos(Level level, BlockPos pos, BlockState blockstate) {
        Block block = blockstate.getBlock();
        if (block instanceof AbstractStargateBlock) {
            AbstractStargateBlock stargateBlock = (AbstractStargateBlock)block;
            return stargateBlock.getStargate((BlockGetter)level, pos, blockstate);
        }
        return null;
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Level level = event.getLevel();
        Entity entity = event.getEntity();
        if (level.isClientSide()) {
            return;
        }
        Entity entity2 = event.getEntity();
        if (entity2 instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)entity2;
            AncientGene.inheritGene((Entity)villager, CommonGeneticConfig.villager_ata_gene_inheritance_chance.get());
        } else {
            entity2 = event.getEntity();
            if (entity2 instanceof Human) {
                Human human = (Human)entity2;
                AncientGene.inheritGene((Entity)human, CommonGeneticConfig.human_ata_gene_inheritance_chance.get());
            }
        }
        if (entity instanceof LightningBolt) {
            LightningBolt lightning = (LightningBolt)entity;
            Vec3 vec3 = lightning.position();
            BlockPos strikePosition = new BlockPos((int)Math.round(vec3.x), (int)Math.round(vec3.y - 1.0E-6), (int)Math.round(vec3.z));
            ArrayList<AbstractStargateEntity> list = new ArrayList<AbstractStargateEntity>();
            BlockState blockstate = level.getBlockState(strikePosition);
            AbstractStargateEntity stargateCandidate = ForgeEvents.getStargateAtPos(level, strikePosition, blockstate);
            if (stargateCandidate != null) {
                list.add(stargateCandidate);
            }
            for (Direction direction : Direction.values()) {
                BlockState state;
                BlockPos pos = strikePosition.relative(direction);
                AbstractStargateEntity stargate2 = ForgeEvents.getStargateAtPos(level, pos, state = level.getBlockState(pos));
                if (stargate2 == null) continue;
                list.add(stargate2);
            }
            HashSet set = new HashSet(list);
            set.stream().forEach(stargate -> stargate.receiveEnergy((Long)CommonCableConfig.lightning_strike_energy.get(), false));
        }
    }

    @SubscribeEvent
    public static void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        long seed = ((ServerLevel)player.level()).getSeed();
        AncientGene.inheritGene(seed += (long)player.getUUID().hashCode(), (Entity)player, CommonGeneticConfig.player_ata_gene_inheritance_chance.get());
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        Level level = entity.level();
        if (!level.dimension().location().equals((Object)StargateJourney.sgjourneyLocation("cavum_tenebrae"))) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.isCreative() && player.getAbilities().flying) {
                return;
            }
            if (player.isSpectator() && player.getAbilities().flying) {
                return;
            }
        }
        long daytime = (level.getDayTime() + 6000L) % 24000L;
        double percentage = (double)daytime / 12000.0;
        double sin = Math.sin(percentage * Math.PI - 1.5707963267948966);
        double cos = Math.cos(percentage * Math.PI - 1.5707963267948966);
        Vec3 gravityVector = new Vec3(Math.abs(cos) > 0.2 ? 0.07 * cos : 0.0, sin < 0.0 ? 0.0 : 0.07 * sin, 0.0);
        Vec3 movementVector = entity.getDeltaMovement();
        movementVector = movementVector.add(gravityVector);
        entity.setDeltaMovement(movementVector);
        entity.fallDistance *= (float)(-sin + 1.0);
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        float damage;
        Entity attacker;
        LivingEntity entity = event.getEntity();
        if (ForgeEvents.onAttackOrHurt((Entity)entity, attacker = event.getSource().getDirectEntity(), damage = event.getOriginalDamage())) {
            event.setNewDamage(0.0f);
        }
    }

    private static boolean onAttackOrHurt(Entity entity, Entity attacker, float damage) {
        Player player;
        ItemStack stack;
        if (entity instanceof Player && (stack = (player = (Player)entity).getItemBySlot(EquipmentSlot.CHEST)).is((Item)ItemInit.PERSONAL_SHIELD_EMITTER.get()) && PersonalShieldItem.getFluidAmount(stack) > 0) {
            int naquadahDepleted = (int)damage;
            PersonalShieldItem.drainNaquadah(stack, naquadahDepleted);
            if (attacker instanceof LivingEntity) {
                LivingEntity livingAttacker = (LivingEntity)attacker;
                livingAttacker.knockback(0.5, player.getX() - attacker.getX(), player.getZ() - attacker.getZ());
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onProjectileHit(ProjectileImpactEvent event) {
        Player player;
        ItemStack stack;
        EntityHitResult hitResult;
        HitResult hitResult2 = event.getRayTraceResult();
        if (hitResult2 instanceof EntityHitResult && (hitResult2 = (hitResult = (EntityHitResult)hitResult2).getEntity()) instanceof Player && (stack = (player = (Player)hitResult2).getItemBySlot(EquipmentSlot.CHEST)).is((Item)ItemInit.PERSONAL_SHIELD_EMITTER.get()) && PersonalShieldItem.getFluidAmount(stack) > 0) {
            Projectile projectile = event.getProjectile();
            int naquadahDepleted = (int)projectile.getDeltaMovement().length();
            PersonalShieldItem.drainNaquadah(stack, naquadahDepleted);
            projectile.setDeltaMovement(projectile.getDeltaMovement().reverse().scale(0.2));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        Level level = event.getLevel();
        BlockState state = level.getBlockState(pos = event.getPos());
        if (!state.canBeReplaced()) {
            pos = event.getPos().relative(event.getFace());
            state = level.getBlockState(pos);
            ItemStack stack = event.getEntity().getItemInHand(InteractionHand.MAIN_HAND);
            Block block = state.getBlock();
            if (block instanceof AbstractStargateBlock) {
                AbstractStargateBlock stargate = (AbstractStargateBlock)block;
                if (stack.getItem() instanceof BlockItem && stargate.setCover(stack, state, level, pos, event.getEntity(), InteractionHand.MAIN_HAND, event.getHitVec())) {
                    event.getEntity().swing(InteractionHand.MAIN_HAND);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        StargatePart part;
        AbstractStargateBlock stargateBlock;
        AbstractStargateEntity stargate;
        ProtectedBlock protectedBlock;
        BlockPos pos;
        Level level = event.getLevel();
        BlockState state = level.getBlockState(pos = event.getPos());
        Block block = state.getBlock();
        if (block instanceof ProtectedBlock && !(protectedBlock = (ProtectedBlock)block).hasPermissions((BlockGetter)level, pos, state, event.getEntity(), true)) {
            event.setCanceled(true);
            return;
        }
        block = state.getBlock();
        if (block instanceof AbstractStargateBlock && (stargate = (stargateBlock = (AbstractStargateBlock)block).getStargate((BlockGetter)level, pos, state)) != null && !stargate.blockCover.blockStates.isEmpty() && stargate.blockCover.getBlockAt(part = (StargatePart)((Object)state.getValue(AbstractStargateBlock.PART))).isEmpty()) {
            stargate.spawnCoverParticles();
            event.getEntity().displayClientMessage((Component)Component.translatable((String)"block.sgjourney.stargate.break_cover_blocks"), true);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        AbstractStargateBlock stargateBlock;
        AbstractStargateEntity stargate;
        BlockPos pos;
        Block player;
        Level level;
        ProtectedBlock protectedBlock;
        BlockState state = event.getState();
        Block block = state.getBlock();
        if (block instanceof ProtectedBlock && !(protectedBlock = (ProtectedBlock)block).hasPermissions((BlockGetter)(level = (player = event.getPlayer()).level()), pos = event.getPos(), state, (Player)player, false)) {
            event.setCanceled(true);
            return;
        }
        player = state.getBlock();
        if (player instanceof AbstractStargateBlock && (stargate = (stargateBlock = (AbstractStargateBlock)player).getStargate((BlockGetter)(level = (player = event.getPlayer()).level()), pos = event.getPos(), state)) != null) {
            StargatePart part;
            if (!stargate.hasPermissions((Player)player, false)) {
                event.setCanceled(true);
            } else if (!stargate.blockCover.blockStates.isEmpty() && stargate.blockCover.mineBlockAt(level, (Player)player, part = (StargatePart)((Object)event.getState().getValue(AbstractStargateBlock.PART)), pos)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onDetonate(ExplosionEvent.Detonate event) {
        Level level = event.getLevel();
        event.getAffectedBlocks().removeIf(pos -> {
            ProtectedBlock block;
            BlockState state = level.getBlockState(pos);
            Block patt0$temp = state.getBlock();
            return patt0$temp instanceof ProtectedBlock && (block = (ProtectedBlock)patt0$temp).canExplode((BlockGetter)level, (BlockPos)pos, state, event.getExplosion());
        });
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        AncientGene newAtaGene;
        AncientGene ataGene;
        BloodstreamNaquadah newBloodstreamNaquadah;
        BloodstreamNaquadah bloodstreamNaquadah;
        GoauldHost newGoauldHost;
        Player original = event.getOriginal();
        Player clone = event.getEntity();
        GoauldHost goauldHost = (GoauldHost)original.getCapability(GoauldHost.GOAULD_HOST_CAPABILITY);
        if (goauldHost != null && (newGoauldHost = (GoauldHost)clone.getCapability(GoauldHost.GOAULD_HOST_CAPABILITY)) != null) {
            newGoauldHost.copyFrom(goauldHost);
        }
        if ((bloodstreamNaquadah = (BloodstreamNaquadah)original.getCapability(BloodstreamNaquadah.BLOODSTREAM_NAQUADAH_CAPABILITY)) != null && (newBloodstreamNaquadah = (BloodstreamNaquadah)clone.getCapability(BloodstreamNaquadah.BLOODSTREAM_NAQUADAH_CAPABILITY)) != null) {
            newBloodstreamNaquadah.copyFrom(bloodstreamNaquadah);
        }
        if ((ataGene = (AncientGene)original.getCapability(AncientGene.ANCIENT_GENE_CAPABILITY)) != null && (newAtaGene = (AncientGene)clone.getCapability(AncientGene.ANCIENT_GENE_CAPABILITY)) != null) {
            newAtaGene.copyFrom(ataGene);
        }
    }

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        int villagerLevel;
        Int2ObjectMap trades;
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 1;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.PAPER, 20), new ItemStack((ItemLike)Items.EMERALD, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 1;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)BlockInit.GOLDEN_IDOL.get(), 1), new ItemStack((ItemLike)Items.EMERALD, 5), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 1;
            ((List)trades.get(villagerLevel)).add(new TreasureMapForEmeraldsTrade(8, TagInit.Structures.ON_ARCHEOLOGIST_MAPS, "filled_map.sgjourney.archeologist", (Holder<MapDecorationType>)MapDecorationTypes.RED_X, 1, 80));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 2;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)Items.COMPASS, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 2;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)Items.WRITABLE_BOOK, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 2;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.GOLD_INGOT, 3), new ItemStack((ItemLike)Items.EMERALD, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 3;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 3), new ItemStack((ItemLike)BlockInit.FIRE_PIT.get(), 4), 1, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 3;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)BlockInit.SANDSTONE_HIEROGLYPHS.get(), 3), new ItemStack((ItemLike)Items.EMERALD, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 3;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)BlockInit.SANDSTONE_WITH_LAPIS.get(), 3), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 4;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)BlockInit.STONE_SYMBOL.get(), 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 4;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)BlockInit.SANDSTONE_SYMBOL.get(), 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 4;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)BlockInit.RED_SANDSTONE_SYMBOL.get(), 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 4;
            ((List)trades.get(villagerLevel)).add((trader, rand) -> new MerchantOffer(new ItemCost((ItemLike)Items.BONE, 4), new ItemStack((ItemLike)Items.EMERALD, 1), 4, 12, 0.09f));
        }
        if (event.getType() == VillagerInit.ARCHEOLOGIST.get()) {
            trades = event.getTrades();
            villagerLevel = 5;
            ((List)trades.get(villagerLevel)).add(new TreasureMapForEmeraldsTrade.StargateMapTrade(8, "filled_map.sgjourney.chappa_ai", 80));
        }
    }
}

